/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.util.ResourceUsageHelper;
import org.ow2.jasmine.vmm.agent.driver.xen.XenHost;
import org.ow2.jasmine.vmm.agent.driver.xen.XenVirtualMachine;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class XenPerfCollector {
    static Logger logger = Logger.getLogger(XenPerfCollector.class);
    private static String PERF_DAEMON_COMMAND = "perfmondemon -a -i 5 -n 1000000";
    private static String ITERATION_SEPARATOR = "-----";
    private XenHost host;
    private RemoteExec.SSHExec sshExec;
    private StringBuffer buffer = new StringBuffer();

    public XenPerfCollector(XenHost host) {
        this.host = host;
        this.sshExec = new RemoteExec.SSHExec(host.getHostName(), "root", host.getSshAuthInfo(), PERF_DAEMON_COMMAND);
    }

    private String readKeyStringValue(StringTokenizer st, String expectedKeyName) throws ParseError {
        String key = st.nextToken();
        if (!key.equalsIgnoreCase(expectedKeyName)) {
            throw new ParseError("expecting " + expectedKeyName + " read " + key);
        }
        return st.nextToken();
    }

    private long readKeyLongValue(StringTokenizer st, String expectedKeyName) throws ParseError {
        String key = st.nextToken();
        if (!key.equalsIgnoreCase(expectedKeyName)) {
            throw new ParseError("expecting " + expectedKeyName + " read " + key);
        }
        return Long.parseLong(st.nextToken());
    }

    private float readKeyFloatValue(StringTokenizer st, String expectedKeyName) throws ParseError {
        String key = st.nextToken();
        if (!key.equalsIgnoreCase(expectedKeyName)) {
            throw new ParseError("expecting " + expectedKeyName + " read " + key);
        }
        return Float.parseFloat(st.nextToken());
    }

    private String skipVM(StringTokenizer st) {
        String t = null;
        do {
            if (st.hasMoreTokens()) continue;
            return null;
        } while (!(t = st.nextToken()).equalsIgnoreCase("IdVm") && !t.equalsIgnoreCase("Iteration"));
        return t;
    }

    private String readVMStats(StringTokenizer st, Date samplingTime) throws ParseError {
        long domId = Long.parseLong(st.nextToken());
        XenVirtualMachine currentXenVM = null;
        for (XenVirtualMachine vm : this.host.getVMs()) {
            VirtualMachineMXBean.PowerState vmState = vm.getState();
            if (vmState != VirtualMachineMXBean.PowerState.RUNNING && vmState != VirtualMachineMXBean.PowerState.PAUSED || vm.getDomID() != domId) continue;
            currentXenVM = vm;
            break;
        }
        if (currentXenVM == null) {
            XenHost.logger.debug((Object)("Skipping perf info for unknown VM domainID=" + domId));
            return this.skipVM(st);
        }
        ResourceUsage vmUsage = new ResourceUsage();
        vmUsage.setSamplingTime(samplingTime);
        this.readKeyLongValue(st, "interval");
        vmUsage.setCpuLoad(this.readKeyFloatValue(st, "cpu") / 100.0f);
        vmUsage.setMemoryUsedKBytes(this.readKeyLongValue(st, "memory"));
        ArrayList<ResourceUsage.DiskStats> diskStatsList = new ArrayList<ResourceUsage.DiskStats>();
        vmUsage.setDiskStats(diskStatsList);
        ArrayList<ResourceUsage.NetworkStats> netStatsList = new ArrayList<ResourceUsage.NetworkStats>();
        vmUsage.setNetworkStats(netStatsList);
        String t = null;
        while (st.hasMoreTokens()) {
            long writtenKBytePerSec;
            long readKBytePerSec;
            String deviceName;
            t = st.nextToken();
            if (t.equalsIgnoreCase("IO")) {
                deviceName = st.nextToken();
                readKBytePerSec = this.readKeyLongValue(st, "read");
                writtenKBytePerSec = this.readKeyLongValue(st, "write");
                ResourceUsage.DiskStats diskStats = new ResourceUsage.DiskStats();
                diskStats.setDeviceName(deviceName);
                diskStats.setDiskReadKBytePerSec(readKBytePerSec);
                diskStats.setDiskWrittenKBytesPerSec(writtenKBytePerSec);
                diskStatsList.add(diskStats);
                continue;
            }
            if (t.equalsIgnoreCase("net")) {
                deviceName = st.nextToken();
                readKBytePerSec = this.readKeyLongValue(st, "rcv");
                writtenKBytePerSec = this.readKeyLongValue(st, "tx");
                ResourceUsage.NetworkStats netStats = new ResourceUsage.NetworkStats();
                netStats.setDeviceName(deviceName);
                netStats.setNetReceivedKbitPerSec(readKBytePerSec * 8L);
                netStats.setNetTransmittedKbitPerSec(writtenKBytePerSec * 8L);
                netStatsList.add(netStats);
                continue;
            }
            currentXenVM.updateCurrentResourceUsage(vmUsage);
            return t;
        }
        currentXenVM.updateCurrentResourceUsage(vmUsage);
        return null;
    }

    private void readAllVMStats(String input) {
        StringTokenizer st = new StringTokenizer(input);
        try {
            String t = st.nextToken();
            if (!t.equalsIgnoreCase("Iteration")) {
                throw new ParseError("Cannot find iteration token");
            }
            t = st.nextToken();
            t = this.readKeyStringValue(st, "time");
            Date time = new Date(Long.parseLong(t) * 1000L);
            t = st.nextToken();
            if (!t.equalsIgnoreCase("IdVm")) {
                throw new ParseError("Cannot find token IdVm");
            }
            while ((t = this.readVMStats(st, time)) != null && t.equalsIgnoreCase("IdVm")) {
            }
            if (t != null) {
                logger.debug((Object)("???? " + t));
            }
            HashMap<String, Object> notifUserData = new HashMap<String, Object>();
            for (XenVirtualMachine vm : this.host.getVMs()) {
                if (vm.getState() != VirtualMachineMXBean.PowerState.RUNNING || vm.getResourceUsage() == null) continue;
                notifUserData.put(vm.getNameLabel(), ResourceUsageHelper.serialize(vm.getResourceUsage()));
            }
            this.host.emitNotification("host.perfreport", "Resource Usage", notifUserData);
        }
        catch (ParseError ex) {
            XenHost.logger.error((Object)"parse error", (Throwable)ex);
        }
    }

    public void start() {
        RemoteExec.SSHExecCallback stdoutCb = new RemoteExec.SSHExecCallback(){

            @Override
            public void newData(String s) {
                while (true) {
                    int i;
                    if ((i = s.indexOf(ITERATION_SEPARATOR)) == -1) break;
                    if (i <= 0) continue;
                    XenPerfCollector.this.buffer.append(s.substring(0, i - 1));
                    XenPerfCollector.this.readAllVMStats(XenPerfCollector.this.buffer.toString());
                    XenPerfCollector.this.buffer.setLength(0);
                    s = s.substring(i + ITERATION_SEPARATOR.length());
                }
                XenPerfCollector.this.buffer.append(s);
            }
        };
        RemoteExec.SSHExecCallback stderrCb = new RemoteExec.SSHExecCallback(){

            @Override
            public void newData(String s) {
            }
        };
        logger.debug((Object)("Starting perf collector daemon on host " + this.host.getHostName()));
        try {
            this.sshExec.connect(stdoutCb, stderrCb);
        }
        catch (RemoteExec.SshException ex) {
            logger.error((Object)"Failed to connect ", (Throwable)ex);
        }
    }

    public void stop() {
        this.sshExec.disconnect();
    }

    private class ParseError
    extends Exception {
        public ParseError(String msg) {
            super(msg);
        }
    }
}

