/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import java.util.UUID;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.xen.XenHost;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VnicIPSettings;

public class XenSSH {
    static Logger logger = Logger.getLogger(XenSSH.class);

    public static RemoteExec.Result createVM(XenHost host, String vmName, VMConfigSpec vmSpec, String templateFileName) throws RemoteExec.SshException {
        String command = "createVM -d " + vmSpec.getDiskSizeMB() + " -t " + templateFileName + " -m " + vmSpec.getMemorySizeMB() + " -c " + vmSpec.getNumVCPU() + " -u " + UUID.randomUUID().toString() + " " + vmName;
        logger.debug((Object)("host " + host.getHostName() + " launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result createVMDiskImages(String hostname, RemoteExec.SshAuthInfo authoInfo, String vmName, VMConfigSpec vmSpec, String templateFileName) throws RemoteExec.SshException {
        String command = "createVMDiskImages  " + vmName + " " + vmSpec.getDiskSizeMB() + " " + templateFileName + " " + vmSpec.getMemorySizeMB();
        logger.debug((Object)("host " + hostname + " launching command " + command));
        return RemoteExec.commandAsRoot(hostname, authoInfo, command);
    }

    public static RemoteExec.Result cloneVM(XenHost host, String vmName, String clonedVmName, VMCustomizationSpec custSpec) throws RemoteExec.SshException {
        String command = "cloneVM --src " + vmName + " --name " + clonedVmName + " --force ";
        if (custSpec != null) {
            if (custSpec.getGuestOsHostName() != null && !custSpec.getGuestOsHostName().equals("")) {
                command = command + " --hostname " + custSpec.getGuestOsHostName();
            }
            if (custSpec.getVnicIpSettingsList() != null) {
                VnicIPSettings nic0Settings = (VnicIPSettings)custSpec.getVnicIpSettingsList().get(0);
                if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.DHCP) {
                    command = command + " --net eth0/dhcp";
                } else if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.FIXED) {
                    command = command + " --net eth0/static/" + nic0Settings.getIpAddress() + "/" + nic0Settings.getSubnetMask() + "/" + nic0Settings.getGateway();
                }
            }
        }
        logger.debug((Object)("host " + host.getHostName() + " launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result suspendVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "virsh save " + vmName + " /tmp/" + vmName + ".snapshot";
        logger.debug((Object)("host " + host.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result resumeVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "virsh restore /tmp/" + vmName + ".snapshot";
        logger.debug((Object)("host " + host.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result pauseVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "virsh suspend " + vmName;
        logger.debug((Object)("host " + host.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result unpauseVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "virsh resume " + vmName;
        logger.debug((Object)("host " + host.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result startVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "virsh start " + vmName;
        logger.debug((Object)("host " + host.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result shutdownVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "virsh shutdown " + vmName;
        logger.debug((Object)("host " + host.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result destroyVM(XenHost host, String vmName) throws RemoteExec.SshException {
        String command = "destroyVM " + vmName;
        logger.debug((Object)("host " + host.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
    }

    public static RemoteExec.Result migrateVM(XenHost sourceHost, String vmName, String targetHostName) throws RemoteExec.SshException {
        String command = "migrateVM " + vmName + " " + targetHostName;
        logger.debug((Object)("host " + sourceHost.getHostName() + " Launching command " + command));
        return RemoteExec.commandAsRoot(sourceHost.getHostName(), sourceHost.getSshAuthInfo(), command);
    }
}

