/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xen;

import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.xen.XenHost;
import org.ow2.jasmine.vmm.agent.driver.xen.XenVMImageStore;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class XenServerPool
extends ServerPool {
    private String xenAPIPort;
    private String xenAPIUser;
    private String xenAPIPassword;
    private VirtualMachineImageStoreMXBean imageStore;
    private String vmImageStoreDir;
    private RemoteExec.SshAuthInfo defaultAuthInfo;
    private boolean runGetIpScriptRemotely;
    private String vmImageStoreHostname;

    public XenServerPool(String name, ObjectName objectName, Properties props) {
        super(name, objectName);
        this.xenAPIPort = props.getProperty("xenapiDefaulPort", "9363");
        this.xenAPIUser = props.getProperty("xenapiDefaultUser", "root");
        this.xenAPIPassword = props.getProperty("xenapiDefaultPassword");
        this.vmImageStoreDir = props.getProperty("vmImageStoreDir", "/var/xen/images/templates");
        String sshPassword = props.getProperty("sshDefaultRootPassword");
        String sshPrivateKeyFile = props.getProperty("sshDefaultPrivateKeyFile");
        this.defaultAuthInfo = new RemoteExec.SshAuthInfo(sshPassword, sshPrivateKeyFile);
        this.runGetIpScriptRemotely = Boolean.parseBoolean(props.getProperty("getip.ssh", "true"));
        this.vmImageStoreHostname = props.getProperty("vmImageStoreHostname");
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        try {
            RemoteExec.SshAuthInfo hostAuthInfo;
            for (HostMXBean host : this.hosts) {
                if (!host.getHostName().equals(hostName)) continue;
                return host;
            }
            ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
            XenHost host = XenHost.newHost(this, mbeanObjectName, hostName, new XenHost.XenAPIParams(this.xenAPIPort, this.xenAPIUser, this.xenAPIPassword), hostAuthInfo = props.get("sshRootPassword") != null ? new RemoteExec.SshAuthInfo(props.get("sshRootPassword"), null) : (props.get("sshPrivateKeyFile") != null ? new RemoteExec.SshAuthInfo(null, props.get("sshPrivateKeyFile")) : this.defaultAuthInfo));
            if (host != null) {
                AgentCommon.getMBeanServer().registerMBean(host, mbeanObjectName);
                this.hosts.add(host);
                ServerPool.logger.info((Object)("In server pool " + this.name + ": added Host MBean " + mbeanObjectName));
                if (this.imageStore == null) {
                    ObjectName defaultDataStoreName = MBeanObjectNamer.makeVMImageStoreName(hostName + ".default");
                    this.imageStore = new XenVMImageStore(defaultDataStoreName, this.vmImageStoreDir, hostName, this.defaultAuthInfo);
                    AgentCommon.getMBeanServer().registerMBean(this.imageStore, defaultDataStoreName);
                }
            }
            return host;
        }
        catch (Exception ex) {
            ServerPool.logger.error((Object)"Failed to add XenHost", (Throwable)ex);
            return null;
        }
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public boolean runGetIpScriptRemotely() {
        return this.runGetIpScriptRemotely;
    }

    public String getVmImageStoreHostname() {
        return this.vmImageStoreHostname;
    }
}

