/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FirstFitVMPlacementPolicy.java 6100 2010-02-23 14:05:27Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.domain.policy;

import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;

/**
 * FirstFitVMPlacementPolicy is a VM placement policy which chooses the first
 * host which can fit the virtual machine configuration.
 */
public class FirstFitVMPlacementPolicy implements VMPlacementPolicy {
    static Logger logger = Logger.getLogger(FirstFitVMPlacementPolicy.class);

    public FirstFitVMPlacementPolicy() {
    }

    /*
     * (non-Javadoc)
     * @see
     * org.ow2.jasmine.vmm.agent.domain.policy.VMPlacementPolicy#placeVM(org
     * .ow2.jasmine.vmm.api.ServerPoolMXBean,
     * org.ow2.jasmine.vmm.api.VMConfigSpec)
     */
    public HostMXBean placeVM(final ServerPoolMXBean serverPool, final VMConfigSpec vmSpec) {
        List<HostMXBean> hosts = serverPool.getManagedHosts();

        for (HostMXBean host : hosts) {
            try {
                if (host.getFreeMemoryMB() > vmSpec.getMemorySizeMB()) {
                    if (host.getVMImageStore().getFreeSpaceMB() > vmSpec.getDiskSizeMB()) {
                        FirstFitVMPlacementPolicy.logger.debug("First-fit VM placement selected host " + host.getHostName());
                        return host;
                    }
                }
            } catch (VMMException ex) {
                FirstFitVMPlacementPolicy.logger.error(ex);
            }
        }
        return null;
    }

}
