package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.util.Map;
import java.util.logging.Level;

import javax.management.ObjectName;

import org.apache.log4j.Logger;
import org.jinterop.dcom.common.JISystem;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.Driver;

public class HyperVDriver implements Driver {

    static protected Logger logger = Logger.getLogger(HyperVDriver.class);
    static {
        try {
            JISystem.getLogger().setLevel(Level.OFF);
        } catch (Exception ex) {
            HyperVDriver.logger.error(ex);
        }
    }

    public ServerPool newServerPool(final String name, final ObjectName objectName, final Map<String, String> attributes) {
        HyperVServerPool pool = new HyperVServerPool(name, objectName, attributes);
        return pool;
    }

}
