/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: VMwareDriver.java 6099 2010-02-23 14:02:43Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import java.io.File;
import java.util.Map;

import javax.management.ObjectName;

import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.Driver;
import org.ow2.jasmine.vmm.api.VMMException;

/**
 * VMware-vi driver. This driver encapsulates the connection to a VMware Virtual
 * Center management server using 2.0+ VMware API.
 */
public class VMwareDriver implements Driver {
    static protected Logger logger = Logger.getLogger(VMwareDriver.class);

    static final String VMWARE_KEYSTORE_FILENAME = "vmware.keystore";
    static {
        String keyStoreFileName = System.getProperty("vmm.home") + File.separator + "etc" + File.separator
            + VMwareDriver.VMWARE_KEYSTORE_FILENAME;
        VMwareDriver.logger.debug("Setting system prop javax.net.ssl.trustStore to " + keyStoreFileName);
        System.setProperty("javax.net.ssl.trustStore", keyStoreFileName);
    }

    public ServerPool newServerPool(final String name, final ObjectName objectname, final Map<String, String> attributes)
        throws IllegalArgumentException, VMMException {
        VMwareServerPool pool = new VMwareServerPool(name, objectname, attributes);
        return pool;
    }
}
