/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MBeanObjectNamer.java 6112 2010-02-23 14:51:33Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.jmx;

import javax.management.ObjectName;

import org.apache.log4j.Logger;

/**
 * The MBeanObjectNamer class is responsible for generating object names for VMM
 * managed resources compliant with the naming rules as specified in the VMM API
 * documentation
 */
public class MBeanObjectNamer {
    private static Logger logger = Logger.getLogger(MBeanObjectNamer.class);

    private static final String DOMAIN = "org.ow2.jasmine.vmm.api";

    /**
     * Builds a Host object name
     * 
     * @param path
     * @param hostName
     * @return
     */
    public final static ObjectName makeHostName(final String path, final String hostName) {
        try {
            final ObjectName name = new ObjectName(MBeanObjectNamer.DOMAIN + ":type=Host,name=" + path + ",hostname="
                + hostName);
            return name;
        } catch (Exception ex) {
            throw new IllegalArgumentException(hostName, ex);
        }
    }

    /**
     * Builds a Virtual Machine object name
     * 
     * @param path
     * @param uuid
     * @return
     */
    public final static ObjectName makeVirtualMachineName(final String path, final String uuid) {
        try {
            final ObjectName name = new ObjectName(MBeanObjectNamer.DOMAIN + ":type=VirtualMachine,name=" + path + ",uuid="
                + uuid);
            return name;
        } catch (Exception ex) {
            MBeanObjectNamer.logger.debug("path=" + path + " uuid=" + uuid);
            throw new IllegalArgumentException(uuid, ex);
        }
    }

    /**
     * Builds a Domain object name
     * 
     * @param path
     * @return
     */
    public final static ObjectName makeDomainName(final String path) {
        try {
            final ObjectName name = new ObjectName(MBeanObjectNamer.DOMAIN + ":type=Domain,name=" + path);
            return name;
        } catch (Exception ex) {
            throw new IllegalArgumentException(path, ex);
        }
    }

    /**
     * Builds a Server Pool object name
     * 
     * @param path
     * @return
     */
    public final static ObjectName makeServerPoolName(final String path) {
        try {
            final ObjectName name = new ObjectName(MBeanObjectNamer.DOMAIN + ":type=ServerPool,name=" + path);
            return name;
        } catch (Exception ex) {
            throw new IllegalArgumentException(path, ex);
        }
    }

    /**
     * Builds a Virtual Machine Image Store object name
     * 
     * @param dsName
     * @return
     */
    public final static ObjectName makeVMImageStoreName(final String dsName) {
        try {
            final ObjectName name = new ObjectName(MBeanObjectNamer.DOMAIN + ":type=VirtualMachineImageStore,name=" + dsName);
            return name;
        } catch (Exception ex) {
            throw new IllegalArgumentException(dsName, ex);
        }
    }

    /**
     * Builds a Virtual Machine Image object name
     * 
     * @param uuid
     * @return
     */
    public final static ObjectName makeVMImageName(final String uuid) {
        try {
            final ObjectName name = new ObjectName(MBeanObjectNamer.DOMAIN + ":type=VirtualMachineImage,uuid=" + uuid);
            return name;
        } catch (Exception ex) {
            throw new IllegalArgumentException(uuid, ex);
        }
    }

    /**
     * Builds a VMM agent object name
     * 
     * @return
     */
    public final static ObjectName makeAgentName() {
        try {
            final ObjectName name = new ObjectName(MBeanObjectNamer.DOMAIN + ":type=Agent");
            return name;
        } catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

}
