/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.api.DomainMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public final class Domain
extends ManagedResource
implements DomainMXBean {
    private static Logger logger = Logger.getLogger(Domain.class);
    private String name;
    private final List<DomainMXBean> subDomains = new ArrayList<DomainMXBean>();
    private final List<ServerPoolMXBean> serverPools = new ArrayList<ServerPoolMXBean>();
    private final Map<String, String> attributes = new HashMap<String, String>();

    public Domain(String name, ObjectName objectName, Map<String, String> attributes) {
        super(objectName);
        this.attributes.putAll(attributes);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<DomainMXBean> getSubDomains() {
        return this.subDomains;
    }

    public void addSubDomain(Domain d) {
        this.subDomains.add(d);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void addServerPool(ServerPool pool) {
        this.serverPools.add(pool);
    }

    public List<ServerPoolMXBean> getServerPools() {
        return this.serverPools;
    }

    private boolean areConstraintsSatisfied(Map<String, String> constraints) {
        if (constraints == null) {
            return true;
        }
        String locationConstraint = constraints.get("location");
        if (locationConstraint == null || locationConstraint.equals("")) {
            return true;
        }
        String domainLocation = this.attributes.get("location");
        if (domainLocation == null) {
            return true;
        }
        return domainLocation.equals(locationConstraint);
    }

    public VirtualMachineMXBean provisionVM(VMConfigSpec vmSpec, Map<String, String> constraints, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        VirtualMachineMXBean vm = null;
        logger.info((Object)("Domain " + this.name + ": provisioning VM(name=" + vmSpec.getName() + ",imageID=" + vmSpec.getVmImageUUID() + ")..."));
        ArrayList<VMMException> raisedExceptions = new ArrayList<VMMException>();
        if (this.areConstraintsSatisfied(constraints)) {
            for (ServerPoolMXBean serverPool : this.serverPools) {
                try {
                    vm = serverPool.provisionVM(vmSpec, constraints, sync);
                    return vm;
                }
                catch (VMMException ex) {
                    raisedExceptions.add(ex);
                }
            }
        } else {
            throw new InsufficientResourcesException("Cannot meet constraints");
        }
        for (DomainMXBean subDomain : this.subDomains) {
            try {
                vm = subDomain.provisionVM(vmSpec, constraints, sync);
                return vm;
            }
            catch (VMMException ex) {
                raisedExceptions.add(ex);
            }
        }
        for (VMMException ex : raisedExceptions) {
            if (!(ex instanceof InsufficientResourcesException)) continue;
            throw (InsufficientResourcesException)ex;
        }
        for (VMMException ex : raisedExceptions) {
            if (!(ex instanceof InvalidVMConfigException)) continue;
            throw (InvalidVMConfigException)ex;
        }
        Iterator<Object> i$ = raisedExceptions.iterator();
        if (i$.hasNext()) {
            VMMException ex;
            ex = (VMMException)((Object)i$.next());
            throw ex;
        }
        throw new InsufficientResourcesException();
    }
}

