/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.policy.VMPlacementPolicy;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;

public class RoomForGrowthVMPlacementPolicy
implements VMPlacementPolicy {
    static Logger logger = Logger.getLogger(RoomForGrowthVMPlacementPolicy.class);

    @Override
    public HostMXBean placeVM(ServerPoolMXBean serverPool, VMConfigSpec vmSpec) {
        List hosts = serverPool.getManagedHosts();
        ArrayList<HostMXBean> candidateHostList = new ArrayList<HostMXBean>();
        for (HostMXBean host : hosts) {
            try {
                if (host.getFreeMemoryMB() <= vmSpec.getMemorySizeMB() || host.getVMImageStore().getFreeSpaceMB() <= (long)vmSpec.getDiskSizeMB()) continue;
                candidateHostList.add(host);
            }
            catch (VMMException ex) {
                logger.error((Object)ex);
            }
        }
        Collections.sort(candidateHostList, new Comparator<HostMXBean>(){

            @Override
            public int compare(HostMXBean h1, HostMXBean h2) {
                try {
                    long freeMem1 = h1.getFreeMemoryMB();
                    long freeMem2 = h2.getFreeMemoryMB();
                    return (int)(freeMem2 - freeMem1);
                }
                catch (VMMException ex) {
                    logger.error((Object)ex);
                    return 0;
                }
            }
        });
        try {
            for (HostMXBean host : candidateHostList) {
                logger.debug((Object)("\t" + host.getHostName() + " freeMemMB=" + host.getFreeMemoryMB() + "MB"));
            }
            logger.debug((Object)("Room-for-growth policy selected host: " + (candidateHostList.size() > 0 ? ((HostMXBean)candidateHostList.get(0)).getHostName() : "none")));
        }
        catch (VMMException ex) {
            // empty catch block
        }
        return candidateHostList.size() > 0 ? (HostMXBean)candidateHostList.get(0) : null;
    }
}

