/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.dummy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyHost;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

class DummyServerPool
extends ServerPool {
    protected static Logger logger = Logger.getLogger(DummyServerPool.class);
    private static VirtualMachineImageStoreMXBean imageStore;

    public DummyServerPool(String name, ObjectName objectName) {
        super(name, objectName);
        if (imageStore == null) {
            ObjectName storeObjectName = MBeanObjectNamer.makeVMImageStoreName(name);
            imageStore = new DummyVirtualMachineImageStore(storeObjectName);
            try {
                AgentCommon.getMBeanServer().registerMBean(imageStore, storeObjectName);
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot register Dummy VMImageStore", (Throwable)ex);
            }
        }
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        ObjectName objectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
        DummyHost host = new DummyHost(this, hostName, objectName);
        try {
            AgentCommon.getMBeanServer().registerMBean(host, objectName);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to register MBean " + objectName), (Throwable)ex);
            return null;
        }
        this.addHost(host);
        return host;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return imageStore;
    }

    static class DummyVirtualMachineImageStore
    extends ManagedResource
    implements VirtualMachineImageStoreMXBean {
        private static long INIT_STORAGE_CAPACITY_MB = 131072L;
        private ArrayList<DummyVirtualMachineImage> images = new ArrayList();
        private long freeSpaceMB;

        public DummyVirtualMachineImageStore(ObjectName objectName) {
            super(objectName);
            this.addImage("vmiTest", "Used by unit tests");
            this.addImage("vmi222", "Debian Lenny");
            this.addImage("vmi333", "Fedora 10");
            this.freeSpaceMB = INIT_STORAGE_CAPACITY_MB;
        }

        private void addImage(String uuid, String name) {
            try {
                ObjectName on = MBeanObjectNamer.makeVMImageName(uuid);
                DummyVirtualMachineImage image = new DummyVirtualMachineImage(on, uuid, name);
                AgentCommon.getMBeanServer().registerMBean(image, on);
                this.images.add(image);
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to register VMImage with uuid=" + uuid), (Throwable)ex);
            }
        }

        public long getCapacityMB() {
            return INIT_STORAGE_CAPACITY_MB;
        }

        public long getFreeSpaceMB() {
            return this.freeSpaceMB;
        }

        void updateFreeSpace(long deltaMB) {
            this.freeSpaceMB += deltaMB;
        }

        public String getName() {
            return "ImageStore(default)";
        }

        public VirtualMachineImageMXBean lookUpByUUID(String uuid) {
            for (DummyVirtualMachineImage image : this.images) {
                if (!image.getUUID().equals(uuid)) continue;
                return image;
            }
            return null;
        }

        public List<VirtualMachineImageMXBean> listVMImageTemplates() {
            ArrayList<VirtualMachineImageMXBean> result = new ArrayList<VirtualMachineImageMXBean>(this.images);
            return result;
        }

        public void removeVMImageTemplate(VirtualMachineImageMXBean image) throws VMMException {
            for (DummyVirtualMachineImage im : this.images) {
                if (!im.getUUID().equals(image.getUUID())) continue;
                this.images.remove(image);
            }
        }
    }

    private static class DummyVirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String uuid;
        private String name;
        private String metaData;

        public DummyVirtualMachineImage(ObjectName objectName, String uuid, String name) {
            super(objectName);
            this.metaData = this.metaData;
            this.name = name;
            this.uuid = uuid;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getMetaData() {
            return null;
        }

        public String getDescription() {
            return "a dummy image";
        }
    }
}

