/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.libvirt;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtHost;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtVirtualMachine;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.virtimage.FileUtils;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;
import org.ow2.jasmine.vmm.api.VnicIPSettings;
import org.w3c.dom.Document;

public class ImageCatalog
extends ManagedResource
implements VirtualMachineImageStoreMXBean {
    static Logger logger = Logger.getLogger(ImageCatalog.class);
    private String rootDirectory;
    private String storeServer;
    private RemoteExec.SshAuthInfo authInfo;
    private CopyOnWriteArrayList<VirtualMachineImage> vmList = new CopyOnWriteArrayList();

    public ImageCatalog(ObjectName objectName, String rootDirectory, String storeServer, RemoteExec.SshAuthInfo authInfo) throws VMMException {
        super(objectName);
        this.storeServer = storeServer;
        this.rootDirectory = rootDirectory;
        if (rootDirectory.endsWith("/")) {
            this.rootDirectory = rootDirectory.substring(0, rootDirectory.length() - 1);
        }
        this.authInfo = authInfo;
        this.sync();
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void removeVMImageTemplate(VirtualMachineImageMXBean vmImage) throws VMMException {
        String vmImageID = vmImage.getUUID();
        try {
            String command = "rm -fr " + this.rootDirectory + "/" + vmImageID + ".template";
            logger.debug((Object)("Removing VM image: " + command));
            RemoteExec.Result result = RemoteExec.commandAsRoot(this.storeServer, this.authInfo, command);
            if (result.exitCode != 0) {
                logger.error((Object)result.error);
                throw new VMMException(result.error);
            }
        }
        catch (Exception ex) {
            throw new VMMException(ex.getMessage());
        }
    }

    synchronized void sync() throws VMMException {
        String[] imageFileNames;
        RemoteExec.Result result;
        try {
            String command = "ls -d1 " + this.rootDirectory + "/*.template";
            logger.debug((Object)("Listing VM images: " + command));
            result = RemoteExec.commandAsRoot(this.storeServer, this.authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            throw new VMMException(ex.getMessage());
        }
        if (result.exitCode != 0) {
            logger.error((Object)result.error);
            throw new VMMException(result.error);
        }
        for (String fileName : imageFileNames = result.output.split("\\s+")) {
            String uuid = fileName.substring(0, fileName.length() - ".template".length());
            if (this.lookUpByUUID(uuid = uuid.substring(1 + uuid.lastIndexOf("/"))) != null) continue;
            ObjectName objName = MBeanObjectNamer.makeVMImageName(uuid);
            try {
                VirtualMachineImage image = new VirtualMachineImage(objName, uuid, fileName);
                AgentCommon.getMBeanServer().registerMBean(image, image.getObjectName());
                this.vmList.add(image);
                logger.info((Object)("Added VMImage " + image.name + " (" + image.description + ")"));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to add VMImage MBean", (Throwable)ex);
            }
        }
        for (VirtualMachineImage image : this.vmList) {
            boolean match = false;
            for (String fileName : imageFileNames) {
                String uuid = fileName.substring(0, fileName.length() - ".template".length());
                uuid = uuid.substring(1 + uuid.lastIndexOf("/"));
                if (!image.getUUID().equals(uuid)) continue;
                match = true;
                break;
            }
            if (match) continue;
            try {
                AgentCommon.getMBeanServer().unregisterMBean(MBeanObjectNamer.makeVMImageName(image.getUUID()));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to unregister VMImage MBean", (Throwable)ex);
            }
            this.vmList.remove(image);
        }
    }

    public VirtualMachineImageMXBean newVMImageTemplate(LibvirtVirtualMachine vm, String name, String description, Map<String, String> metadata) throws InsufficientResourcesException, IllegalOperationException, BadVMPowerStateException, VMMException {
        if (vm.getHostMBean().getVMImageStore() != this) {
            throw new IllegalOperationException("VM is not attached to this ImageStore");
        }
        if (vm.getState() == VirtualMachineMXBean.PowerState.RUNNING) {
            throw new BadVMPowerStateException("Cannot make a template from a running VM");
        }
        String uuid = name + "-" + UUID.randomUUID();
        List<String> disks = vm.getDiskFiles();
        if (disks == null || disks.size() == 0) {
            throw new IllegalOperationException("No disks found on this VM");
        }
        RemoteExec.Result result = null;
        try {
            String command = this.rootDirectory + "/makeNewVMTemplate --vm " + vm.getNameLabel() + " --uuid " + uuid + " --name \"" + name + "\" --desc \"" + description + " \" " + " --disk " + disks.get(0);
            logger.debug((Object)("Launching command " + command));
            result = RemoteExec.commandAsRoot(this.storeServer, this.authInfo, command);
        }
        catch (Exception ex) {
            logger.error((Object)("SSH failure with host " + this.storeServer), (Throwable)ex);
            throw new VMMException(ex.toString());
        }
        if (result.exitCode != 0) {
            logger.error((Object)("makeNewVMTemplate failed: " + result.error));
            throw new VMMException(result.error);
        }
        this.sync();
        VirtualMachineImageMXBean image = this.lookUpByUUID(uuid);
        if (image == null) {
            throw new VMMException("Failed to locate image with uuid " + uuid);
        }
        return image;
    }

    public VirtualMachineImageMXBean lookUpByName(String name) {
        for (VirtualMachineImage image : this.vmList) {
            if (!image.getName().equals(name)) continue;
            return image;
        }
        return null;
    }

    public VirtualMachineImageMXBean lookUpByUUID(String uuid) {
        for (VirtualMachineImage image : this.vmList) {
            if (!image.getUUID().equals(uuid)) continue;
            return image;
        }
        return null;
    }

    public List<VirtualMachineImageMXBean> listVMImageTemplates() {
        ArrayList<VirtualMachineImageMXBean> result = new ArrayList<VirtualMachineImageMXBean>(this.vmList);
        return result;
    }

    public long getCapacityMB() {
        return FileUtils.getDiskCapacityMB(this.storeServer, this.authInfo, this.rootDirectory);
    }

    public long getFreeSpaceMB() {
        return FileUtils.getDiskFreeSpaceMB(this.storeServer, this.authInfo, this.rootDirectory);
    }

    public String getName() {
        return "ImageStore(" + this.rootDirectory + ")";
    }

    public class VirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String name;
        private String uuid;
        private String description;
        private String dir;

        private VirtualMachineImage(ObjectName objectName, String uuid, String dir) {
            super(objectName);
            this.uuid = uuid;
            this.dir = dir;
            try {
                this.readMetaData();
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to read metatdata for VM image " + uuid), (Throwable)ex);
            }
        }

        private void readMetaData() throws Exception {
            String command = "cat " + this.dir + "/metadata.xml";
            RemoteExec.Result result = RemoteExec.commandAsRoot(ImageCatalog.this.storeServer, ImageCatalog.this.authInfo, command);
            if (result.exitCode != 0) {
                throw new Exception(result.error);
            }
            String metaData = result.output;
            Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(metaData.getBytes("UTF-8")));
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xPath.compile("/virtualMachineImage/description");
            this.description = (String)xPathExpression.evaluate(xmlDocument, XPathConstants.STRING);
            xPathExpression = xPath.compile("/virtualMachineImage/@name");
            this.name = (String)xPathExpression.evaluate(xmlDocument, XPathConstants.STRING);
        }

        public Map<String, String> getMetaData() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUUID() {
            return this.uuid;
        }

        public void newVM(VMConfigSpec vmSpec, String vmName, LibvirtHost host) throws VMMException {
            RemoteExec.Result result;
            String command = this.dir + "/createVM --name " + vmName + " --ncpu " + vmSpec.getNumVCPU() + " --memoryMB " + vmSpec.getMemorySizeMB() + " --diskSizeMB " + vmSpec.getDiskSizeMB() + " --targetDir " + host.serverPool.getSharedDiskStoreDir();
            if (vmSpec.getGuestOsHostName() != null && !vmSpec.getGuestOsHostName().equals("")) {
                command = command + " --custom --hostname " + vmSpec.getGuestOsHostName();
            }
            if (vmSpec.getVnicIpSettingsList() != null) {
                VnicIPSettings nic0Settings = (VnicIPSettings)vmSpec.getVnicIpSettingsList().get(0);
                if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.DHCP) {
                    command = command + " --custom --net eth0/dhcp";
                } else if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.FIXED) {
                    command = command + " --custom --net eth0/static/" + nic0Settings.getIpAddress() + "/" + nic0Settings.getSubnetMask() + "/" + nic0Settings.getGateway();
                }
            }
            logger.debug((Object)("VMImage " + this.name + " NewVM: launching command " + command));
            try {
                result = RemoteExec.commandAsRoot(host.getHostName(), host.getSshAuthInfo(), command);
            }
            catch (RemoteExec.SshException ex) {
                throw new VMMException("VM creation failed: SSH connection failure", (Throwable)ex);
            }
            if (result.exitCode != 0) {
                throw new VMMException("VM creation failed: " + result.error);
            }
        }
    }
}

