/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.libvirt;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibvirtConfigFileUtils {
    static Logger logger = Logger.getLogger(LibvirtConfigFileUtils.class);

    public static Object getConfigItem(String xmlConfig, String xpathExpression, QName returnType) {
        XPath xPath;
        Document xmlDocument;
        try {
            xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlConfig.getBytes("UTF-8")));
            xPath = XPathFactory.newInstance().newXPath();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        try {
            XPathExpression xPathExpression = xPath.compile(xpathExpression);
            return xPathExpression.evaluate(xmlDocument, returnType);
        }
        catch (XPathExpressionException ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public static List<String> getDiskDevices(String xmlConfig) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nl = (NodeList)LibvirtConfigFileUtils.getConfigItem(xmlConfig, "/domain/devices/disk/target", XPathConstants.NODESET);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            result.add(n.getAttributes().getNamedItem("dev").getNodeValue());
        }
        return result;
    }

    public static List<String> getDiskFiles(String xmlConfig) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nl = (NodeList)LibvirtConfigFileUtils.getConfigItem(xmlConfig, "/domain/devices/disk/source", XPathConstants.NODESET);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            result.add(n.getAttributes().getNamedItem("file").getNodeValue());
        }
        return result;
    }

    public static List<String> getNetDevices(String xmlConfig) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nl = (NodeList)LibvirtConfigFileUtils.getConfigItem(xmlConfig, "/domain/devices/interface/target", XPathConstants.NODESET);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            result.add(n.getAttributes().getNamedItem("dev").getNodeValue());
        }
        return result;
    }
}

