/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.libvirt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.LibvirtException;
import org.libvirt.NodeInfo;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.libvirt.ImageCatalog;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtPerfCollector;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtServerPool;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtVirtualMachine;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;
import org.ow2.jasmine.vmm.api.VnicIPSettings;

public class LibvirtHost
extends ManagedResource
implements HostMXBean,
NotificationEmitter {
    static Logger logger = Logger.getLogger(LibvirtHost.class);
    private static final int MAX_PARALEL_VM_CREATION_PER_HOST = 3;
    private static final int THREADPOOL_SIZE = 3;
    private static ExecutorService executorService = Executors.newFixedThreadPool(3);
    private List<LibvirtVirtualMachine> vmList = new CopyOnWriteArrayList<LibvirtVirtualMachine>();
    LibvirtServerPool serverPool;
    private LibvirtPerfCollector perfCollectionTask;
    private String hostName;
    private Connect connection;
    private int numCPU = -1;
    private long cpuFrequencyMhz = -1L;
    private RemoteExec.SshAuthInfo authInfo;
    private HostSynchronizer hostSynchronizer;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod;
    private HashMap<String, String> hypervisorInfo;
    private HashMap<String, String> cpuInfo;

    public static LibvirtHost newHost(LibvirtServerPool serverPool, ObjectName objectName, String hostName, String uri, RemoteExec.SshAuthInfo authInfo) {
        try {
            logger.debug((Object)("Connecting to libvirt with URI " + uri));
            Connect connection = new Connect(uri);
            return new LibvirtHost(serverPool, connection, objectName, hostName, authInfo);
        }
        catch (LibvirtException ex) {
            logger.error((Object)("Failed to establish libvirt connection with uri " + uri), (Throwable)ex);
            return null;
        }
    }

    private LibvirtHost(LibvirtServerPool serverPool, Connect connection, ObjectName objectName, String hostName, RemoteExec.SshAuthInfo authInfo) {
        super(objectName);
        this.serverPool = serverPool;
        this.connection = connection;
        this.hostName = hostName;
        this.authInfo = authInfo;
        this.hostSynchronizer = new HostSynchronizer(serverPool.getSyncPeriodMillis());
        this.hostSynchronizer.start();
        this.startPerfMonitor();
    }

    public boolean isConnectionLost() {
        return true;
    }

    public RemoteExec.SshAuthInfo getSshAuthInfo() {
        return this.authInfo;
    }

    Connect getLibvirtAPIConnection() {
        return this.connection;
    }

    List<LibvirtVirtualMachine> getVMs() {
        return this.vmList;
    }

    LibvirtVirtualMachine lookUpVMByName(String name) {
        for (LibvirtVirtualMachine vm : this.vmList) {
            if (!vm.getNameLabel().equals(name)) continue;
            return vm;
        }
        return null;
    }

    private void addVM(LibvirtVirtualMachine vm) {
        this.vmList.add(vm);
    }

    private void removeVM(LibvirtVirtualMachine vm) {
        this.vmList.remove(vm);
    }

    public ServerPoolMXBean getServerPool() {
        return this.serverPool;
    }

    public void postMigrateVM(LibvirtVirtualMachine vm, LibvirtHost newHost) {
        this.removeVM(vm);
        newHost.addVM(vm);
    }

    public void onVMDestroy(LibvirtVirtualMachine vm) {
        this.removeVM(vm);
        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
    }

    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 1000L) {
            periodMillis = 1000L;
        }
        if (metricsOfInterest.contains(HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            this.startPerfMonitor();
        }
    }

    String getIPAddress(String macAddress) {
        macAddress = macAddress.toUpperCase();
        logger.debug((Object)("Determining IP address from MAC address " + macAddress + " ..."));
        RemoteExec.Result result = null;
        String command = "getIPfromMAC.sh " + macAddress;
        logger.debug((Object)("Launching command: " + command));
        try {
            result = RemoteExec.commandAsRoot(this.hostName, this.authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            logger.debug((Object)"SSH failure", (Throwable)ex);
            return null;
        }
        if (result.exitCode != 0) {
            logger.error((Object)("Cannot get IP from MAC " + result.output));
            return null;
        }
        String ipAddress = result.output;
        if (ipAddress != null && ipAddress.length() > 0 && ipAddress.endsWith("\n")) {
            ipAddress = ipAddress.substring(0, ipAddress.length() - 1);
        }
        logger.debug((Object)("Mac-to-IP " + macAddress + " -> " + ipAddress));
        return ipAddress;
    }

    private synchronized void startPerfMonitor() {
        if (this.perfCollectionTask == null) {
            this.perfCollectionTask = new LibvirtPerfCollector(this);
            this.perfCollectionTask.start();
        }
    }

    private synchronized void stopPerfMonitor() {
        if (this.perfCollectionTask != null) {
            this.perfCollectionTask.stop();
            this.perfCollectionTask = null;
        }
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            try {
                this.hypervisorInfo.put("name", this.connection.getType());
                long v = this.connection.getVersion();
                long major = v / 1000000L;
                long minor = (v - major * 1000000L) / 1000L;
                this.hypervisorInfo.put("version", "" + major + "." + minor);
            }
            catch (LibvirtException ex) {
                logger.error((Object)"Failed to get hypervisor info", (Throwable)ex);
            }
        }
        return this.hypervisorInfo;
    }

    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            NodeInfo nodeInfo;
            this.cpuInfo = new HashMap();
            try {
                nodeInfo = this.connection.nodeInfo();
            }
            catch (LibvirtException e) {
                e.printStackTrace();
                return this.cpuInfo;
            }
            this.cpuInfo.put("model", new String(nodeInfo.model));
            this.cpuInfo.put("speedMHz", Integer.toString(nodeInfo.mhz));
            this.numCPU = nodeInfo.cpus;
        }
        return this.cpuInfo;
    }

    public int getNumCPU() {
        if (this.numCPU == -1) {
            this.getCPUInfo();
        }
        return this.numCPU;
    }

    public String getHostName() {
        return this.hostName;
    }

    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.serverPool.getVMImageStore();
    }

    public long getFreeMemoryMB() {
        long freeMemKB = -1L;
        try {
            freeMemKB = this.connection.getFreeMemory();
        }
        catch (LibvirtException ex) {
            logger.error((Object)ex);
        }
        return freeMemKB / 0x100000L;
    }

    public void sync() {
        this.hostSynchronizer.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doSync() {
        try {
            int[] domIDs;
            String[] vmNames;
            for (String vmName : vmNames = this.connection.listDefinedDomains()) {
                LibvirtVirtualMachine vm;
                Domain domain = this.connection.domainLookupByName(vmName);
                String uuid = domain.getUUIDString();
                ObjectName name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, uuid);
                if (AgentCommon.getMBeanServer().isRegistered(name)) {
                    vm = this.lookUpVMByName(vmName);
                    if (vm == null) continue;
                    vm.setSynchronized(true);
                    continue;
                }
                vm = new LibvirtVirtualMachine(name, this, domain, null);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
                this.emitNotification("vm.add", "Created", name);
            }
            for (int domID : domIDs = this.connection.listDomains()) {
                LibvirtVirtualMachine vm;
                Domain domain = this.connection.domainLookupByID(domID);
                String uuid = domain.getUUIDString();
                String vmName = domain.getName();
                if (vmName.equals("Domain-0")) {
                    uuid = this.hostName;
                }
                ObjectName name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, uuid);
                if (AgentCommon.getMBeanServer().isRegistered(name)) {
                    vm = this.lookUpVMByName(vmName);
                    if (vm == null) continue;
                    vm.setSynchronized(true);
                    continue;
                }
                vm = new LibvirtVirtualMachine(name, this, domain, null);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
                this.emitNotification("vm.add", "Created", name);
            }
            for (LibvirtVirtualMachine vm : this.vmList) {
                try {
                    if (vm.isMigrating()) continue;
                    if (!vm.isSynchronized()) {
                        this.removeVM(vm);
                        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
                        AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
                        continue;
                    }
                    vm.getState();
                }
                finally {
                    vm.setSynchronized(false);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> result = new ArrayList<VirtualMachineMXBean>(this.vmList);
        return result;
    }

    public VirtualMachineMXBean createVM(VMConfigSpec vmSpecIn, boolean sync) throws InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec = new VMConfigSpec(vmSpecIn);
        logger.info((Object)("Creating new VM [name=" + vmSpec.getName() + ",memorySizeMB=" + vmSpec.getMemorySizeMB() + ",diskSize=" + vmSpec.getDiskSizeMB() + ",numVCPU=" + vmSpec.getNumVCPU() + "]"));
        final ImageCatalog.VirtualMachineImage template = (ImageCatalog.VirtualMachineImage)this.serverPool.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID());
        if (template == null) {
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        final String vmName = vmSpec.getName();
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LibvirtHost.this.createVM2(vmSpec, vmName, template);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.createVM2(vmSpec, vmName, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean createVM2(VMConfigSpec vmSpec, String vmName, ImageCatalog.VirtualMachineImage template) throws InvalidVMConfigException, VMMException {
        template.newVM(vmSpec, vmName, this);
        LibvirtHost libvirtHost = this;
        synchronized (libvirtHost) {
            String vmUUID = null;
            ObjectName name = null;
            LibvirtVirtualMachine vm = null;
            Domain domain = null;
            try {
                domain = this.connection.domainLookupByName(vmName);
                vmUUID = domain.getUUIDString();
                name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, vmUUID);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("imageID", vmSpec.getVmImageUUID());
                domain = this.connection.domainLookupByName(vmName);
                vm = new LibvirtVirtualMachine(name, this, domain, map);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
                throw new VMMException((Throwable)ex);
            }
            this.emitNotification("vm.add", "Created", name);
            return vm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachineMXBean cloneVM(String targetVmName, String clonedVmName, VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, VMMException {
        RemoteExec.Result result;
        String command = "cloneVM --src " + clonedVmName + " --name " + targetVmName + " --force ";
        if (custSpec != null) {
            if (custSpec.getGuestOsHostName() != null && !custSpec.getGuestOsHostName().equals("")) {
                command = command + " --hostname " + custSpec.getGuestOsHostName();
            }
            if (custSpec.getVnicIpSettingsList() != null) {
                VnicIPSettings nic0Settings = (VnicIPSettings)custSpec.getVnicIpSettingsList().get(0);
                if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.DHCP) {
                    command = command + " --net eth0/dhcp";
                } else if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.FIXED) {
                    command = command + " --net eth0/static/" + nic0Settings.getIpAddress() + "/" + nic0Settings.getSubnetMask() + "/" + nic0Settings.getGateway();
                }
            }
        }
        try {
            result = RemoteExec.commandAsRoot(this.getHostName(), this.getSshAuthInfo(), command);
        }
        catch (RemoteExec.SshException ex) {
            throw new VMMException("VM cloning failed: SSH connection failure", (Throwable)ex);
        }
        if (result.exitCode != 0) {
            throw new VMMException("VM cloning failed: " + result.error);
        }
        Domain newVM = null;
        String vmUUID = "";
        try {
            newVM = this.connection.domainLookupByName(clonedVmName);
            vmUUID = newVM.getUUIDString();
        }
        catch (LibvirtException ex) {
            logger.error((Object)("Failed to look up VM " + clonedVmName));
            throw new VMMException("VM cloning failure");
        }
        LibvirtHost libvirtHost = this;
        synchronized (libvirtHost) {
            ObjectName name = null;
            LibvirtVirtualMachine vm = null;
            try {
                name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + clonedVmName, vmUUID);
                HashMap<String, String> map = new HashMap<String, String>();
                vm = new LibvirtVirtualMachine(name, this, newVM, map);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
                throw new VMMException((Throwable)ex);
            }
            this.emitNotification("vm.add", "Created", name);
            return vm;
        }
    }

    public long getTotalMemoryMB() {
        NodeInfo nodeInfo;
        try {
            nodeInfo = this.connection.nodeInfo();
        }
        catch (LibvirtException e) {
            e.printStackTrace();
            return -1L;
        }
        return nodeInfo.memory / 1024L;
    }

    public float[] getLoadPerCPU() {
        float[] result = new float[]{};
        return result;
    }

    public float getCPULoad() {
        float aggregatedCPULoad = 0.0f;
        for (LibvirtVirtualMachine vm : this.vmList) {
            aggregatedCPULoad += vm.getResourceUsage().getCpuLoad();
        }
        return aggregatedCPULoad;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.del", "vm.error", "log"}, Notification.class.getName(), "Host event")};
    }

    public Map<String, ResourceUsage> getVMResourceUsage() {
        HashMap<String, ResourceUsage> result = new HashMap<String, ResourceUsage>();
        for (LibvirtVirtualMachine vm : this.vmList) {
            result.put(vm.getNameLabel(), vm.getResourceUsage());
        }
        return result;
    }

    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        for (LibvirtVirtualMachine vm : this.vmList) {
            cpuLoads.put(vm.getNameLabel(), Float.valueOf(vm.getResourceUsage().getCpuLoad()));
        }
        return cpuLoads;
    }

    private class HostSynchronizer
    implements Runnable {
        private long periodMillis;
        private volatile boolean stopRequested;
        private Thread thread;

        HostSynchronizer(long periodMillis) {
            this.periodMillis = periodMillis;
        }

        public void requestStop() {
            this.stopRequested = true;
        }

        void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        synchronized void sync() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopRequested) {
                LibvirtHost.this.doSync();
                HostSynchronizer hostSynchronizer = this;
                synchronized (hostSynchronizer) {
                    try {
                        this.wait(this.periodMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

