/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.libvirt;

import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.libvirt.ImageCatalog;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtHost;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class LibvirtServerPool
extends ServerPool {
    static Logger logger = Logger.getLogger(LibvirtServerPool.class);
    static long DEFAULT_HOST_SYNC_PERIOD_MILLIS = 10000L;
    private RemoteExec.SshAuthInfo defaultAuthInfo;
    private String vmImageStoreDir;
    private String diskStoreDir;
    private String vmImageStoreHostname;
    private VirtualMachineImageStoreMXBean imageStore;
    private long syncPeriodMillis = DEFAULT_HOST_SYNC_PERIOD_MILLIS;

    public LibvirtServerPool(String name, ObjectName objectName, Map<String, String> attributes) throws IllegalArgumentException {
        super(name, objectName);
        String sshPassword = attributes.get("sshRootPassword");
        String sshPrivateKeyFile = attributes.get("sshPrivateKeyFile");
        if (sshPassword != null || sshPrivateKeyFile != null) {
            this.defaultAuthInfo = new RemoteExec.SshAuthInfo(sshPassword, sshPrivateKeyFile);
        }
        this.vmImageStoreDir = attributes.get("sharedImageStore");
        if (this.vmImageStoreDir == null) {
            throw new IllegalArgumentException("Missing parameter: vmImageStoreDir");
        }
        if (this.vmImageStoreDir != null) {
            this.vmImageStoreHostname = attributes.get("imageStoreHost");
        }
        this.diskStoreDir = attributes.get("sharedDiskStore");
        if (this.diskStoreDir == null) {
            throw new IllegalArgumentException("Missing parameter: sharedDiskStore");
        }
        String period = attributes.get("syncPeriodMillis");
        if (period != null) {
            try {
                this.syncPeriodMillis = Integer.parseInt(period);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Wrong value for parameter syncPeriodMillis");
            }
        }
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        try {
            for (HostMXBean host : this.hosts) {
                if (!host.getHostName().equals(hostName)) continue;
                return host;
            }
            ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
            RemoteExec.SshAuthInfo hostAuthInfo = props.get("sshRootPassword") != null ? new RemoteExec.SshAuthInfo(props.get("sshRootPassword"), null) : (props.get("sshPrivateKeyFile") != null ? new RemoteExec.SshAuthInfo(null, props.get("sshPrivateKeyFile")) : this.defaultAuthInfo);
            if (hostAuthInfo == null) {
                throw new IllegalArgumentException("Missing SSH authentification info");
            }
            String url = props.get("url");
            if (url == null) {
                throw new IllegalArgumentException("Missing parameter: url");
            }
            LibvirtHost host = LibvirtHost.newHost(this, mbeanObjectName, hostName, url, hostAuthInfo);
            if (host != null) {
                AgentCommon.getMBeanServer().registerMBean(host, mbeanObjectName);
                this.hosts.add(host);
                logger.info((Object)("In server pool " + this.name + ": added Host MBean " + mbeanObjectName));
                if (this.imageStore == null) {
                    ObjectName defaultDataStoreName = MBeanObjectNamer.makeVMImageStoreName(hostName + ".default");
                    this.imageStore = new ImageCatalog(defaultDataStoreName, this.vmImageStoreDir, hostName, this.defaultAuthInfo);
                    AgentCommon.getMBeanServer().registerMBean(this.imageStore, defaultDataStoreName);
                }
            }
            return host;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to add LibvirtHost", (Throwable)ex);
            return null;
        }
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public String getSharedDiskStoreDir() {
        return this.diskStoreDir;
    }

    public String getVmImageStoreHostname() {
        return this.vmImageStoreHostname;
    }

    public synchronized long getSyncPeriodMillis() {
        return this.syncPeriodMillis;
    }
}

