/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.virtimage;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;

public class FileUtils {
    static Logger logger = Logger.getLogger(FileUtils.class);

    public static long getDiskCapacityMB(String hostName, RemoteExec.SshAuthInfo authInfo, String path) {
        long size = -1L;
        RemoteExec.Result result = null;
        String command = "df -hP " + path;
        try {
            result = RemoteExec.commandAsRoot(hostName, authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            logger.debug((Object)"SSH failure", (Throwable)ex);
            return -1L;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(result.output));
            reader.readLine();
            String s = reader.readLine();
            StringTokenizer st = new StringTokenizer(s);
            st.nextToken();
            size = FileUtils.parseSizeToMB(st.nextToken());
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + hostName), (Throwable)ex);
        }
        return size;
    }

    public static long getDiskFreeSpaceMB(String hostName, RemoteExec.SshAuthInfo authInfo, String path) {
        long size = -1L;
        RemoteExec.Result result = null;
        String command = "df -hP " + path;
        try {
            result = RemoteExec.commandAsRoot(hostName, authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            logger.debug((Object)"SSH failure", (Throwable)ex);
            return -1L;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(result.output));
            reader.readLine();
            String s = reader.readLine();
            StringTokenizer st = new StringTokenizer(s);
            st.nextToken();
            st.nextToken();
            st.nextToken();
            size = FileUtils.parseSizeToMB(st.nextToken());
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + hostName), (Throwable)ex);
        }
        return size;
    }

    static long parseSizeToMB(String s) {
        if (s.equals("0")) {
            return 0L;
        }
        char c = s.charAt(s.length() - 1);
        float mult = 1.0f;
        if (c == 'K') {
            mult /= 1024.0f;
        } else if (c == 'G') {
            mult = 1024.0f;
        } else if (c == 'T') {
            mult = 1048576.0f;
        }
        return (long)(Float.parseFloat(s.substring(0, s.length() - 1)) * mult);
    }
}

