/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import java.io.File;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.Driver;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;
import org.ow2.jasmine.vmm.api.VMMException;

public class VMwareDriver
implements Driver {
    protected static Logger logger = Logger.getLogger(VMwareDriver.class);
    static final String VMWARE_KEYSTORE_FILENAME = "vmware.keystore";

    @Override
    public ServerPool newServerPool(String name, ObjectName objectname, Map<String, String> attributes) throws IllegalArgumentException, VMMException {
        VMwareServerPool pool = new VMwareServerPool(name, objectname, attributes);
        return pool;
    }

    static {
        String keyStoreFileName = System.getProperty("vmm.home") + File.separator + "etc" + File.separator + VMWARE_KEYSTORE_FILENAME;
        logger.debug((Object)("Setting system prop javax.net.ssl.trustStore to " + keyStoreFileName));
        System.setProperty("javax.net.ssl.trustStore", keyStoreFileName);
    }
}

