/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.ArrayOfManagedObjectReference;
import com.vmware.vim.DynamicProperty;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareEventCollector;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

class VMwareServerPool
extends ServerPool {
    protected static Logger logger = Logger.getLogger(VMwareServerPool.class);
    private static int KEEP_ALIVE_PERIOD_MS = 120000;
    private static final int THREADPOOL_SIZE = 20;
    private static final int CONNECTION_DEFAULT_POOL_SIZE = 4;
    private static ExecutorService executorService = Executors.newFixedThreadPool(20);
    private ConnectionPool connectionPool;
    private HashMap<String, VMwareHost> hostRefs = new HashMap();
    private String datacenter;
    private String vmFolderName;
    private String datastoreName;
    private String networkName;
    private ManagedObjectReference datacenterRef;
    private ManagedObjectReference vmFolderRef;
    private ManagedObjectReference datastoreRef;
    private ManagedObjectReference vmTemplateFolderRef;
    private ManagedObjectReference hostFolderRef;
    private VMwareVMTemplateDataStore imageStore;
    private RemoteExec.SshAuthInfo defaultAuthInfo;

    public VMwareServerPool(String name, ObjectName objectName, Map<String, String> attributes) throws IllegalArgumentException, VMMException {
        super(name, objectName);
        String hostName = attributes.get("vCenterHostName");
        if (hostName == null) {
            throw new IllegalArgumentException("Missing parameter: vCenterHostName");
        }
        this.datacenter = attributes.get("datacenter");
        if (this.datacenter == null) {
            throw new IllegalArgumentException("Missing parameter: datacenter");
        }
        this.vmFolderName = attributes.get("vmFolderPath");
        if (this.vmFolderName == null) {
            throw new IllegalArgumentException("Missing parameter: vmFolderName");
        }
        String vmTemplateFolderName = attributes.get("vmTemplateFolderPath");
        if (vmTemplateFolderName == null) {
            throw new IllegalArgumentException("Missing parameter: vmTemplateFolderName");
        }
        String userName = attributes.get("user");
        if (userName == null) {
            throw new IllegalArgumentException("Missing parameter: userName");
        }
        String password = attributes.get("password");
        if (password == null) {
            throw new IllegalArgumentException("Missing parameter: password");
        }
        this.datastoreName = attributes.get("datastore");
        if (this.datastoreName == null) {
            throw new IllegalArgumentException("Missing parameter: datastoreName");
        }
        this.networkName = attributes.get("network");
        String sshPassword = attributes.get("sshDefaultRootPassword");
        String sshPrivateKeyFile = attributes.get("sshDefaultPrivateKeyFile");
        try {
            this.defaultAuthInfo = new RemoteExec.SshAuthInfo(sshPassword, sshPrivateKeyFile);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        VMwareServiceConnection connection = null;
        try {
            this.connectionPool = new ConnectionPool(4, hostName, userName, password);
            connection = this.connectionPool.getConnection();
            logger.debug((Object)("Finding datacenter " + this.datacenter));
            this.datacenterRef = connection.getService().findByInventoryPath(connection.getServiceContent().getSearchIndex(), this.datacenter);
            if (this.datacenterRef == null) {
                String msg = "VMware Driver initialization error: datacenter " + this.datacenter + " not found ";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            this.vmFolderRef = this.vmFolderName != null ? connection.getService().findByInventoryPath(connection.getServiceContent().getSearchIndex(), this.vmFolderName) : (ManagedObjectReference)this.getDynamicProarray(connection, this.datacenterRef, "vmFolder")[0].getVal();
            if (this.vmFolderRef == null) {
                String msg = "VMware Driver initialization error: virtual machine folder " + this.vmFolderName + " not found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            this.vmTemplateFolderRef = vmTemplateFolderName != null ? connection.getService().findByInventoryPath(connection.getServiceContent().getSearchIndex(), vmTemplateFolderName) : this.vmFolderRef;
            if (this.vmTemplateFolderRef == null) {
                String msg = "VMware Driver initialization error: virtual machine template folder " + vmTemplateFolderName + " not found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            this.hostFolderRef = (ManagedObjectReference)this.getDynamicProarray(connection, this.datacenterRef, "hostFolder")[0].getVal();
            if (this.hostFolderRef == null) {
                String msg = "VMware Driver initialization error: host folder not found for datacenter " + this.datacenter;
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            ArrayOfManagedObjectReference dataStoreRefs = (ArrayOfManagedObjectReference)this.getDynamicProarray(connection, this.datacenterRef, "datastore")[0].getVal();
            if (dataStoreRefs != null) {
                for (int i = 0; i < dataStoreRefs.getManagedObjectReference().length; ++i) {
                    String dsName = (String)this.getDynamicProarray(connection, dataStoreRefs.getManagedObjectReference(i), "info.name")[0].getVal();
                    if (!dsName.equals(this.datastoreName)) continue;
                    this.datastoreRef = dataStoreRefs.getManagedObjectReference(i);
                    break;
                }
            }
            if (this.datastoreRef == null) {
                String msg = "VMware Driver initialization error: Datastore " + this.datastoreName + " cannot be found";
                logger.error((Object)msg);
                throw new VMMException(msg);
            }
            String vmImageStoreName = this.datacenter + "-VMIStore";
            this.imageStore = new VMwareVMTemplateDataStore(MBeanObjectNamer.makeVMImageStoreName(vmImageStoreName), vmImageStoreName, this.datastoreRef, attributes);
            AgentCommon.getMBeanServer().registerMBean(this.imageStore, this.imageStore.getObjectName());
        }
        catch (Exception ex) {
            String msg = "VMware Driver initialization error: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            throw new VMMException(msg);
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        new VMwareEventCollector(this, new VMwareServiceConnection(hostName, userName, password), this.datacenter).start();
    }

    public ExecutorService getExecutorService() {
        return executorService;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    public String getMountPoint() {
        return this.datacenter;
    }

    VMwareHost getHostByName(String name) {
        return this.hostRefs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) {
        VMwareHost host = this.hostRefs.get(hostName);
        if (host != null) {
            return host;
        }
        ManagedObjectReference mor = null;
        VMwareServiceConnection connection = this.connectionPool.getConnection();
        try {
            mor = connection.getDecendentMoRef(this.getHostFolderRef(), "HostSystem", hostName);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to find HostSystem managed object " + hostName + " in VMware VC inventory"), (Throwable)ex);
            HostMXBean hostMXBean = null;
            return hostMXBean;
        }
        finally {
            connection.release();
        }
        if (mor == null) {
            logger.error((Object)("Host " + hostName + " not found"));
            return null;
        }
        RemoteExec.SshAuthInfo hostAuthInfo = props.get("sshRootPassword") != null ? new RemoteExec.SshAuthInfo(props.get("sshRootPassword"), null) : (props.get("sshPrivateKeyFile") != null ? new RemoteExec.SshAuthInfo(null, props.get("sshPrivateKeyFile")) : this.defaultAuthInfo);
        ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
        host = new VMwareHost(this, mor, mbeanObjectName, hostName, hostAuthInfo);
        host.getResidentVMs();
        try {
            AgentCommon.getMBeanServer().registerMBean(host, mbeanObjectName);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to register MBean " + mbeanObjectName), (Throwable)ex);
            return null;
        }
        this.hostRefs.put(hostName, host);
        this.addHost(host);
        try {
            this.connectionPool.ensureCapacity(2 + this.hostRefs.size() * 3);
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot increase connection pool", (Throwable)ex);
        }
        return host;
    }

    public ManagedObjectReference getDatacenterRef() {
        return this.datacenterRef;
    }

    public ManagedObjectReference getVmFolderRef() {
        return this.vmFolderRef;
    }

    public ManagedObjectReference getHostFolderRef() {
        return this.hostFolderRef;
    }

    public ManagedObjectReference getVmTemplateFolderRef() {
        return this.vmTemplateFolderRef;
    }

    public ManagedObjectReference getDatastoreRef() {
        return this.datastoreRef;
    }

    public String getDatastoreName() {
        return this.datastoreName;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    private DynamicProperty[] getDynamicProarray(VMwareServiceConnection connection, ManagedObjectReference MOR, String pName) throws Exception {
        ObjectContent[] objContent = connection.getObjectProperties(null, MOR, new String[]{pName});
        ObjectContent contentObj = objContent[0];
        DynamicProperty[] objArr = contentObj.getPropSet();
        return objArr;
    }

    static class VMwareVirtualMachineISOTemplate
    extends VMwareVirtualMachineTemplate
    implements VirtualMachineImageMXBean {
        private String isoFileName;
        private String makeFloppyShellScript;
        private String guestId;

        public VMwareVirtualMachineISOTemplate(ObjectName objectName, String name, String uuid) {
            super(objectName, name, uuid);
        }

        public String getIsoFileName() {
            return this.isoFileName;
        }

        public void setIsoFileName(String isoFileName) {
            this.isoFileName = isoFileName;
        }

        public String getMakeFloppyShellScript() {
            return this.makeFloppyShellScript;
        }

        public void setMakeFloppyShellScript(String makeFloppyShellScript) {
            this.makeFloppyShellScript = makeFloppyShellScript;
        }

        public String getGuestId() {
            return this.guestId;
        }

        public void setGuestId(String guestId) {
            this.guestId = guestId;
        }

        @Override
        public String toString() {
            return "VMwareISOTemplate(uuid=" + this.getUUID() + ",iso=" + this.getIsoFileName() + ")";
        }
    }

    static class VMwareVirtualMachineTemplate
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String name;
        private String uuid;

        public VMwareVirtualMachineTemplate(ObjectName objectName, String name, String uuid) {
            super(objectName);
            this.name = name;
            this.uuid = uuid;
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.name;
        }

        public Map<String, String> getMetaData() {
            return null;
        }

        public String getDescription() {
            return "";
        }

        public String toString() {
            return "VMwareTemplate(name=" + this.getName() + ",uuid=" + this.getUUID() + ")";
        }
    }

    class VMwareVMTemplateDataStore
    extends ManagedResource
    implements VirtualMachineImageStoreMXBean {
        private String name;
        private ArrayList<VirtualMachineImageMXBean> imageList;
        private ManagedObjectReference datastoreRef;
        private boolean needSync;

        public VMwareVMTemplateDataStore(ObjectName objectName, String name, ManagedObjectReference datastoreRef, Map<String, String> attributes) {
            super(objectName);
            this.imageList = new ArrayList();
            this.needSync = true;
            this.name = name;
            this.datastoreRef = datastoreRef;
            this.listVMImageTemplates();
            HashSet<String> templateNames = new HashSet<String>();
            for (String key : attributes.keySet()) {
                if (!key.startsWith("template")) continue;
                templateNames.add(key.substring(0, key.indexOf(46)));
            }
            for (String template : templateNames) {
                String isoFileName = attributes.get(template + ".isoFileName");
                String description = attributes.get(template + ".description");
                String uuid = attributes.get(template + ".uuid");
                String makeFloppyShellScript = attributes.get(template + ".makeFloppyShellScript");
                String guestId = attributes.get(template + ".guestId");
                ObjectName on = MBeanObjectNamer.makeVMImageName(uuid);
                VMwareVirtualMachineISOTemplate image = new VMwareVirtualMachineISOTemplate(on, uuid, uuid);
                image.setMakeFloppyShellScript(makeFloppyShellScript);
                image.setGuestId(guestId);
                image.setIsoFileName(isoFileName);
                logger.debug((Object)("New VMware template: " + image));
                try {
                    AgentCommon.getMBeanServer().registerMBean(image, on);
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to register image", (Throwable)ex);
                    continue;
                }
                this.imageList.add(image);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getCapacityMB() {
            VMwareServiceConnection connection = VMwareServerPool.this.connectionPool.getConnection();
            try {
                long capacityInBytes = (Long)VMwareServerPool.this.getDynamicProarray(connection, this.datastoreRef, "summary.capacity")[0].getVal();
                long l = capacityInBytes / 1024L;
                return l;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get datastore capacity", (Throwable)ex);
                long l = -1L;
                return l;
            }
            finally {
                connection.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getFreeSpaceMB() {
            VMwareServiceConnection connection = VMwareServerPool.this.connectionPool.getConnection();
            try {
                long freeSpaceInBytes = (Long)VMwareServerPool.this.getDynamicProarray(connection, this.datastoreRef, "summary.freeSpace")[0].getVal();
                long l = freeSpaceInBytes / 1024L;
                return l;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get datastore free space", (Throwable)ex);
                long l = -1L;
                return l;
            }
            finally {
                connection.release();
            }
        }

        public String getName() {
            return this.name;
        }

        public synchronized void sync() {
            this.needSync = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List<VirtualMachineImageMXBean> listVMImageTemplates() {
            logger.debug((Object)"listVMImages");
            if (this.needSync) {
                VMwareServiceConnection connection = VMwareServerPool.this.connectionPool.getConnection();
                try {
                    ArrayList vms = connection.getDecendentMoRefs(VMwareServerPool.this.getVmTemplateFolderRef(), "VirtualMachine");
                    for (ManagedObjectReference vmMor : vms) {
                        VirtualMachineImageMXBean image2;
                        DynamicProperty[] properties;
                        boolean isTemplate = (Boolean)VMwareServerPool.this.getDynamicProarray(connection, vmMor, "summary.config.template")[0].getVal();
                        if (!isTemplate || (properties = VMwareServerPool.this.getDynamicProarray(connection, vmMor, "config.name")) == null || properties.length < 1) continue;
                        String vmName = (String)properties[0].getVal();
                        String uuid = (String)VMwareServerPool.this.getDynamicProarray(connection, vmMor, "config.uuid")[0].getVal();
                        boolean found = false;
                        for (VirtualMachineImageMXBean image2 : this.imageList) {
                            if (!image2.getUUID().equals(vmName)) continue;
                            found = true;
                        }
                        if (found) continue;
                        ObjectName on = MBeanObjectNamer.makeVMImageName(uuid);
                        image2 = new VMwareVirtualMachineTemplate(on, vmName, uuid);
                        logger.debug((Object)("New VMware template: " + image2));
                        AgentCommon.getMBeanServer().registerMBean(image2, on);
                        this.imageList.add(image2);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to list VM templates", (Throwable)ex);
                }
                finally {
                    connection.release();
                }
                this.needSync = false;
            }
            return this.imageList;
        }

        public synchronized VirtualMachineImageMXBean lookUpByUUID(String uuid) {
            logger.debug((Object)("lookUpByUUID " + uuid));
            for (VirtualMachineImageMXBean image : this.listVMImageTemplates()) {
                if (!image.getUUID().equals(uuid)) continue;
                return image;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void removeVMImageTemplate(VirtualMachineImageMXBean vmImage) throws VMMException {
            String vmImageID = vmImage.getUUID();
            VMwareServiceConnection connection = VMwareServerPool.this.connectionPool.getConnection();
            try {
                ManagedObjectReference vmMOR = connection.getDecendentMoRef(null, "VirtualMachine", vmImageID);
                connection.getService().destroy_Task(vmMOR);
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to retrieve VM reference " + vmImageID), (Throwable)ex);
            }
            finally {
                connection.release();
            }
        }
    }

    class ConnectionPool {
        private List<VMwareServiceConnection> connections = new ArrayList<VMwareServiceConnection>();
        private String hostName;
        private String userName;
        private String password;

        ConnectionPool(int initialCapacity, String hostName, String userName, String password) throws Exception {
            this.userName = userName;
            this.hostName = hostName;
            this.password = password;
            this.ensureCapacity(initialCapacity);
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(KEEP_ALIVE_PERIOD_MS);
                                ConnectionPool connectionPool = ConnectionPool.this;
                                synchronized (connectionPool) {
                                    for (VMwareServiceConnection connection : ConnectionPool.this.connections) {
                                        if (!connection.lease()) continue;
                                        try {
                                            Calendar time = connection.getService().currentTime(connection.getServiceInstanceRef());
                                        }
                                        finally {
                                            connection.release();
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)"error", (Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
            });
        }

        synchronized void ensureCapacity(int minCapacity) throws Exception {
            if (this.connections.size() < minCapacity) {
                for (int i = minCapacity - this.connections.size(); i > 0; --i) {
                    VMwareServiceConnection connection = new VMwareServiceConnection(this.hostName, this.userName, this.password);
                    logger.debug((Object)("Connecting to VMware VirtualCenter " + this.hostName + " ..."));
                    connection.connect();
                    logger.debug((Object)"Done");
                    this.connections.add(connection);
                }
            }
        }

        private synchronized VMwareServiceConnection getFirstFreeConnection() {
            for (VMwareServiceConnection connection : this.connections) {
                if (!connection.lease()) continue;
                return connection;
            }
            return null;
        }

        synchronized VMwareServiceConnection getConnection() {
            VMwareServiceConnection connection = this.getFirstFreeConnection();
            if (connection == null) {
                try {
                    this.ensureCapacity(this.connections.size() + 5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connection = this.getFirstFreeConnection();
            }
            return connection;
        }
    }
}

