/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.DynamicProperty;
import com.vmware.vim.LocalizedMethodFault;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import com.vmware.vim.ObjectSpec;
import com.vmware.vim.ObjectUpdate;
import com.vmware.vim.ObjectUpdateKind;
import com.vmware.vim.PropertyChange;
import com.vmware.vim.PropertyChangeOp;
import com.vmware.vim.PropertyFilterSpec;
import com.vmware.vim.PropertyFilterUpdate;
import com.vmware.vim.PropertySpec;
import com.vmware.vim.RuntimeFault;
import com.vmware.vim.SelectionSpec;
import com.vmware.vim.ServiceContent;
import com.vmware.vim.TaskInfo;
import com.vmware.vim.TaskInfoState;
import com.vmware.vim.TraversalSpec;
import com.vmware.vim.UpdateSet;
import com.vmware.vim.VimPortType;
import com.vmware.vim.VimServiceLocator;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

class VMwareServiceConnection {
    static Logger logger = Logger.getLogger(VMwareServiceConnection.class);
    private VimServiceLocator locator;
    private String hostName;
    private String username;
    private String password;
    private VimPortType service;
    private ServiceContent sic;
    private ManagedObjectReference serviceInstanceRef;
    private AtomicBoolean isLeased = new AtomicBoolean();
    static String[] meTree = new String[]{"ManagedEntity", "ComputeResource", "ClusterComputeResource", "Datacenter", "Folder", "HostSystem", "ResourcePool", "VirtualMachine"};
    static String[] crTree = new String[]{"ComputeResource", "ClusterComputeResource"};
    static String[] hcTree = new String[]{"HistoryCollector", "EventHistoryCollector", "TaskHistoryCollector"};

    public VMwareServiceConnection(String hostName, String username, String password) {
        this.username = username;
        this.password = password;
        this.hostName = hostName;
    }

    public synchronized void connect() throws Exception {
        this.locator = new VimServiceLocator();
        this.locator.setMaintainSession(true);
        this.service = this.locator.getVimPort(new URL("https://" + this.hostName + "/sdk"));
        this.serviceInstanceRef = new ManagedObjectReference();
        this.serviceInstanceRef.setType("ServiceInstance");
        this.serviceInstanceRef.set_value("ServiceInstance");
        this.sic = this.service.retrieveServiceContent(this.serviceInstanceRef);
        this.service.login(this.sic.getSessionManager(), this.username, this.password, null);
    }

    public boolean lease() {
        return this.isLeased.compareAndSet(false, true);
    }

    public void release() {
        boolean old = this.isLeased.getAndSet(false);
        if (!old) {
            logger.error((Object)"releasing an unleased connection !");
        }
    }

    public boolean isAlive() {
        try {
            Calendar time = this.service.currentTime(this.serviceInstanceRef);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public synchronized void close() throws Exception {
        if (this.service != null) {
            this.service.logout(this.sic.getSessionManager());
            this.service = null;
            this.sic = null;
        }
    }

    public VimPortType getService() {
        return this.service;
    }

    public ServiceContent getServiceContent() {
        return this.sic;
    }

    public ManagedObjectReference getServiceInstanceRef() {
        return this.serviceInstanceRef;
    }

    public synchronized ObjectContent[] getObjectProperties(ManagedObjectReference collector, ManagedObjectReference mobj, String[] properties) throws Exception {
        if (mobj == null) {
            return null;
        }
        ManagedObjectReference usecoll = collector;
        if (usecoll == null) {
            usecoll = this.sic.getPropertyCollector();
        }
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setPropSet(new PropertySpec[]{new PropertySpec()});
        spec.getPropSet(0).setAll(new Boolean(properties == null || properties.length == 0));
        spec.getPropSet(0).setType(mobj.getType());
        spec.getPropSet(0).setPathSet(properties);
        spec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        spec.getObjectSet(0).setObj(mobj);
        spec.getObjectSet(0).setSkip(Boolean.FALSE);
        return this.service.retrieveProperties(usecoll, new PropertyFilterSpec[]{spec});
    }

    public synchronized ArrayList getDecendentMoRefs(ManagedObjectReference root, String type) throws Exception {
        ArrayList mors = this.getDecendentMoRefs(root, type, null);
        return mors;
    }

    public synchronized ArrayList getDecendentMoRefs(ManagedObjectReference root, String type, String[][] filter) throws Exception {
        String[][] typeinfo = new String[][]{{type, "name"}};
        ObjectContent[] ocary = this.getContentsRecursively(null, root, typeinfo, true);
        ArrayList<ManagedObjectReference> refs = new ArrayList<ManagedObjectReference>();
        if (ocary == null || ocary.length == 0) {
            return refs;
        }
        for (ObjectContent element : ocary) {
            refs.add(element.getObj());
        }
        if (filter != null) {
            ArrayList filtermors = this.filterMOR(refs, filter);
            return filtermors;
        }
        return refs;
    }

    private ArrayList filterMOR(ArrayList mors, String[][] filter) throws Exception {
        ArrayList filteredmors = new ArrayList();
        for (int i = 0; i < mors.size(); ++i) {
            boolean flag = true;
            Object guest = null;
            for (int k = 0; k < filter.length; ++k) {
                String prop = filter[k][0];
                String reqVal = filter[k][1];
                String value = this.getProp((ManagedObjectReference)mors.get(i), prop);
                if (reqVal == null || value == null && reqVal == null) continue;
                if (value == null && reqVal != null) {
                    flag = false;
                    k = filter.length + 1;
                    continue;
                }
                if (value.equalsIgnoreCase(reqVal)) continue;
                flag = false;
                k = filter.length + 1;
            }
            if (!flag) continue;
            filteredmors.add(mors.get(i));
        }
        return filteredmors;
    }

    private String getProp(ManagedObjectReference obj, String prop) {
        String propVal = null;
        try {
            propVal = (String)this.getDynamicProperty(obj, prop);
        }
        catch (Exception e) {
            // empty catch block
        }
        return propVal;
    }

    public Object getDynamicProperty(ManagedObjectReference mor, String propertyName) throws Exception {
        DynamicProperty[] dynamicProperty;
        ObjectContent[] objContent = this.getObjectProperties(null, mor, new String[]{propertyName});
        Object propertyValue = null;
        if (objContent != null && (dynamicProperty = objContent[0].getPropSet()) != null) {
            Object dynamicPropertyVal = dynamicProperty[0].getVal();
            String dynamicPropertyName = dynamicPropertyVal.getClass().getName();
            if (dynamicPropertyName.indexOf("ArrayOf") != -1) {
                String methodName = dynamicPropertyName.substring(dynamicPropertyName.indexOf("ArrayOf") + "ArrayOf".length(), dynamicPropertyName.length());
                methodName = this.methodExists(dynamicPropertyVal, "get" + methodName, null) ? "get" + methodName : "get_" + methodName.toLowerCase();
                Method getMorMethod = dynamicPropertyVal.getClass().getDeclaredMethod(methodName, null);
                propertyValue = getMorMethod.invoke(dynamicPropertyVal, (Object[])null);
            } else {
                propertyValue = dynamicPropertyVal.getClass().isArray() ? dynamicPropertyVal : dynamicPropertyVal;
            }
        }
        return propertyValue;
    }

    boolean methodExists(Object obj, String methodName, Class[] parameterTypes) {
        boolean exists = false;
        try {
            Method method = obj.getClass().getMethod(methodName, parameterTypes);
            if (method != null) {
                exists = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return exists;
    }

    public synchronized ManagedObjectReference getDecendentMoRef(ManagedObjectReference root, String type, String name) throws Exception {
        if (name == null || name.length() == 0) {
            return null;
        }
        String[][] typeinfo = new String[][]{{type, "name"}};
        ObjectContent[] ocary = this.getContentsRecursively(null, root, typeinfo, true);
        if (ocary == null || ocary.length == 0) {
            return null;
        }
        ObjectContent oc = null;
        ManagedObjectReference mor = null;
        DynamicProperty[] propary = null;
        String propval = null;
        boolean found = false;
        for (int oci = 0; oci < ocary.length && !found; ++oci) {
            oc = ocary[oci];
            mor = oc.getObj();
            propary = oc.getPropSet();
            propval = null;
            if (type != null && !this.typeIsA(type, mor.getType())) continue;
            if (propary.length > 0) {
                propval = (String)propary[0].getVal();
            }
            found = propval != null && name.equals(propval);
        }
        if (!found) {
            mor = null;
        }
        return mor;
    }

    public synchronized ObjectContent[] getContentsRecursively(ManagedObjectReference collector, ManagedObjectReference root, String[][] typeinfo, boolean recurse) throws Exception {
        ManagedObjectReference useroot;
        if (typeinfo == null || typeinfo.length == 0) {
            return null;
        }
        ManagedObjectReference usecoll = collector;
        if (usecoll == null) {
            usecoll = this.sic.getPropertyCollector();
        }
        if ((useroot = root) == null) {
            useroot = this.sic.getRootFolder();
        }
        SelectionSpec[] selectionSpecs = null;
        if (recurse) {
            selectionSpecs = this.buildFullTraversal();
        }
        PropertySpec[] propspecary = this.buildPropertySpecArray(typeinfo);
        PropertyFilterSpec spec = new PropertyFilterSpec(null, null, propspecary, new ObjectSpec[]{new ObjectSpec(null, null, useroot, Boolean.FALSE, selectionSpecs)});
        ObjectContent[] retoc = this.service.retrieveProperties(usecoll, new PropertyFilterSpec[]{spec});
        return retoc;
    }

    public synchronized SelectionSpec[] buildFullTraversal() {
        TraversalSpec rpToRp = new TraversalSpec(null, null, null, "ResourcePool", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        rpToRp.setName("rpToRp");
        TraversalSpec rpToVm = new TraversalSpec(null, null, null, "ResourcePool", "vm", Boolean.FALSE, new SelectionSpec[0]);
        rpToVm.setName("rpToVm");
        TraversalSpec crToRp = new TraversalSpec(null, null, null, "ComputeResource", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        crToRp.setName("crToRp");
        TraversalSpec crToH = new TraversalSpec(null, null, null, "ComputeResource", "host", Boolean.FALSE, new SelectionSpec[0]);
        crToH.setName("crToH");
        TraversalSpec dcToHf = new TraversalSpec(null, null, null, "Datacenter", "hostFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        dcToHf.setName("dcToHf");
        TraversalSpec dcToVmf = new TraversalSpec(null, null, null, "Datacenter", "vmFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        dcToVmf.setName("dcToVmf");
        TraversalSpec HToVm = new TraversalSpec(null, null, null, "HostSystem", "vm", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        HToVm.setName("HToVm");
        TraversalSpec visitFolders = new TraversalSpec(null, null, null, "Folder", "childEntity", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders"), new SelectionSpec(null, null, "dcToHf"), new SelectionSpec(null, null, "dcToVmf"), new SelectionSpec(null, null, "crToH"), new SelectionSpec(null, null, "crToRp"), new SelectionSpec(null, null, "HToVm"), new SelectionSpec(null, null, "rpToVm")});
        visitFolders.setName("visitFolders");
        return new SelectionSpec[]{visitFolders, dcToVmf, dcToHf, crToH, crToRp, rpToRp, HToVm, rpToVm};
    }

    public synchronized PropertySpec[] buildPropertySpecArray(String[][] typeinfo) {
        HashMap tInfo = new HashMap();
        for (int ti = 0; ti < typeinfo.length; ++ti) {
            HashSet<String> props = (HashSet<String>)tInfo.get(typeinfo[ti][0]);
            if (props == null) {
                props = new HashSet<String>();
                tInfo.put(typeinfo[ti][0], props);
            }
            boolean typeSkipped = false;
            for (int pi = 0; pi < typeinfo[ti].length; ++pi) {
                String prop = typeinfo[ti][pi];
                if (typeSkipped) {
                    props.add(prop);
                    continue;
                }
                typeSkipped = true;
            }
        }
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        for (String type : tInfo.keySet()) {
            PropertySpec pSpec = new PropertySpec();
            Set props = (Set)tInfo.get(type);
            pSpec.setType(type);
            pSpec.setAll(props.isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            pSpec.setPathSet(new String[props.size()]);
            int index = 0;
            for (String prop : props) {
                pSpec.setPathSet(index++, prop);
            }
            pSpecs.add(pSpec);
        }
        return pSpecs.toArray(new PropertySpec[0]);
    }

    boolean typeIsA(String searchType, String foundType) {
        block5: {
            block6: {
                block4: {
                    if (searchType.equals(foundType)) {
                        return true;
                    }
                    if (!searchType.equals("ManagedEntity")) break block4;
                    for (int i = 0; i < meTree.length; ++i) {
                        if (!meTree[i].equals(foundType)) continue;
                        return true;
                    }
                    break block5;
                }
                if (!searchType.equals("ComputeResource")) break block6;
                for (int i = 0; i < crTree.length; ++i) {
                    if (!crTree[i].equals(foundType)) continue;
                    return true;
                }
                break block5;
            }
            if (!searchType.equals("HistoryCollector")) break block5;
            for (int i = 0; i < hcTree.length; ++i) {
                if (!hcTree[i].equals(foundType)) continue;
                return true;
            }
        }
        return false;
    }

    public String waitForTask(ManagedObjectReference taskmor) throws Exception {
        Object[] result = this.waitForValues(taskmor, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.success, TaskInfoState.error}});
        if (result[0].equals(TaskInfoState.success)) {
            return "success";
        }
        TaskInfo tinfo = (TaskInfo)this.getDynamicProperty(taskmor, "info");
        LocalizedMethodFault fault = tinfo.getError();
        String error = "Error Occured";
        if (fault != null) {
            error = fault.getFault().getFaultReason();
            System.out.println("Fault " + fault.getFault().getFaultCode());
            System.out.println("Message " + fault.getLocalizedMessage());
        }
        return error;
    }

    public Object[] waitForValues(ManagedObjectReference objmor, String[] filterProps, String[] endWaitProps, Object[][] expectedVals) throws Exception {
        String version = "";
        Object[] endVals = new Object[endWaitProps.length];
        Object[] filterVals = new Object[filterProps.length];
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        spec.getObjectSet(0).setObj(objmor);
        spec.setPropSet(new PropertySpec[]{new PropertySpec()});
        spec.getPropSet(0).setPathSet(filterProps);
        spec.getPropSet(0).setType(objmor.getType());
        spec.getObjectSet(0).setSelectSet(null);
        spec.getObjectSet(0).setSkip(Boolean.FALSE);
        ManagedObjectReference filterSpecRef = this.service.createFilter(this.sic.getPropertyCollector(), spec, true);
        boolean reached = false;
        UpdateSet updateset = null;
        PropertyFilterUpdate[] filtupary = null;
        PropertyFilterUpdate filtup = null;
        ObjectUpdate[] objupary = null;
        ObjectUpdate objup = null;
        PropertyChange[] propchgary = null;
        PropertyChange propchg = null;
        while (!reached) {
            boolean retry = true;
            while (retry) {
                try {
                    updateset = this.service.waitForUpdates(this.sic.getPropertyCollector(), version);
                    retry = false;
                }
                catch (Exception e) {
                    if (!(e instanceof AxisFault)) continue;
                    AxisFault fault = (AxisFault)e;
                    Element[] errors = fault.getFaultDetails();
                    String faultString = fault.getFaultString();
                    if (faultString.indexOf("java.net.SocketTimeoutException") != -1) {
                        System.out.println("Retrying2........");
                        retry = true;
                        continue;
                    }
                    throw e;
                }
            }
            version = updateset.getVersion();
            if (updateset == null || updateset.getFilterSet() == null) continue;
            filtupary = updateset.getFilterSet();
            filtup = null;
            PropertyFilterUpdate[] arr$ = filtupary;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PropertyFilterUpdate element;
                filtup = element = arr$[i$];
                objupary = filtup.getObjectSet();
                objup = null;
                propchgary = null;
                for (ObjectUpdate element2 : objupary) {
                    objup = element2;
                    if (objup.getKind() != ObjectUpdateKind.modify && objup.getKind() != ObjectUpdateKind.enter && objup.getKind() != ObjectUpdateKind.leave) continue;
                    PropertyChange[] arr$2 = propchgary = objup.getChangeSet();
                    int len$2 = arr$2.length;
                    for (int i$2 = 0; i$2 < len$2; ++i$2) {
                        PropertyChange element3;
                        propchg = element3 = arr$2[i$2];
                        this.updateValues(endWaitProps, endVals, propchg);
                        this.updateValues(filterProps, filterVals, propchg);
                    }
                }
            }
            Object expctdval = null;
            for (int chgi = 0; chgi < endVals.length && !reached; ++chgi) {
                for (int vali = 0; vali < expectedVals[chgi].length && !reached; ++vali) {
                    expctdval = expectedVals[chgi][vali];
                    reached = expctdval.equals(endVals[chgi]) || reached;
                }
            }
        }
        this.service.destroyPropertyFilter(filterSpecRef);
        return filterVals;
    }

    protected void updateValues(String[] props, Object[] vals, PropertyChange propchg) {
        for (int findi = 0; findi < props.length; ++findi) {
            if (propchg.getName().lastIndexOf(props[findi]) < 0) continue;
            vals[findi] = propchg.getOp() == PropertyChangeOp.remove ? "" : propchg.getVal();
        }
    }

    Object getObjectProperty(ManagedObjectReference moRef, String propertyName) throws RuntimeFault, RemoteException {
        return this.getProperties(moRef, new String[]{propertyName})[0];
    }

    Object[] getProperties(ManagedObjectReference moRef, String[] properties) throws RuntimeFault, RemoteException {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(moRef.getType());
        pSpec.setPathSet(properties);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(moRef);
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.setPropSet(new PropertySpec[]{pSpec});
        pfSpec.setObjectSet(new ObjectSpec[]{oSpec});
        ObjectContent[] ocs = this.service.retrieveProperties(this.sic.getPropertyCollector(), new PropertyFilterSpec[]{pfSpec});
        Object[] ret = new Object[properties.length];
        if (ocs != null) {
            for (int i = 0; i < ocs.length; ++i) {
                ObjectContent oc = ocs[i];
                DynamicProperty[] dps = oc.getPropSet();
                if (dps == null) continue;
                for (int j = 0; j < dps.length; ++j) {
                    DynamicProperty dp = dps[j];
                    for (int p = 0; p < ret.length; ++p) {
                        if (!properties[p].equals(dp.getName())) continue;
                        ret[p] = dp.getVal();
                    }
                }
            }
        }
        return ret;
    }
}

