/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xenapi;

import com.xensource.xenapi.APIVersion;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Event;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.HostCpu;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Session;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.VM;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenServerPool;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenVMImageStore;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenVirtualMachine;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class XenHost
extends ManagedResource
implements HostMXBean,
NotificationEmitter {
    static Logger logger = Logger.getLogger(XenHost.class);
    private static final int MAX_PARALELL_VM_CREATION_PER_HOST = 3;
    private static final int THREADPOOL_SIZE = 4;
    private static ExecutorService executorService = Executors.newFixedThreadPool(4);
    private List<XenVirtualMachine> vmList = new CopyOnWriteArrayList<XenVirtualMachine>();
    private XenServerPool serverPool;
    private Connection connection;
    Host host;
    private SR storageRepository;
    private String hostName;
    private int numCPU = -1;
    private long cpuFrequencyMhz = -1L;
    private EventCollector eventCollector;
    HashMap<String, String> hypervisorInfo;
    HashMap<String, String> cpuInfo;

    public static XenHost newHost(XenServerPool resourcePool, ObjectName objectName, String hostName, String poolUser, String poolPassword, int port, Map<String, String> attributes) {
        String user = attributes.get("user");
        if (user == null) {
            user = poolUser;
        }
        if (user == null) {
            throw new IllegalArgumentException("Host: " + hostName + " Missing parameter: user");
        }
        String password = attributes.get("password");
        if (password == null) {
            password = poolPassword;
        }
        if (password == null) {
            throw new IllegalArgumentException("Host: " + hostName + " Missing parameter: password");
        }
        Connection[] connection = new Connection[2];
        try {
            for (int i = 0; i < connection.length; ++i) {
                connection[i] = new Connection(new URL("http://" + hostName));
                Session.loginWithPassword((Connection)connection[i], (String)user, (String)password, (String)APIVersion.latest().toString());
            }
            XenHost xenHost = new XenHost(resourcePool, connection, objectName, hostName);
            return xenHost;
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to establish Xen-API connection with host " + hostName + " with login " + user), (Throwable)ex);
            return null;
        }
    }

    private XenHost(XenServerPool serverPool, Connection[] connection, ObjectName objectName, String hostName) {
        super(objectName);
        this.serverPool = serverPool;
        this.connection = connection[0];
        this.hostName = hostName;
        try {
            Set hosts = Host.getAll((Connection)connection[0]);
            this.host = (Host)hosts.iterator().next();
            this.populate();
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + hostName), (Throwable)ex);
        }
        this.eventCollector = new EventCollector(connection[1]);
        this.storageRepository = this.getStorageRepository();
        new Thread(this.eventCollector).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionLost() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.host.getAPIVersionMajor(this.connection);
            }
            catch (Exception ex) {
                return true;
            }
            return false;
        }
    }

    Connection getXenAPIConnection() {
        return this.connection;
    }

    private SR getStorageRepository() {
        if (this.storageRepository == null) {
            String sharedStorageRepository = this.serverPool.getSharedStorageRepository();
            try {
                Set srSet = SR.getByNameLabel((Connection)this.connection, (String)sharedStorageRepository);
                if (srSet.isEmpty()) {
                    return null;
                }
                this.storageRepository = (SR)srSet.iterator().next();
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to get SR " + sharedStorageRepository), (Throwable)ex);
            }
        }
        return this.storageRepository;
    }

    List<XenVirtualMachine> getVMs() {
        return this.vmList;
    }

    XenVirtualMachine lookUpByUuid(String uuid) {
        for (XenVirtualMachine vm : this.vmList) {
            if (!vm.getUuid().equals(uuid)) continue;
            return vm;
        }
        return null;
    }

    private void addVM(XenVirtualMachine vm) {
        this.vmList.add(vm);
    }

    private void removeVM(XenVirtualMachine vm) {
        this.vmList.remove(vm);
    }

    public ServerPoolMXBean getServerPool() {
        return this.serverPool;
    }

    public void postMigrateVM(XenVirtualMachine vm, XenHost newHost) {
        this.removeVM(vm);
        newHost.addVM(vm);
    }

    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getHypervisorInfo() throws VMMException {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            this.hypervisorInfo.put("vendor", "");
            this.hypervisorInfo.put("name", "Xen");
        }
        return this.hypervisorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getCPUInfo() throws VMMException {
        if (this.cpuInfo == null) {
            this.cpuInfo = new HashMap();
            Connection connection = this.connection;
            synchronized (connection) {
                try {
                    HostCpu[] cpus = this.host.getHostCPUs(this.connection).toArray(new HostCpu[0]);
                    this.numCPU = cpus.length;
                    HostCpu.Record rec = cpus[0].getRecord(this.connection);
                    this.cpuInfo.put("model", rec.modelname);
                    this.cpuFrequencyMhz = rec.speed;
                    this.cpuInfo.put("speedMHz", Long.toString(rec.speed));
                    this.cpuInfo.put("vendor", rec.vendor);
                    this.cpuInfo.put("features", rec.features);
                    this.cpuInfo.put("flags", rec.flags);
                }
                catch (Exception ex) {
                    throw XenVirtualMachine.translateXenAPIException(ex);
                }
            }
        }
        return this.cpuInfo;
    }

    public long getCPUFrequencyMhz() throws VMMException {
        if (this.cpuFrequencyMhz == -1L) {
            this.getCPUInfo();
        }
        return this.cpuFrequencyMhz;
    }

    public int getNumCPU() throws VMMException {
        if (this.numCPU == -1) {
            this.getCPUInfo();
        }
        return this.numCPU;
    }

    public String getHostName() {
        return this.hostName;
    }

    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.serverPool.getVMImageStore();
    }

    public long getFreeMemoryMB() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.host.getMetrics(this.connection).getMemoryFree(this.connection) / 0x100000L;
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() {
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                Set vms = VM.getAll((Connection)this.connection);
                for (VM vm : vms) {
                    if (vm.getRecord((Connection)this.connection).isATemplate.booleanValue()) continue;
                    ObjectName name = vm.getDomid(this.connection) == 0L ? MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + "Domain-0", this.host.getUuid(this.connection)) : MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vm.getNameLabel(this.connection), vm.getUuid(this.connection));
                    XenVirtualMachine xenVM = new XenVirtualMachine(name, this, this.connection, vm, null);
                    this.addVM(xenVM);
                    AgentCommon.getMBeanServer().registerMBean(xenVM, name);
                    logger.info((Object)("Added XenVirtualMachineMBean " + name));
                }
            }
        }
        catch (Exception ex) {
            logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
        }
    }

    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> result = new ArrayList<VirtualMachineMXBean>(this.vmList);
        return result;
    }

    public VirtualMachineMXBean createVM(VMConfigSpec vmSpecIn, boolean sync) throws InvalidVMConfigException, VMMException {
        VM templateVM;
        final VMConfigSpec vmSpec = new VMConfigSpec(vmSpecIn);
        logger.info((Object)("Creating new VM [name=" + vmSpec.getName() + ",memorySizeMB=" + vmSpec.getMemorySizeMB() + ",diskSize=" + vmSpec.getDiskSizeMB() + ",numVCPU=" + vmSpec.getNumVCPU() + "]"));
        XenVMImageStore.XenVirtualMachineImage template = (XenVMImageStore.XenVirtualMachineImage)this.serverPool.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID());
        if (template == null) {
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        try {
            templateVM = VM.getByUuid((Connection)this.connection, (String)template.getUUID());
        }
        catch (Exception ex) {
            throw XenVirtualMachine.translateXenAPIException(ex);
        }
        if (templateVM == null) {
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        final String vmName = vmSpec.getName();
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        XenHost.this.cloneVM(vmSpec, vmName, templateVM);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.cloneVM(vmSpec, vmName, templateVM);
    }

    public VirtualMachineMXBean cloneVM(final VM vm, final String clonedVmName, VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, VMMException {
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        XenHost.this.cloneVM(null, clonedVmName, vm);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.cloneVM(null, clonedVmName, vm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean cloneVM(VMConfigSpec vmSpec, String vmName, VM templateVM) throws InvalidVMConfigException, VMMException {
        try {
            String uuid;
            VM newVM;
            Object object = this.connection;
            synchronized (object) {
                newVM = templateVM.createClone(this.connection, vmName);
                if (vmSpec != null) {
                    Set networks = Network.getAll((Connection)this.connection);
                    Network network = null;
                    for (Network net : networks) {
                        String bridge = net.getBridge(this.connection);
                        logger.debug((Object)("Network bridge=" + bridge));
                        if (!bridge.equals("xenbr0")) continue;
                        network = net;
                        break;
                    }
                    if (network == null) {
                        throw new VMMException("Failed to find bridge xenbr0");
                    }
                    VIF.Record newvifrecord = new VIF.Record();
                    newvifrecord.VM = newVM;
                    newvifrecord.network = network;
                    newvifrecord.device = "0";
                    newvifrecord.MTU = 1500L;
                    VIF.create((Connection)this.connection, (VIF.Record)newvifrecord);
                    Map otherConfig = newVM.getOtherConfig(this.connection);
                    String disks = (String)otherConfig.get("disks");
                    disks = disks.replace("sr=\"\"", "sr=\"" + this.storageRepository.getUuid(this.connection) + "\"");
                    otherConfig.put("disks", disks);
                    newVM.setOtherConfig(this.connection, otherConfig);
                    newVM.setPVArgs(this.connection, "noninteractive");
                    newVM.provision(this.connection);
                }
                uuid = newVM.getUuid(this.connection);
            }
            object = this.eventCollector;
            synchronized (object) {
                ObjectName name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, uuid);
                if (!AgentCommon.getMBeanServer().isRegistered(name)) {
                    XenVirtualMachine xenVM = new XenVirtualMachine(name, this, this.connection, newVM, null);
                    this.addVM(xenVM);
                    AgentCommon.getMBeanServer().registerMBean(xenVM, name);
                    this.emitNotification("vm.add", "Created", name);
                }
                return this.lookUpByUuid(uuid);
            }
        }
        catch (Exception ex) {
            throw XenVirtualMachine.translateXenAPIException(ex);
        }
    }

    public long getTotalMemoryMB() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.host.getMetrics(this.connection).getMemoryTotal(this.connection) / 0x100000L;
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getLoadPerCPU() throws VMMException {
        float[] result = new float[]{};
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Set cpus = this.host.getHostCPUs(this.connection);
                result = new float[cpus.size()];
                int i = 0;
                for (HostCpu cpu : cpus) {
                    result[i++] = (float)(cpu.getUtilisation(this.connection) * 100.0);
                }
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
        return result;
    }

    public float getCPULoad() throws VMMException {
        float aggregatedCPULoad = 0.0f;
        for (XenVirtualMachine vm : this.vmList) {
            aggregatedCPULoad += vm.getCPULoad();
        }
        return aggregatedCPULoad;
    }

    public Map<String, Float> getVMCPULoads() throws VMMException {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        for (XenVirtualMachine vm : this.vmList) {
            cpuLoads.put(vm.getNameLabel(), Float.valueOf(vm.getCPULoad()));
        }
        return cpuLoads;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.del", "vm.error", "log"}, Notification.class.getName(), "Host event")};
    }

    public Map<String, ResourceUsage> getVMResourceUsage() throws VMMException {
        HashMap<String, ResourceUsage> result = new HashMap<String, ResourceUsage>();
        for (XenVirtualMachine vm : this.vmList) {
            result.put(vm.getNameLabel(), vm.getResourceUsage());
        }
        return result;
    }

    private class EventCollector
    implements Runnable {
        volatile boolean stop = false;
        Connection connection;

        EventCollector(Connection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<String> eventClasses = new HashSet<String>();
            eventClasses.add("vm");
            try {
                Event.register((Connection)this.connection, eventClasses);
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot register XenAPI session with event system", (Throwable)ex);
                return;
            }
            while (!this.stop) {
                Set eventSet;
                try {
                    eventSet = Event.next((Connection)this.connection);
                }
                catch (Exception ex) {
                    logger.error((Object)"Cannot retrieve next event", (Throwable)ex);
                    continue;
                }
                EventCollector eventCollector = this;
                synchronized (eventCollector) {
                    block17: for (Event.Record event : eventSet) {
                        VM.Record vmRecord = (VM.Record)event.snapshot;
                        String vmName = vmRecord.isControlDomain != false ? "Domain-0" : vmRecord.nameLabel;
                        switch (event.operation) {
                            case ADD: {
                                XenVirtualMachine vm;
                                try {
                                    vm = VM.getByUuid((Connection)this.connection, (String)vmRecord.uuid);
                                    ObjectName name = MBeanObjectNamer.makeVirtualMachineName(XenHost.this.serverPool.getPath() + "/" + vmName, vmRecord.uuid);
                                    if (AgentCommon.getMBeanServer().isRegistered(name)) continue block17;
                                    XenVirtualMachine xenVM = new XenVirtualMachine(name, XenHost.this, XenHost.this.connection, (VM)vm, null);
                                    XenHost.this.addVM(xenVM);
                                    AgentCommon.getMBeanServer().registerMBean(xenVM, name);
                                    XenHost.this.emitNotification("vm.add", "Created", name);
                                }
                                catch (Exception ex) {
                                    logger.error((Object)ex);
                                }
                                break;
                            }
                            case DEL: {
                                XenVirtualMachine vm = XenHost.this.lookUpByUuid(vmRecord.uuid);
                                if (vm == null) break;
                                XenHost.this.removeVM(vm);
                                XenHost.this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
                                try {
                                    AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
                                }
                                catch (Exception ex) {
                                    logger.error((Object)ex);
                                }
                                break;
                            }
                            case MOD: {
                                XenVirtualMachine vm = XenHost.this.lookUpByUuid(vmRecord.uuid);
                                if (vm == null) break;
                                vm.updatePowerState(vmRecord.powerState);
                                break;
                            }
                        }
                    }
                }
            }
        }
    }
}

