/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xenapi;

import java.util.Map;
import javax.management.ObjectName;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenHost;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenVMImageStore;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class XenServerPool
extends ServerPool {
    private int port;
    private String user;
    private String password;
    private VirtualMachineImageStoreMXBean sharedImageStore;
    private String sharedStorageRepository;

    public XenServerPool(String name, ObjectName objectName, Map<String, String> attributes) throws IllegalArgumentException {
        super(name, objectName);
        String port = attributes.get("port");
        if (port == null) {
            this.port = 9363;
        } else {
            try {
                this.port = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Wrong value for port");
            }
        }
        this.user = attributes.get("user");
        this.password = attributes.get("password");
        this.sharedStorageRepository = attributes.get("sharedStorageRepository");
        if (this.sharedStorageRepository == null) {
            throw new IllegalArgumentException("Missing parameter: sharedStorageRepository");
        }
    }

    public String getSharedStorageRepository() {
        return this.sharedStorageRepository;
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> attributes) throws IllegalArgumentException {
        try {
            HostMXBean host2;
            for (HostMXBean host2 : this.hosts) {
                if (!host2.getHostName().equals(hostName)) continue;
                return host2;
            }
            ObjectName mbeanObjectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
            host2 = XenHost.newHost(this, mbeanObjectName, hostName, this.user, this.password, this.port, attributes);
            if (host2 != null) {
                AgentCommon.getMBeanServer().registerMBean(host2, mbeanObjectName);
                this.hosts.add(host2);
                ServerPool.logger.info((Object)("In server pool " + this.name + ": added Host MBean " + mbeanObjectName));
                if (this.sharedImageStore == null && this.sharedStorageRepository != null) {
                    ObjectName sharedImageStoreName = MBeanObjectNamer.makeVMImageStoreName(this.sharedStorageRepository);
                    try {
                        this.sharedImageStore = new XenVMImageStore(sharedImageStoreName, this.sharedStorageRepository, (XenHost)host2);
                        AgentCommon.getMBeanServer().registerMBean(this.sharedImageStore, sharedImageStoreName);
                    }
                    catch (Exception ex) {
                        ServerPool.logger.error((Object)ex);
                    }
                }
            }
            return host2;
        }
        catch (Exception ex) {
            ServerPool.logger.error((Object)"Failed to add XenHost", (Throwable)ex);
            return null;
        }
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.sharedImageStore;
    }
}

