/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenHost;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenVirtualMachine;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

public class XenVMImageStore
extends ManagedResource
implements VirtualMachineImageStoreMXBean {
    static Logger logger = Logger.getLogger(XenVMImageStore.class);
    private HashMap<String, XenVirtualMachineImage> vmMap = new HashMap();
    private String sharedStorageRepository;
    private Connection connection;
    private SR storageRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XenVMImageStore(ObjectName objectName, String sharedStorageRepository, XenHost host) throws VMMException {
        super(objectName);
        this.sharedStorageRepository = sharedStorageRepository;
        this.connection = host.getXenAPIConnection();
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                Set srSet = SR.getByNameLabel((Connection)this.connection, (String)sharedStorageRepository);
                if (srSet.isEmpty()) {
                    throw new VMMException("Cannot find storage repository " + sharedStorageRepository);
                }
                this.storageRepository = (SR)srSet.iterator().next();
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get shared SR " + sharedStorageRepository), (Throwable)ex);
            throw new VMMException(ex.toString());
        }
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sync() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Set vms = VM.getAll((Connection)this.connection);
                for (VM vm : vms) {
                    VM.Record vmRec = vm.getRecord(this.connection);
                    if (!vmRec.isATemplate.booleanValue() || this.vmMap.get(vmRec.uuid) != null) continue;
                    ObjectName on = MBeanObjectNamer.makeVMImageName(vmRec.uuid);
                    XenVirtualMachineImage image = new XenVirtualMachineImage(on, vmRec);
                    AgentCommon.getMBeanServer().registerMBean(image, image.getObjectName());
                    logger.debug((Object)("Adding Template: " + vmRec.nameLabel));
                    this.vmMap.put(vmRec.uuid, image);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"In ImageStore.sync:", (Throwable)ex);
            }
        }
    }

    public void removeVMImageTemplate(VirtualMachineImageMXBean vmImage) throws VMMException {
        XenVirtualMachineImage img;
        if (vmImage instanceof XenVirtualMachineImage && (img = (XenVirtualMachineImage)vmImage).getImageStore() == this) {
            this.vmMap.remove(img.getUUID());
        }
    }

    public VirtualMachineImageMXBean lookUpByName(String name) {
        for (XenVirtualMachineImage image : this.vmMap.values()) {
            if (!image.getName().equals(name)) continue;
            return image;
        }
        return null;
    }

    public VirtualMachineImageMXBean lookUpByUUID(String uuid) {
        return this.vmMap.get(uuid);
    }

    public List<VirtualMachineImageMXBean> listVMImageTemplates() {
        ArrayList<VirtualMachineImageMXBean> result = new ArrayList<VirtualMachineImageMXBean>(this.vmMap.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityMB() throws VMMException {
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                return this.storageRepository.getPhysicalSize(this.connection) / 0x100000L;
            }
        }
        catch (Exception ex) {
            throw XenVirtualMachine.translateXenAPIException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFreeSpaceMB() throws VMMException {
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                return this.getCapacityMB() - this.storageRepository.getPhysicalUtilisation(this.connection) / 0x100000L;
            }
        }
        catch (Exception ex) {
            throw XenVirtualMachine.translateXenAPIException(ex);
        }
    }

    public String getName() {
        return "ImageStore(" + this.sharedStorageRepository + ")";
    }

    class XenVirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String name;
        private String uuid;
        private String description;
        private Map<String, String> metadata;

        private XenVirtualMachineImage(ObjectName objectName, VM.Record vm) throws Exception {
            super(objectName);
            this.name = vm.nameLabel;
            this.description = vm.nameDescription;
            this.uuid = vm.uuid;
            this.metadata = vm.otherConfig;
        }

        XenVMImageStore getImageStore() {
            return XenVMImageStore.this;
        }

        public Map<String, String> getMetaData() {
            return this.metadata;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUUID() {
            return this.uuid;
        }
    }
}

