/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VBD;
import com.xensource.xenapi.VBDMetrics;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.VIFMetrics;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.VMGuestMetrics;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.xenapi.XenHost;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class XenVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(XenVirtualMachine.class);
    private XenHost host;
    private Connection connection;
    private VM vm;
    private String uuid;
    private String name;
    private String macAddress;
    private String imageID;
    private Date startTime;
    private VirtualMachineMXBean.PowerState cachedPowerState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XenVirtualMachine(ObjectName objectName, XenHost host, Connection connection, VM vm, Map<String, String> userData) {
        super(objectName);
        try {
            this.host = host;
            this.connection = connection;
            this.vm = vm;
            Connection connection2 = connection;
            synchronized (connection2) {
                this.uuid = vm.getUuid(connection);
                this.name = vm.getRecord((Connection)connection).isControlDomain == false ? vm.getNameLabel(connection) : "Domain-0";
                if (userData != null) {
                    for (String key : userData.keySet()) {
                        this.addUserData(key, userData.get(key));
                    }
                    this.imageID = userData.get("imageID");
                }
                if (this.imageID == null) {
                    this.imageID = this.getUserData("imageID");
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to init VM", (Throwable)ex);
        }
    }

    public boolean canLiveMigrateToHost(HostMXBean targetHost) throws VMMException {
        XenHost xenHost = null;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getObjectName().equals(targetHost.getObjectName())) continue;
            xenHost = (XenHost)h;
            break;
        }
        return xenHost != null && xenHost != this.host && this.getMemorySizeMB() < xenHost.getFreeMemoryMB();
    }

    public VirtualMachineMXBean cloneVM(String clonedVmName, VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, VMMException {
        return this.host.cloneVM(this.vm, clonedVmName, custSpec, sync);
    }

    public String getUuid() {
        return this.uuid;
    }

    public HostMXBean getHostMBean() {
        return this.host;
    }

    public long getDomID() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.vm.getDomid(this.connection).intValue();
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getStartTime() throws VMMException {
        if (this.startTime == null) {
            Connection connection = this.connection;
            synchronized (connection) {
                try {
                    this.startTime = this.vm.getMetrics(this.connection).getStartTime(this.connection);
                    GregorianCalendar calendar = new GregorianCalendar();
                    this.startTime = new Date(this.startTime.getTime() + (long)calendar.get(16) + (long)calendar.get(15));
                }
                catch (Exception ex) {
                    throw XenVirtualMachine.translateXenAPIException(ex);
                }
            }
        }
        return this.startTime;
    }

    public long getUpTimeSeconds() throws VMMException {
        return (System.currentTimeMillis() - this.getStartTime().getTime()) / 1000L;
    }

    public ResourceUsage getResourceUsage() throws VMMException {
        ResourceUsage usage = new ResourceUsage();
        try {
            usage.setCpuLoad(this.getCPULoad());
            usage.setMemoryUsedKBytes(this.getMemoryUsedMB());
            Set vifs = this.vm.getVIFs(this.connection);
            ArrayList<ResourceUsage.NetworkStats> netStats = new ArrayList<ResourceUsage.NetworkStats>();
            for (VIF vif : vifs) {
                VIFMetrics.Record vifMetrics = vif.getMetrics(this.connection).getRecord(this.connection);
                ResourceUsage.NetworkStats netStat = new ResourceUsage.NetworkStats(vif.getDevice(this.connection), vifMetrics.ioReadKbs.longValue(), vifMetrics.ioWriteKbs.longValue());
                netStats.add(netStat);
            }
            usage.setNetworkStats(netStats);
            Set vbds = this.vm.getVBDs(this.connection);
            ArrayList<ResourceUsage.DiskStats> diskStats = new ArrayList<ResourceUsage.DiskStats>();
            for (VBD vbd : vbds) {
                VBDMetrics.Record vbdMetrics = vbd.getMetrics(this.connection).getRecord(this.connection);
                ResourceUsage.DiskStats diskStat = new ResourceUsage.DiskStats(vbd.getDevice(this.connection), vbdMetrics.ioReadKbs.longValue(), vbdMetrics.ioWriteKbs.longValue());
                diskStats.add(diskStat);
            }
            usage.setDiskStats(diskStats);
        }
        catch (Exception ex) {
            throw XenVirtualMachine.translateXenAPIException(ex);
        }
        return usage;
    }

    public float getCPULoad() throws VMMException {
        float[] vcpuLoads = this.getLoadPerVCPU();
        float cpuLoad = 0.0f;
        for (float vcpuLoad : vcpuLoads) {
            cpuLoad += vcpuLoad;
        }
        return cpuLoad / (float)this.host.getNumCPU();
    }

    public float[] getLoadPerVCPU() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Map map = this.vm.getMetrics(this.connection).getVCPUsUtilisation(this.connection);
                float[] vals = new float[map.keySet().size()];
                for (Map.Entry entry : map.entrySet()) {
                    vals[((Long)entry.getKey()).intValue()] = ((Double)entry.getValue()).floatValue();
                }
                return vals;
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    public long getMemorySizeMB() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.vm.getMemoryDynamicMax(this.connection) / 0x100000L;
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemorySizeMB(long size) throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.setMemoryDynamicMax(this.connection, Long.valueOf(size * 1014L * 1024L));
                this.vm.setMemoryDynamicMin(this.connection, Long.valueOf(size * 1024L * 1024L));
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    public long getMemoryUsedMB() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.vm.getMetrics(this.connection).getMemoryActual(this.connection).intValue() / 0x100000;
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    public String getNameLabel() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserData(String key, String value) throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.addToXenstoreData(this.connection, key, value);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    public String getUserData(String key) throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return (String)this.vm.getXenstoreData(this.connection).get(key);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    public String getConsole() {
        return null;
    }

    public int getNumVCPUs() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.vm.getMetrics(this.connection).getVCPUsNumber(this.connection).intValue();
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[][] getCPUAffinity() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            boolean[][] result = new boolean[this.getNumVCPUs()][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new boolean[this.host.getNumCPU()];
            }
            try {
                Map map = this.vm.getVCPUsParams(this.connection);
                String mask = (String)map.get("mask");
                if (mask == null) {
                    for (int i = 0; i < result.length; ++i) {
                        for (int j = 0; j < result[i].length; ++j) {
                            result[i][j] = true;
                        }
                    }
                } else {
                    StringTokenizer st = new StringTokenizer(mask, ",");
                    ArrayList<Integer> pinCpus = new ArrayList<Integer>();
                    while (st.hasMoreTokens()) {
                        try {
                            pinCpus.add(Integer.parseInt(st.nextToken()));
                        }
                        catch (NumberFormatException ex) {}
                    }
                    for (int i = 0; i < this.getNumVCPUs(); ++i) {
                        for (Integer j : pinCpus) {
                            result[i][j.intValue()] = true;
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCPUAffinity(boolean[][] affinity) throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Map map = this.vm.getVCPUsParams(this.connection);
                StringBuffer mask = new StringBuffer();
                int count = 0;
                for (int i = 0; i < affinity[0].length; ++i) {
                    if (!affinity[0][i]) continue;
                    if (count++ > 0) {
                        mask.append(',');
                    }
                    mask.append(i);
                }
                map.put("mask", mask.toString());
                this.vm.setVCPUsParams(this.connection, map);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    public int getSchedulingCap() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Map vcpuParams = this.vm.getVCPUsParams(this.connection);
                logger.debug((Object)("params=" + vcpuParams));
                if (vcpuParams.get("cap") != null) {
                    return Integer.parseInt((String)vcpuParams.get("cap"));
                }
                return 0;
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    public int getSchedulingWeight() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Map vcpuParams = this.vm.getVCPUsParams(this.connection);
                if (vcpuParams.get("weight") != null) {
                    return Integer.parseInt((String)vcpuParams.get("weight"));
                }
                return 256;
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachineMXBean.PowerState getState() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                Types.VmPowerState state = this.vm.getPowerState(this.connection);
                this.updatePowerState(state);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
        return this.cachedPowerState;
    }

    void updatePowerState(Types.VmPowerState state) {
        VirtualMachineMXBean.PowerState newState = VirtualMachineMXBean.PowerState.UNKNOWN;
        if (state == Types.VmPowerState.HALTED) {
            newState = VirtualMachineMXBean.PowerState.HALTED;
        } else if (state == Types.VmPowerState.RUNNING) {
            newState = VirtualMachineMXBean.PowerState.RUNNING;
        } else if (state == Types.VmPowerState.PAUSED) {
            newState = VirtualMachineMXBean.PowerState.PAUSED;
        } else if (state == Types.VmPowerState.SUSPENDED) {
            newState = VirtualMachineMXBean.PowerState.SUSPENDED;
        } else if (state == Types.VmPowerState.PAUSED) {
            newState = VirtualMachineMXBean.PowerState.PAUSED;
        }
        if (newState != this.cachedPowerState) {
            this.emitNotification("vm.state", newState.toString(), null);
            this.cachedPowerState = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGuestIpAddress() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                VMGuestMetrics guestMetrics = this.vm.getGuestMetrics(this.connection);
                Map map = guestMetrics.getOsVersion(this.connection);
                map = guestMetrics.getNetworks(this.connection);
                if (map != null) {
                    return (String)map.get("0/ip");
                }
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMacAddress() throws VMMException {
        try {
            if (this.getState() != VirtualMachineMXBean.PowerState.RUNNING) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.macAddress == null) {
            Connection connection = this.connection;
            synchronized (connection) {
                try {
                    Set vifs = this.vm.getVIFs(this.connection);
                    for (VIF vif : vifs) {
                        String vifName = vif.getDevice(this.connection);
                        if (!vifName.equals("0")) continue;
                        this.macAddress = vif.getMAC(this.connection);
                        logger.debug((Object)("VM " + this.name + " Mac address=" + this.macAddress));
                        break;
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to get MAC address of VM " + this.name), (Throwable)ex);
                    throw XenVirtualMachine.translateXenAPIException(ex);
                }
            }
        }
        return this.macAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumVCPUs(int numVCPUs) throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.setVCPUsNumberLive(this.connection, Long.valueOf(numVCPUs));
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingCap(int schedulingCap) throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("cap", String.valueOf(schedulingCap));
            try {
                this.vm.setVCPUsParams(this.connection, map);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingWeight(int schedulingWeight) throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("weight", String.valueOf(schedulingWeight));
            try {
                this.vm.setVCPUsParams(this.connection, map);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.suspend(this.connection);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(HostMXBean targetHost, boolean live) throws IllegalOperationException, VMMException {
        if (!live) {
            throw new IllegalOperationException("Not implemented");
        }
        String targetHostName = targetHost.getHostName();
        logger.info((Object)("Attempting live migration of VM " + this.name + " to host " + targetHostName));
        boolean foundHostInServerPool = false;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getHostName().equals(targetHost.getHostName())) continue;
            foundHostInServerPool = true;
            targetHost = h;
            break;
        }
        if (!foundHostInServerPool) {
            throw new IllegalOperationException("Source and target hosts belong to different server pools");
        }
        XenHost targetXenHost = (XenHost)targetHost;
        String imageID = this.getUserData("imageID");
        logger.info((Object)("VM " + this.name + " live migration to host " + targetHostName + "..."));
        this.emitNotification("vm.migration.start", targetHostName, null);
        try {
            this.vm.poolMigrate(this.connection, targetXenHost.host, null);
        }
        catch (Exception ex) {
            throw XenVirtualMachine.translateXenAPIException(ex);
        }
        logger.info((Object)("VM " + this.name + " live migration done"));
        this.host.postMigrateVM(this, targetXenHost);
        this.host = targetXenHost;
        this.addUserData("imageID", imageID);
        Connection connection = this.connection = targetXenHost.getXenAPIConnection();
        synchronized (connection) {
            int attempts = 3;
            while (true) {
                try {
                    this.vm = VM.getByUuid((Connection)this.connection, (String)this.uuid);
                }
                catch (Exception ex) {
                    if (--attempts > 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    logger.error((Object)"Cannot get VM XenAPI handle after migration: ", (Throwable)ex);
                }
                break;
            }
        }
        this.emitNotification("vm.migration", targetHostName, this.uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.cleanShutdownAsync(this.connection);
                this.getState();
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.startAsync(this.connection, Boolean.valueOf(false), Boolean.valueOf(false));
                this.getState();
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.cleanRebootAsync(this.connection);
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.resumeAsync(this.connection, Boolean.valueOf(false), Boolean.valueOf(false));
                this.getState();
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.pauseAsync(this.connection);
                this.getState();
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.vm.unpauseAsync(this.connection);
                this.getState();
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws VMMException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                if (this.getState() == VirtualMachineMXBean.PowerState.RUNNING) {
                    this.vm.hardShutdown(this.connection);
                }
                this.vm.destroy(this.connection);
                logger.info((Object)("VM " + this.name + " destroyed"));
            }
            catch (Exception ex) {
                throw XenVirtualMachine.translateXenAPIException(ex);
            }
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.migration.abort", "vm.migration.start", "vm.migration", "log", "vm.error"}, Notification.class.getName(), "VM event")};
    }

    public VirtualMachineImageMXBean makeTemplate(String name, String description, Map<String, String> metadata) throws InsufficientResourcesException, IllegalOperationException, BadVMPowerStateException, VMMException {
        throw new UnsupportedOperationException();
    }

    static VMMException translateXenAPIException(Exception ex) {
        logger.error((Object)("XenAPI exception:" + ex.toString()));
        if (ex instanceof Types.VmBadPowerState) {
            return new BadVMPowerStateException(ex.toString());
        }
        return new VMMException(ex.toString());
    }
}

