/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.jmx;

import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class MBeanObjectNamer {
    private static Logger logger = Logger.getLogger(MBeanObjectNamer.class);
    private static final String DOMAIN = "org.ow2.jasmine.vmm.api";

    public static final ObjectName makeHostName(String path, String hostName) {
        try {
            ObjectName name = new ObjectName("org.ow2.jasmine.vmm.api:type=Host,name=" + path + ",hostname=" + hostName);
            return name;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(hostName, ex);
        }
    }

    public static final ObjectName makeVirtualMachineName(String path, String uuid) {
        try {
            ObjectName name = new ObjectName("org.ow2.jasmine.vmm.api:type=VirtualMachine,name=" + path + ",uuid=" + uuid);
            return name;
        }
        catch (Exception ex) {
            logger.debug((Object)("path=" + path + " uuid=" + uuid));
            throw new IllegalArgumentException(uuid, ex);
        }
    }

    public static final ObjectName makeDomainName(String path) {
        try {
            ObjectName name = new ObjectName("org.ow2.jasmine.vmm.api:type=Domain,name=" + path);
            return name;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(path, ex);
        }
    }

    public static final ObjectName makeServerPoolName(String path) {
        try {
            ObjectName name = new ObjectName("org.ow2.jasmine.vmm.api:type=ServerPool,name=" + path);
            return name;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(path, ex);
        }
    }

    public static final ObjectName makeVMImageStoreName(String dsName) {
        try {
            ObjectName name = new ObjectName("org.ow2.jasmine.vmm.api:type=VirtualMachineImageStore,name=" + dsName);
            return name;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(dsName, ex);
        }
    }

    public static final ObjectName makeVMImageName(String uuid) {
        try {
            ObjectName name = new ObjectName("org.ow2.jasmine.vmm.api:type=VirtualMachineImage,uuid=" + uuid);
            return name;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(uuid, ex);
        }
    }

    public static final ObjectName makeAgentName() {
        try {
            ObjectName name = new ObjectName("org.ow2.jasmine.vmm.api:type=Agent");
            return name;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

