/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.main;

import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.vmm.agent.main.VirtManagerAgent;
import org.ow2.jasmine.vmm.api.VMMAgentMXBean;

public class AgentControl {
    private static final int DEFAULT_PORT = 9999;
    private static final String DEFAULT_HOST = "localhost";

    public static void main(String[] args) {
        String s;
        if (VirtManagerAgent.vmmHome == null) {
            System.out.println("vmm.home system property must be set");
            System.exit(1);
        }
        int port = 9999;
        String host = DEFAULT_HOST;
        Mode mode = null;
        for (int i = 0; i < args.length && (s = args[i]).startsWith("-"); ++i) {
            if (s.equals("-start")) {
                mode = Mode.START;
                continue;
            }
            if (s.equals("-stop")) {
                mode = Mode.STOP;
                continue;
            }
            if (s.equals("-port")) {
                if (i < args.length - 1) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                AgentControl.printUsageAndExit();
                continue;
            }
            if (s.equals("-host")) {
                if (i < args.length - 1) {
                    host = args[++i];
                    continue;
                }
                AgentControl.printUsageAndExit();
                continue;
            }
            AgentControl.printUsageAndExit();
        }
        if (mode == null) {
            AgentControl.printUsageAndExit();
        }
        if (mode == Mode.START) {
            new VirtManagerAgent();
        } else if (mode == Mode.STOP) {
            try {
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/server");
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                ObjectName agentObjectName = new ObjectName("org.ow2.jasmine.vmm.api:type=Agent");
                VMMAgentMXBean agentMBean = JMX.newMXBeanProxy(mbsc, agentObjectName, VMMAgentMXBean.class);
                agentMBean.shutdown();
                jmxc.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: java org.ow2.jasmine.vmm.agent.main.AgentControl -start|stop [-port <port>] [-host <host>]");
        System.exit(1);
    }

    private static enum Mode {
        START,
        STOP;

    }
}

