/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.Domain;
import org.ow2.jasmine.vmm.agent.domain.DomainBuilder;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.DomainMXBean;
import org.ow2.jasmine.vmm.api.VMMAgentMXBean;

public class VirtManagerAgent
extends AgentCommon
implements VMMAgentMXBean {
    private static Logger logger = Logger.getLogger(VirtManagerAgent.class);
    public static final String vmmHome = System.getProperty("vmm.home");
    static VirtManagerAgent instance;
    private JMXConnectorServer cs;
    Domain rootDomain;

    public DomainMXBean getRootDomain() {
        return this.rootDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtManagerAgent() {
        int port;
        instance = this;
        Properties properties = new Properties();
        String agentPropFileName = "etc" + File.separator + "agent.properties";
        try {
            properties.load(new FileInputStream(new File(vmmHome, agentPropFileName)));
        }
        catch (IOException ex) {
            logger.fatal((Object)("Cannot load VMM agent property file " + agentPropFileName), (Throwable)ex);
            System.exit(1);
        }
        ObjectName agentName = MBeanObjectNamer.makeAgentName();
        try {
            AgentCommon.mbs.registerMBean(this, agentName);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Cannot register MXBean " + agentName), (Throwable)ex);
            System.exit(1);
        }
        logger.info((Object)("Created VMMAgent MBean " + agentName));
        try {
            port = Integer.parseInt(properties.getProperty("vmm.port"));
        }
        catch (NumberFormatException ex) {
            port = 9999;
        }
        String managedResourcesFileName = properties.getProperty("vmm.resourceFile", "managed-resources.xml");
        File managedResourcesFile = new File(vmmHome, "etc" + File.separator + managedResourcesFileName);
        this.rootDomain = DomainBuilder.createManagedResourcesFromXML(managedResourcesFile);
        if (this.rootDomain == null) {
            logger.fatal((Object)"Failed to load resource file");
            System.exit(1);
        }
        try {
            LocateRegistry.createRegistry(port);
        }
        catch (RemoteException ex) {
            logger.warn((Object)("Cannot launch RMI registry on port " + port + ", creating new one"));
            try {
                LocateRegistry.createRegistry(port);
            }
            catch (RemoteException ex2) {
                logger.fatal((Object)"Cannot create RMI registry", (Throwable)ex);
                System.exit(1);
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, AgentCommon.mbs);
            logger.info((Object)("Starting RMI connector server with URL \"" + url + "\""));
            this.cs.start();
            logger.info((Object)"VMM agent ready");
        }
        catch (Exception ex) {
            logger.fatal((Object)"Failed to start JMX connector server", (Throwable)ex);
            System.exit(1);
        }
        VirtManagerAgent ex = this;
        synchronized (ex) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            this.cs.stop();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"VMM agent terminated");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        VirtManagerAgent virtManagerAgent = this;
        synchronized (virtManagerAgent) {
            this.notifyAll();
        }
    }
}

