/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009-2010 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Driver.java 7453 2011-01-19 22:52:49Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.driver;

import java.util.Map;

import javax.management.ObjectName;

import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.api.VMMException;

/**
 * The Driver class is the entry point of a driver encapsulating a specific
 * server virtualization technology and its associated management protocol. A
 * driver boils down to a factory of server pools.
 */
public interface Driver {
    /**
     * Builds a new server pool
     * 
     * @param name user-friendly name of the server pool
     * @param objectname JMX object name of the server pool
     * @param props driver-specific properties to be used to create this server
     *        pool
     * @return
     */
    ServerPool newServerPool(String name, ObjectName objectname, Map<String, String> attributes)
        throws IllegalArgumentException, VMMException;

    /**
     * give the attributes of the server pool
     * 
     * @return
     */
    String[] getServerPoolCreationAttributes();

}
