/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009-2010 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DummyDriver.java 7454 2011-01-19 22:56:21Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.driver.dummy;

import java.util.Map;

import javax.management.ObjectName;

import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.Driver;

/**
 * Dummy driver implementation The dummy driver does not require any properties
 */
public class DummyDriver implements Driver {

    private static String[] attributes = {"sshRootPaswword", "sshPrivateKeyFile", "user", "password"};

    public ServerPool newServerPool(final String name, final ObjectName objectName, final Map<String, String> attributes) {
        DummyServerPool pool = new DummyServerPool(name, objectName, attributes);
        return pool;
    }

    @Override
    public String[] getServerPoolCreationAttributes() {
        return DummyDriver.attributes;
    }
}