package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class HyperVEventCollector {
    static Logger logger = Logger.getLogger(HyperVEventCollector.class);

    private HyperVServerPool pool;

    private List<HyperVHost> hosts;

    private boolean close = false;

    public HyperVEventCollector(final HyperVServerPool pool) {
        this.pool = pool;
        this.hosts = new ArrayList<HyperVHost>();
    }

    public void add(final HyperVHost host, final HyperVConnection hypervConnection) {
        this.close = false;
        if (!this.hosts.contains(host)) {
            this.hosts.add(host);

            try {
                this.pool.getExecutorService().execute(new Runnable() {
                    public void run() {
                        HyperVEventCollector.logger.debug("Start pulling events on host : " + host.getHostName());
                        while (true) {
                            try {

                                host.sync(hypervConnection);

                                if (HyperVEventCollector.this.close) {
                                    break;
                                }

                                for (VirtualMachineMXBean vm : host.getResidentVMs()) {
                                    if (HyperVEventCollector.this.close) {
                                        break;
                                    }
                                    ((HyperVVirtualMachine) vm).onVMStateChanged(((HyperVVirtualMachine) vm)
                                        .getState(hypervConnection));
                                }

                                Thread.sleep(HyperVServerPool.EVENT_COLLECTOR_PERIOD);
                            } catch (Exception ex) {
                                HyperVEventCollector.logger.error("In Hyperv event collector: ", ex);
                            }
                            if (HyperVEventCollector.this.close) {
                                break;
                            }
                        }
                    }
                });

            } catch (Exception ex) {
                HyperVEventCollector.logger.error("Failed to initialize event collector", ex);
            }
        }
    }

    public void stop() {
        this.close = true;
        this.hosts.clear();
        HyperVEventCollector.logger.debug("Stopped periodic event collecting task");
    }
}
