/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.driver.util;

import javax.management.StandardMBean;

import org.ow2.jasmine.vmm.api.ResourceUsage;

public class ResourceUsageHelper {

    public static interface ResourceUsageSerializerInterface {
        void setResourceUsage(ResourceUsage usage);

        ResourceUsage getResourceUsage();
    }

    public static class ResourceUsageSerializer extends StandardMBean implements ResourceUsageSerializerInterface {

        private ResourceUsage usage;

        public ResourceUsageSerializer() {
            super(ResourceUsageSerializerInterface.class, true);
        }

        public ResourceUsage getResourceUsage() {
            return this.usage;
        }

        public void setResourceUsage(final ResourceUsage usage) {
            this.usage = usage;
        }
    }

    public static Object serialize(final ResourceUsage usage) {
        try {
            ResourceUsageSerializer me = new ResourceUsageSerializer();
            me.setResourceUsage(usage);
            return me.getAttribute("ResourceUsage");
        } catch (Exception ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
    }

}
