/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FileUtils.java 5910 2010-01-13 17:10:39Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.driver.virtimage;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;

public class FileUtils {
    static Logger logger = Logger.getLogger(FileUtils.class);

    static public long getDiskCapacityMB(final String hostName, final RemoteExec.SshAuthInfo authInfo, final String path) {
        long size = -1;
        RemoteExec.Result result = null;
        String command = "df -hP " + path;
        try {
            result = RemoteExec.commandAsRoot(hostName, authInfo, command);
        } catch (RemoteExec.SshException ex) {
            FileUtils.logger.debug("SSH failure", ex);
            return -1;
        }
        try {
            // logger.debug("Host " + hostName + ": " + command + ": \n" +
            // result.output);
            BufferedReader reader = new BufferedReader(new StringReader(result.output));
            // skip header line
            reader.readLine();
            String s = reader.readLine();
            StringTokenizer st = new StringTokenizer(s);
            st.nextToken();
            size = FileUtils.parseSizeToMB(st.nextToken());
        } catch (Exception ex) {
            FileUtils.logger.debug("Host " + hostName, ex);
        }
        return size;
    }

    static public long getDiskFreeSpaceMB(final String hostName, final RemoteExec.SshAuthInfo authInfo, final String path) {
        long size = -1;
        RemoteExec.Result result = null;
        String command = "df -hP " + path;
        try {
            result = RemoteExec.commandAsRoot(hostName, authInfo, command);
        } catch (RemoteExec.SshException ex) {
            FileUtils.logger.debug("SSH failure", ex);
            return -1;
        }
        try {
            // logger.debug("Host " + hostName + ": " + command + ": \n" +
            // result.output);
            BufferedReader reader = new BufferedReader(new StringReader(result.output));
            // skip header line
            reader.readLine();
            String s = reader.readLine();
            StringTokenizer st = new StringTokenizer(s);
            st.nextToken();
            st.nextToken();
            st.nextToken();
            size = FileUtils.parseSizeToMB(st.nextToken());
        } catch (Exception ex) {
            FileUtils.logger.debug("Host " + hostName, ex);
        }
        return size;
    }

    static long parseSizeToMB(final String s) {
        if (s.equals("0")) {
            return 0;
        }
        char c = s.charAt(s.length() - 1);
        float mult = 1;
        if (c == 'K') {
            mult /= 1024.0f;
        } else if (c == 'G') {
            mult = 1024;
        } else if (c == 'T') {
            mult = 1024 * 1024;
        }
        return (long) (Float.parseFloat(s.substring(0, s.length() - 1)) * mult);
    }

}
