/**
 * JASMINe VMMapi: JASMINe Virtual Machine Management API
 * Copyright (C) 2010 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbstractConfigurationGenerator.java 7452 2011-01-19 22:47:52Z dangtran $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.vmm.agent.main.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.ContentHandler;

public abstract class AbstractConfigurationGenerator implements ConfigurationGenerator {

    /**
     * The base directory where files are generated.
     */
    protected String baseDir;

    /**
     * @param baseDir The base directory where files are generated, or null to
     *        use the default base directory of the generator.
     * @throws ConfigurationGeneratorException
     */
    public AbstractConfigurationGenerator(String baseDir) throws ConfigurationGeneratorException {
        if (baseDir == null) {
            throw new ConfigurationGeneratorException("Base directory for generation cannot be null.");
        }
        if (!baseDir.endsWith("/")) {
            baseDir += "/";
        }
        this.baseDir = baseDir;
    }

    /**
     * @param fileName
     * @return a SAX handler for the given file.
     * @throws FileNotFoundException
     * @throws TransformerConfigurationException
     */
    protected ContentHandler getHandler(final String fileName) throws FileNotFoundException, TransformerConfigurationException {
        new File(this.baseDir).mkdirs();
        String filePath = this.baseDir + fileName;
        PrintWriter out = new PrintWriter(filePath);
        StreamResult streamResult = new StreamResult(out);
        SAXTransformerFactory tf = (SAXTransformerFactory) TransformerFactory.newInstance();
        tf.setAttribute("indent-number", new Integer(2));
        TransformerHandler hd = tf.newTransformerHandler();
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");
        serializer.setOutputProperty(OutputKeys.INDENT, "yes");
        hd.setResult(streamResult);
        return hd;
    }

    /*
     * (non-Javadoc)
     * @see vmscript.configuration.parsing.ConfigurationGenerator#getBaseDir()
     */
    public String getBaseDir() {
        return this.baseDir;
    }
}
