/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.Driver;
import org.ow2.jasmine.vmm.agent.driver.DriverFactory;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.agent.main.VirtManagerAgent;
import org.ow2.jasmine.vmm.api.DomainMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public final class Domain
extends ManagedResource
implements DomainMXBean {
    private static Logger logger = Logger.getLogger(Domain.class);
    private String name;
    private final List<DomainMXBean> subDomains = new ArrayList<DomainMXBean>();
    private final List<ServerPoolMXBean> serverPools = new ArrayList<ServerPoolMXBean>();
    private final Map<String, String> attributes = new HashMap<String, String>();

    public Domain(String name, ObjectName objectName, Map<String, String> attributes) {
        super(objectName);
        this.attributes.putAll(attributes);
        this.name = name;
    }

    public DomainMXBean getLastSubDomainMXBean() {
        return this.subDomains.get(this.subDomains.size() - 1);
    }

    public String getName() {
        return this.name;
    }

    public List<DomainMXBean> getSubDomains() {
        return this.subDomains;
    }

    public void addSubDomain(Domain d) {
        this.subDomains.add(d);
    }

    public DomainMXBean addSubDomain(String name, Map<String, String> attributes) throws VMMException {
        if (this.lookUpSubDomainByName(name) != null) {
            throw new VMMException("Domain " + name + " already exists");
        }
        ObjectName domainObjectName = MBeanObjectNamer.makeDomainName(this.getPath() + "/" + name);
        Domain d = new Domain(name, domainObjectName, attributes);
        this.subDomains.add(d);
        try {
            AgentCommon.getMBeanServer().registerMBean(d, domainObjectName);
        }
        catch (Exception ex) {
            logger.error((Object)("Skipping domain " + name), (Throwable)ex);
            return null;
        }
        logger.info((Object)("Added Domain " + domainObjectName));
        this.emitNotification("domain.add", "Add Domain", d.getObjectName());
        VirtManagerAgent.getInstance().saveConfiguration();
        return d;
    }

    public void deleteSubDomain(DomainMXBean domain) throws VMMException {
        int indexToRemove = -1;
        for (DomainMXBean domain_existant : this.subDomains) {
            if (!domain_existant.getName().equals(domain.getName())) continue;
            indexToRemove = this.subDomains.indexOf(domain_existant);
            break;
        }
        if (indexToRemove == -1) {
            throw new VMMException("Cannot find subdomain to delete");
        }
        DomainMXBean domainToRemove = this.subDomains.get(indexToRemove);
        while (domainToRemove.getSubDomains().size() > 0) {
            try {
                domainToRemove.deleteSubDomain((DomainMXBean)domainToRemove.getSubDomains().get(0));
            }
            catch (VMMException e) {
                logger.error((Object)e);
            }
        }
        while (domainToRemove.getServerPools().size() > 0) {
            try {
                domainToRemove.deleteServerPool((ServerPoolMXBean)domainToRemove.getServerPools().get(0));
            }
            catch (VMMException e) {
                logger.error((Object)e);
            }
        }
        this.subDomains.remove(indexToRemove);
        ObjectName domainObjectName = domainToRemove.getObjectName();
        try {
            AgentCommon.getMBeanServer().unregisterMBean(domainObjectName);
            this.emitNotification("domain.inventory.del", "suppresion domain", domainObjectName);
            VirtManagerAgent.getInstance().saveConfiguration();
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)e);
        }
    }

    public void deleteServerPool(ServerPoolMXBean server) throws VMMException {
        ObjectName serverObjectName = server.getObjectName();
        int indexToRemove = -1;
        for (ServerPoolMXBean server_existant : this.serverPools) {
            try {
                if (!server_existant.getName().equals(server.getName())) continue;
                indexToRemove = this.serverPools.indexOf(server_existant);
            }
            catch (Throwable e) {
                logger.error((Object)e);
            }
        }
        ServerPool serverPoolToRemove = (ServerPool)this.serverPools.get(indexToRemove);
        while (serverPoolToRemove.getManagedHosts().size() > 0) {
            serverPoolToRemove.deleteHost(serverPoolToRemove.getManagedHosts().get(0));
        }
        serverPoolToRemove.deleteImageStore();
        this.serverPools.remove(indexToRemove);
        try {
            AgentCommon.getMBeanServer().unregisterMBean(server.getObjectName());
            VirtManagerAgent.getInstance().saveConfiguration();
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)e);
        }
        this.emitNotification("serverpool.inventory.del", "delete serverpool", serverObjectName);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void addServerPool(ServerPool pool) {
        this.serverPools.add(pool);
    }

    public ServerPoolMXBean addServerPool(String name, Map<String, String> attributes, String driverName) throws VMMException {
        if (this.lookUpServerPoolByName(name) != null) {
            throw new VMMException("ServerPool " + name + " already exists");
        }
        ObjectName serverObjectName = MBeanObjectNamer.makeServerPoolName(this.getPath() + "/" + name);
        Driver driver = DriverFactory.getInstance().newDriver(driverName);
        if (driver != null) {
            ServerPool pool;
            try {
                pool = driver.newServerPool(name, serverObjectName, attributes);
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)("Skipping ServerPool " + name + ":" + ex.getMessage()));
                this.emitNotification("serverpool.error", "Skipping ServerPool", serverObjectName);
                throw new VMMException(ex.getMessage());
            }
            try {
                AgentCommon.getMBeanServer().registerMBean(pool, serverObjectName);
            }
            catch (Exception ex) {
                logger.error((Object)("Skipping ServerPool " + name), ex.getCause());
                this.emitNotification("serverpool.error", "ServerPool already exists", serverObjectName);
                throw new VMMException((Throwable)ex);
            }
            logger.info((Object)("Added ServerPool " + serverObjectName));
            this.addServerPool(pool);
            this.emitNotification("serverpool.inventory.add", "Add ServerPool", serverObjectName);
            VirtManagerAgent.getInstance().saveConfiguration();
            return pool;
        }
        logger.error((Object)("Driver " + driverName + " not found"));
        this.emitNotification("serverpool.error", "Skipping ServerPool", serverObjectName);
        throw new VMMException("Driver " + driverName + " not found");
    }

    public List<ServerPoolMXBean> getServerPools() {
        return this.serverPools;
    }

    public ServerPoolMXBean getLatestServerPool() {
        return this.serverPools.get(this.serverPools.size() - 1);
    }

    private boolean areConstraintsSatisfied(Map<String, String> constraints) {
        if (constraints == null) {
            return true;
        }
        String locationConstraint = constraints.get("location");
        if (locationConstraint == null || locationConstraint.equals("")) {
            return true;
        }
        String domainLocation = this.attributes.get("location");
        if (domainLocation == null) {
            return true;
        }
        return domainLocation.equals(locationConstraint);
    }

    public VirtualMachineMXBean provisionVM(VMConfigSpec vmSpec, Map<String, String> constraints, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        VirtualMachineMXBean vm = null;
        logger.info((Object)("Domain " + this.name + ": provisioning VM(name=" + vmSpec.getName() + ",imageID=" + vmSpec.getVmImageUUID() + ")..."));
        ArrayList<VMMException> raisedExceptions = new ArrayList<VMMException>();
        if (this.areConstraintsSatisfied(constraints)) {
            for (ServerPoolMXBean serverPool : this.serverPools) {
                try {
                    vm = serverPool.provisionVM(vmSpec, constraints, sync);
                    return vm;
                }
                catch (VMMException ex) {
                    raisedExceptions.add(ex);
                }
            }
        } else {
            throw new InsufficientResourcesException("Cannot meet constraints");
        }
        for (DomainMXBean subDomain : this.subDomains) {
            try {
                vm = subDomain.provisionVM(vmSpec, constraints, sync);
                return vm;
            }
            catch (VMMException ex) {
                raisedExceptions.add(ex);
            }
        }
        for (VMMException ex : raisedExceptions) {
            if (!(ex instanceof InsufficientResourcesException)) continue;
            throw (InsufficientResourcesException)ex;
        }
        for (VMMException ex : raisedExceptions) {
            if (!(ex instanceof InvalidVMConfigException)) continue;
            throw (InvalidVMConfigException)ex;
        }
        Iterator<Object> i$ = raisedExceptions.iterator();
        if (i$.hasNext()) {
            VMMException ex;
            ex = (VMMException)((Object)i$.next());
            throw ex;
        }
        throw new InsufficientResourcesException();
    }

    private DomainMXBean lookUpSubDomainByName(String name) {
        for (DomainMXBean domain : this.subDomains) {
            if (!domain.getName().equals(name)) continue;
            return domain;
        }
        return null;
    }

    private ServerPoolMXBean lookUpServerPoolByName(String name) {
        for (ServerPoolMXBean pool : this.serverPools) {
            if (!pool.getName().equals(name)) continue;
            return pool;
        }
        return null;
    }
}

