/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.AbstractHost;
import org.ow2.jasmine.vmm.agent.domain.DomainBuilder;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.policy.PolicyRegistry;
import org.ow2.jasmine.vmm.agent.domain.policy.VMPlacementPolicy;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.agent.main.VirtManagerAgent;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public abstract class ServerPool
extends ManagedResource
implements ServerPoolMXBean {
    protected static Logger logger = Logger.getLogger(ServerPool.class);
    protected String servername;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected final List<HostMXBean> hosts = new ArrayList<HostMXBean>();
    protected VMPlacementPolicy placementPolicy = PolicyRegistry.getInstance().newDefaultPolicy();

    public ServerPool(String name, ObjectName objectName, Map<String, String> attributes) {
        super(objectName);
        this.servername = name;
        this.attributes = attributes;
    }

    public String getName() {
        return this.servername;
    }

    public abstract HostMXBean newHost(String var1, Map<String, String> var2) throws VMMException;

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    protected void addHost(HostMXBean host) {
        this.hosts.add(host);
        try {
            logger.info((Object)("Added host " + host.getHostName()));
        }
        catch (VMMException ex) {
            logger.error((Object)ex);
        }
    }

    public HostMXBean addHost(Map<String, String> attributes) throws VMMException {
        String hostName = attributes.get("name");
        if (hostName == null) {
            throw new VMMException("Missing host name attribute");
        }
        for (HostMXBean host : this.hosts) {
            if (!host.getHostName().equals(hostName)) continue;
            throw new VMMException("Host " + hostName + " already exists");
        }
        HostMXBean host = null;
        try {
            host = this.newHost(hostName, attributes);
        }
        catch (IllegalArgumentException ex) {
            DomainBuilder.logger.error((Object)("Cannot add host " + hostName + ":" + ex.getMessage()));
            throw new VMMException(ex.getMessage());
        }
        if (host != null) {
            this.emitNotification("host.inventory.add", "Ajout host", host.getObjectName());
            VirtManagerAgent.getInstance().saveConfiguration();
        }
        return host;
    }

    public void deleteHost(HostMXBean host) throws VMMException {
        ObjectName hostObjectName = null;
        hostObjectName = host.getObjectName();
        int indexToRemove = -1;
        for (HostMXBean h : this.hosts) {
            if (!h.getObjectName().equals(hostObjectName)) continue;
            indexToRemove = this.hosts.indexOf(h);
        }
        if (indexToRemove == -1) {
            throw new VMMException("Cannot find host " + host.getHostName());
        }
        HostMXBean hostToRemove = this.hosts.get(indexToRemove);
        if (hostToRemove instanceof AbstractHost) {
            ((AbstractHost)hostToRemove).removeFromInventory();
            this.hosts.remove(indexToRemove);
            try {
                AgentCommon.getMBeanServer().unregisterMBean(host.getObjectName());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            this.emitNotification("host.inventory.del", "host delete", hostObjectName);
            VirtManagerAgent.getInstance().saveConfiguration();
        } else {
            this.emitNotification("host.error", "host delete error", hostObjectName);
        }
    }

    public void moveHost(HostMXBean host, ServerPoolMXBean server) throws VMMException {
        Map attributes = host.getAttributes();
        this.deleteHost(host);
        server.addHost(attributes);
    }

    public void setProvisioningPolicy(String policyId) {
        VMPlacementPolicy newPlacementPolicy = PolicyRegistry.getInstance().newPolicy(policyId);
        if (newPlacementPolicy != null) {
            this.placementPolicy = newPlacementPolicy;
            logger.info((Object)("Domain " + this.servername + ": policy set to " + policyId));
        }
    }

    public VirtualMachineMXBean provisionVM(VMConfigSpec vmSpec, Map<String, String> constraints, boolean sync) throws InsufficientResourcesException, InvalidVMConfigException, VMMException {
        if (this.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID()) == null) {
            throw new InvalidVMConfigException("Illegal VMImage UUID " + vmSpec.getVmImageUUID());
        }
        HostMXBean candidateHost = this.placementPolicy.placeVM(this, vmSpec);
        if (candidateHost == null) {
            throw new InsufficientResourcesException();
        }
        return candidateHost.createVM(vmSpec, sync);
    }

    public abstract VirtualMachineImageStoreMXBean getVMImageStore();

    public abstract void deleteImageStore();

    public List<HostMXBean> getManagedHosts() {
        return this.hosts;
    }

    public HostMXBean getLatestHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"host.inventory.add", "host.inventory.del", "serverpool.inventory.add", "serverpool.inventory.del", "log", "vm.error"}, Notification.class.getName(), "Server Pool event")};
    }
}

