/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.domain.policy;

import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.policy.VMPlacementPolicy;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;

public class FirstFitVMPlacementPolicy
implements VMPlacementPolicy {
    static Logger logger = Logger.getLogger(FirstFitVMPlacementPolicy.class);

    @Override
    public HostMXBean placeVM(ServerPoolMXBean serverPool, VMConfigSpec vmSpec) {
        List hosts = serverPool.getManagedHosts();
        for (HostMXBean host : hosts) {
            try {
                if (host.getHostState() != HostMXBean.HostPowerState.RUNNING || host.getFreeMemoryMB() <= vmSpec.getMemorySizeMB() || host.getVMImageStore().getFreeSpaceMB() <= (long)vmSpec.getDiskSizeMB()) continue;
                logger.debug((Object)("First-fit VM placement selected host " + host.getHostName()));
                return host;
            }
            catch (VMMException ex) {
                logger.error((Object)ex);
            }
        }
        return null;
    }
}

