/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.dummy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.domain.ServerPool;
import org.ow2.jasmine.vmm.agent.driver.dummy.DummyHost;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;

class DummyServerPool
extends ServerPool {
    protected static Logger logger = Logger.getLogger(DummyServerPool.class);
    private VirtualMachineImageStoreMXBean imageStore;
    private static int counter = 0;

    public DummyServerPool(String name, ObjectName objectName, Map<String, String> attributs) {
        super(name, objectName, attributs);
        ObjectName storeObjectName = MBeanObjectNamer.makeVMImageStoreName(name + "-store" + counter++);
        try {
            this.imageStore = new DummyVirtualMachineImageStore(storeObjectName);
            AgentCommon.getMBeanServer().registerMBean(this.imageStore, storeObjectName);
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot register Dummy VMImageStore", (Throwable)ex);
        }
    }

    public String getHypervisor() {
        return "DummyHypervisor";
    }

    @Override
    public HostMXBean newHost(String hostName, Map<String, String> props) throws VMMException {
        ObjectName objectName = MBeanObjectNamer.makeHostName(this.getPath() + "/" + hostName, hostName);
        DummyHost host = new DummyHost(this, hostName, objectName, true);
        try {
            AgentCommon.getMBeanServer().registerMBean(host, objectName);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to register MBean " + objectName), (Throwable)ex);
            throw new VMMException((Throwable)ex);
        }
        this.addHost(host);
        return host;
    }

    @Override
    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.imageStore;
    }

    @Override
    public void deleteImageStore() {
        try {
            for (int i = this.imageStore.listVMImageTemplates().size(); i > 0; --i) {
                AgentCommon.getMBeanServer().unregisterMBean(((VirtualMachineImageMXBean)this.imageStore.listVMImageTemplates().get(i - 1)).getObjectName());
            }
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
        logger.info((Object)"Removing Image Store");
        try {
            AgentCommon.getMBeanServer().unregisterMBean(this.imageStore.getObjectName());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        this.imageStore = null;
    }

    static class DummyVirtualMachineImageStore
    extends ManagedResource
    implements VirtualMachineImageStoreMXBean {
        private static long INIT_STORAGE_CAPACITY_MB = 131072L;
        private CopyOnWriteArrayList<DummyVirtualMachineImage> images = new CopyOnWriteArrayList();
        private long freeSpaceMB;
        private static int counter = 100;

        public DummyVirtualMachineImageStore(ObjectName objectName) throws Exception {
            super(objectName);
            this.addImage("Used by unit tests", "A dummy Image", null);
            this.addImage("Debian Lenny", "A dummy Image", null);
            this.addImage("Fedora 10", "A dummy Image", null);
            this.freeSpaceMB = INIT_STORAGE_CAPACITY_MB;
        }

        public DummyVirtualMachineImage addImage(String name, String description, Map<String, String> metaData) throws Exception {
            String uuid = "vmi-" + counter++;
            ObjectName on = MBeanObjectNamer.makeVMImageName(uuid);
            DummyVirtualMachineImage image = new DummyVirtualMachineImage(on, uuid, name, description, metaData);
            AgentCommon.getMBeanServer().registerMBean(image, on);
            this.images.add(image);
            return image;
        }

        public long getCapacityMB() {
            return INIT_STORAGE_CAPACITY_MB;
        }

        public long getFreeSpaceMB() {
            return this.freeSpaceMB;
        }

        void updateFreeSpace(long deltaMB) {
            this.freeSpaceMB += deltaMB;
        }

        public String getName() {
            return "ImageStore(default)";
        }

        public VirtualMachineImageMXBean lookUpByUUID(String uuid) {
            for (DummyVirtualMachineImage image : this.images) {
                if (!image.getUUID().equals(uuid)) continue;
                return image;
            }
            return null;
        }

        public List<VirtualMachineImageMXBean> listVMImageTemplates() {
            ArrayList<VirtualMachineImageMXBean> result = new ArrayList<VirtualMachineImageMXBean>(this.images);
            return result;
        }

        public void removeVMImageTemplate(VirtualMachineImageMXBean image) throws VMMException {
            logger.info((Object)("Removing VM image " + image.getName()));
            for (DummyVirtualMachineImage im : this.images) {
                if (!im.getUUID().equals(image.getUUID())) continue;
                this.images.remove(im);
                break;
            }
        }
    }

    private static class DummyVirtualMachineImage
    extends ManagedResource
    implements VirtualMachineImageMXBean {
        private String uuid;
        private String name;
        private String description;
        private Map<String, String> metaData;

        public DummyVirtualMachineImage(ObjectName objectName, String uuid, String name, String description, Map<String, String> metaData) {
            super(objectName);
            this.name = name;
            this.uuid = uuid;
            this.description = description;
            this.metaData = metaData;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getMetaData() {
            return this.metaData;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

