/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.hyperv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.AbstractHost;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVConnection;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVServerPool;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVVMImageStore;
import org.ow2.jasmine.vmm.agent.driver.hyperv.HyperVVirtualMachine;
import org.ow2.jasmine.vmm.agent.driver.util.ResourceUsageHelper;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

public class HyperVHost
extends AbstractHost
implements NotificationEmitter {
    static Logger logger = Logger.getLogger(HyperVHost.class);
    private static final int MAX_PARALELL_VM_CREATION_PER_HOST = 3;
    private static final int THREADPOOL_SIZE = 4;
    private static final int DEFAULT_MONITORING_PERIOD_MS = 1000;
    private static ExecutorService executorService = Executors.newFixedThreadPool(4);
    private HashMap<String, HyperVVirtualMachine> vmList = new HashMap();
    private HyperVServerPool serverPool;
    private HyperVConnection connection;
    private Timer perfTimer;
    private String hostName;
    private String vmFolderPath;
    private String vmTemplateFolderPath;
    private String disk;
    private Map<String, String> hostAttributes;
    private HostMXBean.HostPowerState hostPowerState = HostMXBean.HostPowerState.UNKNOWN;
    private int numCPU = -1;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod = 1000L;
    HashMap<String, String> hypervisorInfo;
    HashMap<String, String> cpuInfo;

    public static HyperVHost newHost(HyperVServerPool resourcePool, ObjectName objectName, String hostName, String vmFolderPath, String vmTemplateFolderPath, HypervParams hypervParams, String disk, Map<String, String> hostAttributs) {
        HyperVConnection connection = new HyperVConnection(hostName, hypervParams.getHypervUser(), hypervParams.getHypervPassword());
        HyperVHost hypervHost = new HyperVHost(resourcePool, connection, objectName, hostName, vmFolderPath, vmTemplateFolderPath, disk, hostAttributs);
        return hypervHost;
    }

    private HyperVHost(HyperVServerPool serverPool, HyperVConnection connection, ObjectName objectName, String hostName, String vmFolderPath, String vmTemplateFolderPath, String disk, Map<String, String> hostAttributes) {
        super(objectName);
        this.serverPool = serverPool;
        this.connection = connection;
        this.hostName = hostName;
        this.vmFolderPath = vmFolderPath;
        this.vmTemplateFolderPath = vmTemplateFolderPath;
        this.disk = disk;
        this.hostAttributes = new HashMap<String, String>(hostAttributes);
        this.hostPowerState = HostMXBean.HostPowerState.RUNNING;
    }

    public boolean isConnectionLost() {
        return !this.connection.isConnected();
    }

    public HyperVConnection getHypervConnection() {
        return this.connection;
    }

    public String getVMFolderpath() {
        return this.vmFolderPath;
    }

    public String getVMTemplateFolderpath() {
        return this.vmTemplateFolderPath;
    }

    private void addVM(HyperVVirtualMachine vm) {
        this.vmList.put(vm.getNameLabel(), vm);
    }

    private void removeVM(HyperVVirtualMachine vm) {
        this.vmList.remove(vm.getNameLabel());
    }

    public ServerPoolMXBean getServerPool() {
        return this.serverPool;
    }

    public void postMigrateVM(HyperVVirtualMachine vm, HyperVHost newHost) {
        throw new UnsupportedOperationException("not implemented");
    }

    synchronized void onVMCreate(HyperVVirtualMachine vm) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        AgentCommon.getMBeanServer().registerMBean(vm, vm.getObjectName());
        logger.info((Object)("Added HypervVirtualMachineMBean " + vm.getObjectName()));
        this.addVM(vm);
        this.emitNotification("vm.add", "Created", vm.getObjectName());
    }

    synchronized void onVMDestroy(HyperVVirtualMachine vm) throws InstanceNotFoundException, MBeanRegistrationException {
        this.removeVM(vm);
        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
        AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
    }

    synchronized void removeVMFromInventory(HyperVVirtualMachine vm) {
        this.removeVM(vm);
        this.emitNotification("vm.inventory.del", "Deleted", vm.getObjectName());
        try {
            AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot unregister VM MBean", (Throwable)ex);
        }
    }

    synchronized void onPowerStateChangedVM(String vmName, VirtualMachineMXBean.PowerState state, long time) {
        HyperVVirtualMachine vm = this.vmList.get(vmName);
        if (vm != null) {
            vm.onVMStateChanged(state);
        }
    }

    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 1000L) {
            periodMillis = 1000L;
        }
        if (metricsOfInterest.contains(HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            this.startPerfMonitor();
        }
    }

    private synchronized void startPerfMonitor() {
        if (this.perfTimer == null) {
            this.perfTimer = new Timer();
            this.perfTimer.schedule((TimerTask)new PerfTimerTask(), 0L, this.currentMonitoringPeriod);
            logger.info((Object)("Host " + this.hostName + ": started periodic performance reporting task"));
        }
    }

    private synchronized void stopPerfMonitor() {
        if (this.perfTimer != null) {
            this.perfTimer.cancel();
            logger.info((Object)("Host " + this.hostName + ": stopped periodic performance reporting task"));
        }
        this.perfTimer = null;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            this.hypervisorInfo.put("vendor", "Microsoft");
            this.hypervisorInfo.put("name", "Hyper-V");
        }
        return this.hypervisorInfo;
    }

    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            try {
                this.cpuInfo = this.connection.getHostCPUInfo();
                logger.debug((Object)("GetCPUInfo of host : " + this.cpuInfo));
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
            }
        }
        return this.cpuInfo;
    }

    public int getNumCPU() {
        if (this.numCPU == -1) {
            try {
                this.numCPU = this.connection.getHostNumCPU();
                logger.debug((Object)("GetNumCPU of host : " + this.numCPU));
            }
            catch (Exception ex) {
                logger.error((Object)("Failed to get NumCPU of host " + this.hostName), (Throwable)ex);
            }
        }
        return this.numCPU;
    }

    public String getHostName() {
        return this.hostName;
    }

    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.serverPool.getVMImageStore();
    }

    public long getFreeMemoryMB() {
        long freeMem = 0L;
        try {
            freeMem = this.connection.getHostFreePhysicalMemoryMB();
            logger.debug((Object)("GetFreeMemoryMB of host : " + freeMem));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get FreeMemoryMB of host " + this.hostName), (Throwable)ex);
        }
        return freeMem;
    }

    public synchronized void sync(HyperVConnection connection) throws VMMException {
        Set<HyperVConnection.VM> vmSet;
        try {
            vmSet = connection.getAllVM();
        }
        catch (Exception ex) {
            throw new VMMException(ex.getMessage());
        }
        for (HyperVConnection.VM vm : vmSet) {
            ObjectName name;
            HyperVVirtualMachine hypervVM;
            if (this.vmList.containsKey(vm.getNameLabel()) || (hypervVM = new HyperVVirtualMachine(name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vm.getNameLabel(), vm.getUuid()), this, this.connection, vm, null)) == null) continue;
            try {
                this.onVMCreate(hypervVM);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to register VM MBean", (Throwable)ex);
            }
        }
        HashMap<String, HyperVVirtualMachine> vmListTemp = new HashMap<String, HyperVVirtualMachine>(this.vmList);
        for (String nameLabel : vmListTemp.keySet()) {
            boolean match = false;
            for (HyperVConnection.VM vm : vmSet) {
                if (!nameLabel.equals(vm.getNameLabel())) continue;
                match = true;
                break;
            }
            if (match) continue;
            try {
                this.onVMDestroy(vmListTemp.get(nameLabel));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to unregister VM MBean", (Throwable)ex);
            }
        }
    }

    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> result = new ArrayList<VirtualMachineMXBean>(this.vmList.values());
        return result;
    }

    public VirtualMachineMXBean lookUpByNameLabel(String nameLabel) {
        if (this.vmList.containsKey(nameLabel)) {
            return this.vmList.get(nameLabel);
        }
        return null;
    }

    public VirtualMachineMXBean createVM(VMConfigSpec vmSpecIn, boolean sync) throws InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec = new VMConfigSpec(vmSpecIn);
        logger.info((Object)("Creating new VM [name=" + vmSpec.getName() + ",memorySizeMB=" + vmSpec.getMemorySizeMB() + ",diskSize=" + vmSpec.getDiskSizeMB() + ",numVCPU=" + vmSpec.getNumVCPU() + "]"));
        final HyperVVMImageStore.HypervVirtualMachineImage template = (HyperVVMImageStore.HypervVirtualMachineImage)this.serverPool.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID());
        if (template == null) {
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        final String vmName = vmSpec.getName() + "-" + System.currentTimeMillis();
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HyperVHost.this.copyFile(vmSpec, vmName, template);
                        HyperVHost.this.createVM2(vmSpec, vmName, template);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        this.copyFile(vmSpec, vmName, template);
        return this.createVM2(vmSpec, vmName, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean createVM2(VMConfigSpec vmSpec, String vmName, HyperVVMImageStore.HypervVirtualMachineImage template) throws InvalidVMConfigException, VMMException {
        HyperVHost hyperVHost = this;
        synchronized (hyperVHost) {
            boolean success = false;
            try {
                success = this.connection.createVM(vmName, this.getVMFolderpath().concat(vmName.concat(".vhd")).replaceAll("\\\\\\\\", "\\\\"));
            }
            catch (Exception ex) {
                logger.error((Object)"CreateVM failed: ", (Throwable)ex);
                throw new VMMException("VM creation failed: VMI connection failure", (Throwable)ex);
            }
            if (!success) {
                logger.error((Object)"Command createVM failed");
                throw new VMMException("VM creation failed");
            }
            HyperVConnection.VM newVM = null;
            try {
                Set<HyperVConnection.VM> vms = this.connection.getAllVM();
                for (HyperVConnection.VM vm : vms) {
                    if (!vm.getNameLabel().equals(vmName)) continue;
                    newVM = vm;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to get VM : ", (Throwable)ex);
                throw new VMMException("VM creation failure: Failed to get VM");
            }
            ObjectName name = null;
            HyperVVirtualMachine hypervVM = null;
            try {
                name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, newVM.getUuid());
                hypervVM = new HyperVVirtualMachine(name, this, this.connection, newVM, null);
                this.addVM(hypervVM);
                this.emitNotification("vm.add", "Created", hypervVM.getObjectName());
                AgentCommon.getMBeanServer().registerMBean(hypervVM, name);
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
                throw new VMMException((Throwable)ex);
            }
            try {
                hypervVM.setNumVCPUs(vmSpec.getNumVCPU());
                hypervVM.setMemorySizeMB(vmSpec.getMemorySizeMB());
            }
            catch (Exception ex) {
                logger.error((Object)"Failed modify VM : ", (Throwable)ex);
                throw new VMMException("VM creation failure: Failed modify VM");
            }
            return hypervVM;
        }
    }

    private void copyFile(VMConfigSpec vmSpec, String vmName, HyperVVMImageStore.HypervVirtualMachineImage template) throws VMMException {
        boolean success = false;
        try {
            success = this.connection.hostCopyFile(template.getFileName().concat(".vhd"), this.getVMFolderpath().concat(vmName.concat(".vhd")));
        }
        catch (Exception ex) {
            logger.error((Object)"CopyFile failed ", (Throwable)ex);
            throw new VMMException("VM creation failed: WMI connection failure", (Throwable)ex);
        }
        if (!success) {
            logger.error((Object)"Command copyFile failed");
            throw new VMMException("VM creation failed");
        }
    }

    public long getTotalMemoryMB() {
        long totalMem = 0L;
        try {
            totalMem = this.connection.getHostTotalMemoryMB();
            logger.debug((Object)("GetTotalMemoryMB of host : " + totalMem));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get FreeTotalMemoryMB of host " + this.hostName), (Throwable)ex);
        }
        return totalMem;
    }

    public float[] getLoadPerCPU() {
        float[] loadPerCPU = new float[]{};
        try {
            loadPerCPU = this.connection.getHostCPULoad();
            logger.debug((Object)"GetLoadPerCPU of host : ");
            for (float load : loadPerCPU) {
                logger.debug((Object)Float.valueOf(load));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get LoadPerCPU of host " + this.hostName), (Throwable)ex);
        }
        return loadPerCPU;
    }

    public float getCPULoad() {
        float cpuLoad = 0.0f;
        try {
            float[] loadPerCPU = this.connection.getHostCPULoad();
            float acc = 0.0f;
            for (float load : loadPerCPU) {
                acc += load;
            }
            cpuLoad = acc / (float)loadPerCPU.length;
            logger.debug((Object)("GetCPULoad of host : " + cpuLoad));
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get CPULoad of host " + this.hostName), (Throwable)ex);
        }
        return cpuLoad;
    }

    public Map<String, ResourceUsage> getVMResourceUsage() {
        HashMap<String, ResourceUsage> result = new HashMap<String, ResourceUsage>();
        for (HyperVVirtualMachine vm : this.vmList.values()) {
            result.put(vm.getNameLabel(), vm.getResourceUsage());
        }
        return result;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.inventory.del", "vm.del", "vm.error", "log"}, Notification.class.getName(), "Host event")};
    }

    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap();
        try {
            cpuLoads = this.connection.getVMCPULoads();
        }
        catch (Exception ex) {
            logger.error((Object)("Host " + this.hostName + ", Failed to get VMCPULoads"), (Throwable)ex);
        }
        return cpuLoads;
    }

    public Map<String, String> getAttributes() {
        return this.hostAttributes;
    }

    @Override
    public void removeFromInventory() {
        this.serverPool.stopEventCollector();
        while (this.getResidentVMs().size() > 0) {
            this.removeVMFromInventory((HyperVVirtualMachine)this.getResidentVMs().get(0));
        }
    }

    public void start() {
        this.hostPowerState = HostMXBean.HostPowerState.RUNNING;
    }

    public void stop() {
        this.hostPowerState = HostMXBean.HostPowerState.HALTED;
    }

    public HostMXBean.HostPowerState getHostState() {
        return this.hostPowerState;
    }

    private class PerfTimerTask
    extends TimerTask {
        private PerfTimerTask() {
        }

        @Override
        public void run() {
            HashMap<String, Object> notifUserData = new HashMap<String, Object>();
            for (HyperVVirtualMachine vm : HyperVHost.this.vmList.values()) {
                if (vm.getState() != VirtualMachineMXBean.PowerState.RUNNING || vm.getResourceUsage() == null) continue;
                notifUserData.put(vm.getNameLabel(), ResourceUsageHelper.serialize(vm.getResourceUsage()));
            }
            HyperVHost.this.emitNotification("host.perfreport", "Resource Usage", notifUserData);
        }
    }

    public static class HypervParams {
        private final String hypervUser;
        private final String hypervPassword;

        public HypervParams(String hypervUser, String hypervPassword) {
            this.hypervUser = hypervUser;
            this.hypervPassword = hypervPassword;
        }

        public String getHypervUser() {
            return this.hypervUser;
        }

        public String getHypervPassword() {
            return this.hypervPassword;
        }
    }
}

