/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.libvirt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.LibvirtException;
import org.libvirt.NodeInfo;
import org.ow2.jasmine.vmm.agent.domain.AbstractHost;
import org.ow2.jasmine.vmm.agent.driver.libvirt.ImageCatalog;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtPerfCollector;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtServerPool;
import org.ow2.jasmine.vmm.agent.driver.libvirt.LibvirtVirtualMachine;
import org.ow2.jasmine.vmm.agent.driver.util.RemoteExec;
import org.ow2.jasmine.vmm.agent.jmx.MBeanObjectNamer;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.InvalidVMConfigException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.ServerPoolMXBean;
import org.ow2.jasmine.vmm.api.VMConfigSpec;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageStoreMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;
import org.ow2.jasmine.vmm.api.VnicIPSettings;

public class LibvirtHost
extends AbstractHost
implements NotificationEmitter {
    static Logger logger = Logger.getLogger(LibvirtHost.class);
    private static final int MAX_PARALEL_VM_CREATION_PER_HOST = 3;
    private static final int THREADPOOL_SIZE = 3;
    private static ExecutorService executorService = Executors.newFixedThreadPool(3);
    private String uri;
    private List<LibvirtVirtualMachine> vmList = new CopyOnWriteArrayList<LibvirtVirtualMachine>();
    LibvirtServerPool serverPool;
    private LibvirtPerfCollector perfCollectionTask;
    private String hostName;
    private HostMXBean.HostPowerState hostPowerState = HostMXBean.HostPowerState.HALTED;
    private Connect connection;
    private int numCPU = -1;
    private long cpuFrequencyMhz = -1L;
    private Map<String, String> hostAttributes;
    private RemoteExec.SshAuthInfo authInfo;
    private HostSynchronizer hostSynchronizer;
    private Set<HostMXBean.PerfMetric> currentMonitoredMetrics;
    private long currentMonitoringPeriod;
    private HashMap<String, String> hypervisorInfo;
    private HashMap<String, String> cpuInfo;

    public static LibvirtHost newHost(LibvirtServerPool serverPool, ObjectName objectName, String hostName, String uri, RemoteExec.SshAuthInfo authInfo, Map<String, String> hostAttributes, Boolean isNotStop) {
        try {
            return new LibvirtHost(serverPool, uri, objectName, hostName, authInfo, hostAttributes, isNotStop);
        }
        catch (LibvirtException ex) {
            logger.error((Object)("Failed to establish libvirt connection with uri " + uri), (Throwable)ex);
            return null;
        }
    }

    private LibvirtHost(LibvirtServerPool serverPool, String uri, ObjectName objectName, String hostName, RemoteExec.SshAuthInfo authInfo, Map<String, String> hostAttributes, Boolean isNotStop) throws LibvirtException {
        super(objectName);
        this.uri = uri;
        this.serverPool = serverPool;
        logger.debug((Object)("Connecting to URI " + this.uri));
        if (isNotStop.booleanValue()) {
            try {
                this.connection = this.getLibvirtAPIConnection();
                this.hostPowerState = HostMXBean.HostPowerState.RUNNING;
            }
            catch (LibvirtException ex) {
                logger.warn((Object)("Host " + hostName + " not responding"));
                this.hostPowerState = HostMXBean.HostPowerState.NOT_RESPONDING;
            }
        }
        this.hostName = hostName;
        this.authInfo = authInfo;
        this.hostAttributes = new HashMap<String, String>(hostAttributes);
        this.hostSynchronizer = new HostSynchronizer(serverPool.getSyncPeriodMillis());
        if (this.hostPowerState == HostMXBean.HostPowerState.RUNNING || this.hostPowerState == HostMXBean.HostPowerState.NOT_RESPONDING) {
            this.hostSynchronizer.start();
        }
        if (this.hostPowerState == HostMXBean.HostPowerState.RUNNING) {
            this.startPerfMonitor();
        }
    }

    public boolean isConnectionLost() {
        return this.hostPowerState == HostMXBean.HostPowerState.NOT_RESPONDING;
    }

    public RemoteExec.SshAuthInfo getSshAuthInfo() {
        return this.authInfo;
    }

    Connect getLibvirtAPIConnection() throws LibvirtException {
        if (this.connection == null) {
            this.connection = new Connect(this.uri);
        }
        return this.connection;
    }

    List<LibvirtVirtualMachine> getVMs() {
        return this.vmList;
    }

    LibvirtVirtualMachine lookUpVMByName(String name) {
        for (LibvirtVirtualMachine vm : this.vmList) {
            if (!vm.getNameLabel().equals(name)) continue;
            return vm;
        }
        return null;
    }

    LibvirtVirtualMachine lookUpVMByUUID(String uuid) {
        for (LibvirtVirtualMachine vm : this.vmList) {
            if (!vm.getUuid().equals(uuid)) continue;
            return vm;
        }
        return null;
    }

    private void addVM(LibvirtVirtualMachine vm) {
        this.vmList.add(vm);
    }

    private boolean removeVM(LibvirtVirtualMachine vm) {
        return this.vmList.remove(vm);
    }

    public ServerPoolMXBean getServerPool() {
        return this.serverPool;
    }

    public void postMigrateVM(LibvirtVirtualMachine vm, LibvirtHost newHost) {
        this.removeVM(vm);
        newHost.addVM(vm);
    }

    public void removeVMFromInventory(LibvirtVirtualMachine vm) {
        try {
            AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot unregister VM MBean", (Throwable)ex);
        }
        if (this.removeVM(vm)) {
            this.emitNotification("vm.inventory.del", "Deleted", vm.getObjectName());
            logger.info((Object)("deleted VM " + vm.getObjectName()));
        }
    }

    public void configurePerfMonitor(Set<HostMXBean.PerfMetric> metricsOfInterest, long periodMillis) {
        this.stopPerfMonitor();
        if (periodMillis < 1000L) {
            periodMillis = 1000L;
        }
        if (metricsOfInterest.contains(HostMXBean.PerfMetric.VM_CPU_LOAD)) {
            this.currentMonitoringPeriod = periodMillis;
            this.currentMonitoredMetrics = metricsOfInterest;
            try {
                this.startPerfMonitor();
            }
            catch (LibvirtException e) {
                logger.error((Object)"Failed to start perfmonitor", (Throwable)e);
            }
        }
    }

    String getIPAddress(String macAddress) throws Exception {
        macAddress = macAddress.toUpperCase();
        logger.debug((Object)("Determining IP address from MAC address " + macAddress + " ..."));
        RemoteExec.Result result = null;
        String command = "getIPfromMAC.sh " + macAddress;
        logger.debug((Object)("Launching command: " + command));
        try {
            result = RemoteExec.commandAsRoot(this.hostName, this.authInfo, command);
        }
        catch (RemoteExec.SshException ex) {
            logger.debug((Object)"SSH failure", (Throwable)ex);
            throw new Exception(ex);
        }
        if (result.exitCode != 0) {
            logger.error((Object)("Cannot get IP from MAC " + result.output));
            throw new Exception(result.error);
        }
        String ipAddress = result.output;
        if (ipAddress != null && ipAddress.length() > 0 && ipAddress.endsWith("\n")) {
            ipAddress = ipAddress.substring(0, ipAddress.length() - 1);
        }
        logger.debug((Object)("Mac-to-IP " + macAddress + " -> " + ipAddress));
        return ipAddress;
    }

    private synchronized void startPerfMonitor() throws LibvirtException {
        if (this.perfCollectionTask == null) {
            this.perfCollectionTask = new LibvirtPerfCollector(this);
            this.perfCollectionTask.start();
        }
    }

    private synchronized void stopPerfMonitor() {
        if (this.perfCollectionTask != null) {
            this.perfCollectionTask.stop();
            this.perfCollectionTask = null;
        }
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getHypervisorInfo() {
        if (this.hypervisorInfo == null) {
            this.hypervisorInfo = new HashMap();
            try {
                this.hypervisorInfo.put("name", this.connection.getType());
                long v = this.connection.getVersion();
                long major = v / 1000000L;
                long minor = (v - major * 1000000L) / 1000L;
                this.hypervisorInfo.put("version", "" + major + "." + minor);
            }
            catch (LibvirtException ex) {
                logger.error((Object)"Failed to get hypervisor info", (Throwable)ex);
            }
        }
        return this.hypervisorInfo;
    }

    public Map<String, String> getCPUInfo() {
        if (this.cpuInfo == null) {
            NodeInfo nodeInfo;
            this.cpuInfo = new HashMap();
            try {
                nodeInfo = this.connection.nodeInfo();
            }
            catch (LibvirtException e) {
                e.printStackTrace();
                return this.cpuInfo;
            }
            this.cpuInfo.put("model", new String(nodeInfo.model));
            this.cpuInfo.put("speedMHz", Integer.toString(nodeInfo.mhz));
            this.numCPU = nodeInfo.cpus;
        }
        return this.cpuInfo;
    }

    public int getNumCPU() {
        if (this.numCPU == -1) {
            this.getCPUInfo();
        }
        return this.numCPU;
    }

    public String getHostName() {
        return this.hostName;
    }

    public VirtualMachineImageStoreMXBean getVMImageStore() {
        return this.serverPool.getVMImageStore();
    }

    public long getFreeMemoryMB() {
        try {
            if (this.serverPool.getHypervisor().equals("xen")) {
                return this.getLibvirtFreeMemoryMB();
            }
            if (this.serverPool.getHypervisor().equals("kvm")) {
                return this.getLinuxHostFreeMemoryMB();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"getFreeMemoryMB", (Throwable)ex);
        }
        return -1L;
    }

    private long getLibvirtFreeMemoryMB() throws Exception {
        long freeMemKB = -1L;
        freeMemKB = this.connection.getFreeMemory();
        return freeMemKB / 0x100000L;
    }

    private long getLinuxHostFreeMemoryMB() throws Exception {
        String command = "free -m | sed '3!d' | awk '{print $4}'";
        RemoteExec.Result result = RemoteExec.commandAsRoot(this.hostName, this.authInfo, command);
        if (result.output.endsWith("\n")) {
            result.output = result.output.substring(0, result.output.length() - 1);
        }
        long osFreeMemMB = Long.parseLong(result.output);
        long vmTotalMemoryMB = 0L;
        for (LibvirtVirtualMachine vm : this.vmList) {
            vmTotalMemoryMB += vm.getMemorySizeMB();
        }
        long vmFreeMemMB = this.getTotalMemoryMB() - vmTotalMemoryMB;
        return Math.min(osFreeMemMB, vmFreeMemMB);
    }

    public void sync() {
        this.hostSynchronizer.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean doSync(Connect connection) {
        try {
            int[] domIDs;
            String[] vmNames;
            for (String vmName : vmNames = connection.listDefinedDomains()) {
                Domain domain;
                try {
                    domain = connection.domainLookupByName(vmName);
                }
                catch (LibvirtException ex) {
                    continue;
                }
                String uuid = domain.getUUIDString();
                ObjectName name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, uuid);
                LibvirtVirtualMachine vm = this.lookUpVMByName(vmName);
                if (AgentCommon.getMBeanServer().isRegistered(name)) {
                    if (vm == null) continue;
                    vm.setSynchronized(true);
                    continue;
                }
                if (vm != null) continue;
                vm = new LibvirtVirtualMachine(name, this, domain, null);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
                this.emitNotification("vm.add", "Created", name);
            }
            for (int domID : domIDs = connection.listDomains()) {
                Domain domain;
                try {
                    domain = connection.domainLookupByID(domID);
                }
                catch (LibvirtException ex) {
                    continue;
                }
                String uuid = domain.getUUIDString();
                String vmName = domain.getName();
                if (vmName.equals("Domain-0")) continue;
                ObjectName name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, uuid);
                LibvirtVirtualMachine vm = this.lookUpVMByName(vmName);
                if (AgentCommon.getMBeanServer().isRegistered(name)) {
                    if (vm == null) continue;
                    vm.setSynchronized(true);
                    continue;
                }
                if (vm != null) continue;
                vm = new LibvirtVirtualMachine(name, this, domain, null);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
                this.emitNotification("vm.add", "Created", name);
            }
            for (LibvirtVirtualMachine vm : this.vmList) {
                try {
                    if (vm.isMigrating()) continue;
                    if (!vm.isSynchronized()) {
                        if (!this.removeVM(vm)) continue;
                        this.emitNotification("vm.del", "Destroyed", vm.getObjectName());
                        AgentCommon.getMBeanServer().unregisterMBean(vm.getObjectName());
                        continue;
                    }
                    try {
                        vm.getState();
                    }
                    catch (VMMException ignore) {
                        // empty catch block
                    }
                }
                finally {
                    vm.setSynchronized(false);
                }
            }
        }
        catch (LibvirtException ex) {
            return false;
        }
        catch (Exception ex) {
            logger.error((Object)"error while syncing", (Throwable)ex);
        }
        return true;
    }

    public List<VirtualMachineMXBean> getResidentVMs() {
        ArrayList<VirtualMachineMXBean> result = new ArrayList<VirtualMachineMXBean>(this.vmList);
        return result;
    }

    public VirtualMachineMXBean createVM(VMConfigSpec vmSpecIn, boolean sync) throws InvalidVMConfigException, VMMException {
        final VMConfigSpec vmSpec = new VMConfigSpec(vmSpecIn);
        logger.info((Object)("Creating new VM [name=" + vmSpec.getName() + ",memorySizeMB=" + vmSpec.getMemorySizeMB() + ",diskSize=" + vmSpec.getDiskSizeMB() + ",numVCPU=" + vmSpec.getNumVCPU() + "]"));
        final ImageCatalog.VirtualMachineImage template = (ImageCatalog.VirtualMachineImage)this.serverPool.getVMImageStore().lookUpByUUID(vmSpec.getVmImageUUID());
        if (template == null) {
            throw new InvalidVMConfigException("Invalid VM Image UUID");
        }
        final String vmName = vmSpec.getName();
        if (!sync) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LibvirtHost.this.createVM2(vmSpec, vmName, template);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
        return this.createVM2(vmSpec, vmName, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualMachineMXBean createVM2(VMConfigSpec vmSpec, String vmName, ImageCatalog.VirtualMachineImage template) throws InvalidVMConfigException, VMMException {
        template.newVM(vmSpec, vmName, this);
        LibvirtHost libvirtHost = this;
        synchronized (libvirtHost) {
            String vmUUID = null;
            ObjectName name = null;
            LibvirtVirtualMachine vm = null;
            Domain domain = null;
            try {
                domain = this.connection.domainLookupByName(vmName);
                vmUUID = domain.getUUIDString();
                vm = this.lookUpVMByUUID(vmUUID);
                if (vm != null) {
                    return vm;
                }
                name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + vmName, vmUUID);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("imageID", vmSpec.getVmImageUUID());
                domain = this.connection.domainLookupByName(vmName);
                vm = new LibvirtVirtualMachine(name, this, domain, map);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
                throw new VMMException((Throwable)ex);
            }
            this.emitNotification("vm.add", "Created", name);
            return vm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachineMXBean cloneVM(String targetVmName, String clonedVmName, VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException, VMMException {
        RemoteExec.Result result;
        String command = "cloneVM --src " + clonedVmName + " --name " + targetVmName + " --force ";
        if (custSpec != null) {
            if (custSpec.getGuestOsHostName() != null && !custSpec.getGuestOsHostName().equals("")) {
                command = command + " --hostname " + custSpec.getGuestOsHostName();
            }
            if (custSpec.getVnicIpSettingsList() != null && custSpec.getVnicIpSettingsList().size() > 0) {
                VnicIPSettings nic0Settings = (VnicIPSettings)custSpec.getVnicIpSettingsList().get(0);
                if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.DHCP) {
                    command = command + " --net eth0/dhcp";
                } else if (nic0Settings.getIpAssignmentMode() == VnicIPSettings.IpAssignmentMode.FIXED) {
                    command = command + " --net eth0/static/" + nic0Settings.getIpAddress() + "/" + nic0Settings.getSubnetMask() + "/" + nic0Settings.getGateway();
                }
            }
        }
        try {
            result = RemoteExec.commandAsRoot(this.getHostName(), this.getSshAuthInfo(), command);
        }
        catch (RemoteExec.SshException ex) {
            throw new VMMException("VM cloning failed: SSH connection failure", (Throwable)ex);
        }
        if (result.exitCode != 0) {
            throw new VMMException("VM cloning failed: " + result.error);
        }
        Domain newVM = null;
        String vmUUID = "";
        try {
            newVM = this.connection.domainLookupByName(clonedVmName);
            vmUUID = newVM.getUUIDString();
        }
        catch (LibvirtException ex) {
            logger.error((Object)("Failed to look up VM " + clonedVmName));
            throw new VMMException("VM cloning failure");
        }
        LibvirtHost libvirtHost = this;
        synchronized (libvirtHost) {
            ObjectName name = null;
            LibvirtVirtualMachine vm = null;
            vm = this.lookUpVMByUUID(vmUUID);
            if (vm != null) {
                return vm;
            }
            try {
                name = MBeanObjectNamer.makeVirtualMachineName(this.serverPool.getPath() + "/" + clonedVmName, vmUUID);
                HashMap<String, String> map = new HashMap<String, String>();
                vm = new LibvirtVirtualMachine(name, this, newVM, map);
                this.addVM(vm);
                AgentCommon.getMBeanServer().registerMBean(vm, name);
            }
            catch (Exception ex) {
                logger.debug((Object)("Host " + this.hostName), (Throwable)ex);
                throw new VMMException((Throwable)ex);
            }
            this.emitNotification("vm.add", "Created", name);
            return vm;
        }
    }

    public long getTotalMemoryMB() {
        NodeInfo nodeInfo;
        try {
            nodeInfo = this.connection.nodeInfo();
        }
        catch (LibvirtException e) {
            e.printStackTrace();
            return -1L;
        }
        return nodeInfo.memory / 1024L;
    }

    public float[] getLoadPerCPU() {
        float[] result = new float[]{};
        return result;
    }

    public float getCPULoad() {
        float aggregatedCPULoad = 0.0f;
        for (LibvirtVirtualMachine vm : this.vmList) {
            aggregatedCPULoad += vm.getResourceUsage().getCpuLoad();
        }
        return aggregatedCPULoad;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"vm.state", "vm.add", "vm.inventory.del", "vm.del", "vm.error", "log"}, Notification.class.getName(), "Host event")};
    }

    public Map<String, ResourceUsage> getVMResourceUsage() {
        HashMap<String, ResourceUsage> result = new HashMap<String, ResourceUsage>();
        for (LibvirtVirtualMachine vm : this.vmList) {
            result.put(vm.getNameLabel(), vm.getResourceUsage());
        }
        return result;
    }

    public Map<String, Float> getVMCPULoads() {
        HashMap<String, Float> cpuLoads = new HashMap<String, Float>();
        for (LibvirtVirtualMachine vm : this.vmList) {
            cpuLoads.put(vm.getNameLabel(), Float.valueOf(vm.getResourceUsage().getCpuLoad()));
        }
        return cpuLoads;
    }

    public Map<String, String> getAttributes() {
        return this.hostAttributes;
    }

    @Override
    public void removeFromInventory() {
        this.stopPerfMonitor();
        this.hostSynchronizer.requestStop();
        while (this.getResidentVMs().size() > 0) {
            this.removeVMFromInventory((LibvirtVirtualMachine)this.getResidentVMs().get(0));
        }
    }

    private void setHostStatusFromRunningToNonResponding() {
        this.stopPerfMonitor();
        while (this.getResidentVMs().size() > 0) {
            this.removeVMFromInventory((LibvirtVirtualMachine)this.getResidentVMs().get(0));
        }
        this.hostPowerState = HostMXBean.HostPowerState.NOT_RESPONDING;
        this.connection = null;
        logger.warn((Object)("Host " + this.hostName + " not responding"));
        this.emitNotification("host.state", this.hostPowerState.toString(), null);
    }

    private void setHostStatusFromNonRespondingToRunning() {
        try {
            this.startPerfMonitor();
        }
        catch (LibvirtException ex) {
            logger.error((Object)ex);
        }
        this.hostPowerState = HostMXBean.HostPowerState.RUNNING;
        this.emitNotification("host.state", this.hostPowerState.toString(), null);
    }

    public void start() {
        try {
            this.connection = this.getLibvirtAPIConnection();
            this.hostSynchronizer.start();
            this.startPerfMonitor();
        }
        catch (LibvirtException e) {
            e.printStackTrace();
        }
        this.hostPowerState = HostMXBean.HostPowerState.RUNNING;
        this.emitNotification("host.state", this.hostPowerState.toString(), null);
    }

    public void stop() {
        this.stopPerfMonitor();
        this.hostSynchronizer.requestStop();
        while (this.getResidentVMs().size() > 0) {
            try {
                while (this.getResidentVMs().get(0).getState() == VirtualMachineMXBean.PowerState.RUNNING) {
                    this.getResidentVMs().get(0).shutdown();
                }
                this.removeVMFromInventory((LibvirtVirtualMachine)this.getResidentVMs().get(0));
            }
            catch (BadVMPowerStateException e) {
                e.printStackTrace();
            }
            catch (VMMException e) {
                e.printStackTrace();
            }
        }
        this.hostPowerState = HostMXBean.HostPowerState.HALTED;
        this.emitNotification("host.state", this.hostPowerState.toString(), null);
    }

    public HostMXBean.HostPowerState getHostState() throws VMMException {
        return this.hostPowerState;
    }

    private class HostSynchronizer
    implements Runnable {
        private long periodMillis;
        private volatile boolean stopRequested;
        private Thread thread;
        private Connect connection;

        HostSynchronizer(long periodMillis) {
            this.periodMillis = periodMillis;
        }

        public void requestStop() {
            this.stopRequested = true;
        }

        void start() {
            this.thread = new Thread(this);
            this.stopRequested = false;
            this.thread.start();
        }

        synchronized void sync() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopRequested) {
                block11: {
                    try {
                        this.connection = LibvirtHost.this.getLibvirtAPIConnection();
                        if (LibvirtHost.this.hostPowerState == HostMXBean.HostPowerState.NOT_RESPONDING) {
                            LibvirtHost.this.setHostStatusFromNonRespondingToRunning();
                        } else if (!LibvirtHost.this.doSync(this.connection)) {
                            LibvirtHost.this.setHostStatusFromRunningToNonResponding();
                            this.connection = null;
                        }
                    }
                    catch (LibvirtException ex) {
                        if (LibvirtHost.this.hostPowerState != HostMXBean.HostPowerState.RUNNING) break block11;
                        LibvirtHost.this.setHostStatusFromRunningToNonResponding();
                        this.connection = null;
                    }
                }
                HostSynchronizer hostSynchronizer = this;
                synchronized (hostSynchronizer) {
                    try {
                        this.wait(this.periodMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

