/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.driver.vmware;

import com.vmware.vim.ArrayOfInt;
import com.vmware.vim.DynamicProperty;
import com.vmware.vim.InvalidPowerState;
import com.vmware.vim.ManagedObjectReference;
import com.vmware.vim.ObjectContent;
import com.vmware.vim.VirtualDevice;
import com.vmware.vim.VirtualEthernetCard;
import com.vmware.vim.VirtualHardware;
import com.vmware.vim.VirtualMachineCloneSpec;
import com.vmware.vim.VirtualMachineMovePriority;
import com.vmware.vim.VirtualMachinePowerState;
import com.vmware.vim.VirtualMachineRelocateSpec;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.domain.ManagedResource;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareHost;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServerPool;
import org.ow2.jasmine.vmm.agent.driver.vmware.VMwareServiceConnection;
import org.ow2.jasmine.vmm.agent.main.AgentCommon;
import org.ow2.jasmine.vmm.api.BadVMPowerStateException;
import org.ow2.jasmine.vmm.api.HostMXBean;
import org.ow2.jasmine.vmm.api.IllegalOperationException;
import org.ow2.jasmine.vmm.api.InsufficientResourcesException;
import org.ow2.jasmine.vmm.api.ResourceUsage;
import org.ow2.jasmine.vmm.api.VMCustomizationSpec;
import org.ow2.jasmine.vmm.api.VMMException;
import org.ow2.jasmine.vmm.api.VirtualMachineImageMXBean;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

class VMwareVirtualMachine
extends ManagedResource
implements VirtualMachineMXBean {
    static Logger logger = Logger.getLogger(VMwareVirtualMachine.class);
    private VMwareServerPool pool;
    private VMwareHost host;
    private ManagedObjectReference ref;
    private String nameLabel;
    private String uuid;
    private String macAddress;
    private String ipAddress;
    HashMap<String, BigInteger> metricValues = null;
    private VirtualMachineMXBean.PowerState lastState = VirtualMachineMXBean.PowerState.UNKNOWN;

    public VMwareVirtualMachine(ObjectName objectName, VMwareServerPool pool, ManagedObjectReference mor, VMwareHost host, String nameLabel) {
        super(objectName);
        this.pool = pool;
        this.ref = mor;
        this.host = host;
        this.uuid = null;
        this.nameLabel = nameLabel;
    }

    public ResourceUsage getResourceUsage() {
        ResourceUsage ru = new ResourceUsage();
        ru.setSamplingTime(new Date(System.currentTimeMillis()));
        ru.setCpuLoad(this.getCPULoad());
        ru.setMemoryUsedKBytes(this.getMemoryUsedMB() * 1024L);
        return ru;
    }

    public void updateMetrics(HashMap<String, BigInteger> m) {
        this.metricValues = m;
    }

    public boolean canLiveMigrateToHost(HostMXBean targetHost) {
        return false;
    }

    public ManagedObjectReference getRef() {
        return this.ref;
    }

    public void migrate(HostMXBean targetHost, boolean live) throws IllegalOperationException, VMMException {
        String targetHostName = targetHost.getHostName();
        logger.info((Object)("Attempting live migration of VM " + this.nameLabel + " to host " + targetHostName));
        boolean foundHostInServerPool = false;
        for (HostMXBean h : this.host.getServerPool().getManagedHosts()) {
            if (!h.getHostName().equals(targetHost.getHostName())) continue;
            foundHostInServerPool = true;
            targetHost = h;
            break;
        }
        if (!foundHostInServerPool) {
            throw new IllegalOperationException("Source and target hosts belong to different server pools");
        }
        VMwareHost targetVMwareHost = (VMwareHost)targetHost;
        logger.info((Object)("VM " + this.nameLabel + " live migration to host " + targetHostName + "..."));
        this.emitNotification("vm.migration.start", targetHostName, null);
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            ManagedObjectReference taskmor = connection.getService().migrateVM_Task(this.ref, null, targetVMwareHost.getMOR(), VirtualMachineMovePriority.defaultPriority, null);
            boolean result = this.getTaskInfo(connection, taskmor);
            if (result) {
                logger.debug((Object)("Virtual Machine " + this.nameLabel + " migrated with successfuly"));
            }
            logger.info((Object)("VM " + this.nameLabel + " live migration done"));
            this.host.postMigrateVM(this, targetVMwareHost);
            this.host = targetVMwareHost;
            this.emitNotification("vm.migration", targetHostName, this.uuid);
        }
        catch (Exception ex) {
            logger.error((Object)"Error migrating VM", (Throwable)ex);
            throw new VMMException("Migration failure", (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    public float[] getLoadPerVCPU() {
        throw new UnsupportedOperationException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUuid() {
        if (this.uuid == null) {
            VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
            try {
                this.uuid = VMwareVirtualMachine.getUuid(connection, this.ref);
            }
            finally {
                connection.release();
            }
        }
        return this.uuid;
    }

    public static String getUuid(VMwareServiceConnection connection, ManagedObjectReference ref) {
        String uuid = "";
        try {
            DynamicProperty[] props = VMwareVirtualMachine.getDynamicProarray(connection, ref, "config.uuid");
            if (props == null || props.length < 1) {
                logger.error((Object)"Cannot retrieve UUID of VM ");
                uuid = "-1";
            } else {
                uuid = (String)props[0].getVal();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getUUID()] : ", (Throwable)ex);
        }
        return uuid;
    }

    public Date getStartTime() {
        logger.error((Object)"[VMWareVirtualMachine.getStartTime()] : Not Implemented ! ");
        return null;
    }

    public HostMXBean getHostMBean() {
        return this.host;
    }

    public String getNameLabel() {
        return this.nameLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMacAddress() {
        if (this.macAddress == null) {
            VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
            try {
                VirtualHardware hw = (VirtualHardware)VMwareVirtualMachine.getDynamicProarray(connection, this.ref, "config.hardware")[0].getVal();
                for (VirtualDevice vd : hw.getDevice()) {
                    if (!(vd instanceof VirtualEthernetCard)) continue;
                    this.macAddress = ((VirtualEthernetCard)vd).getMacAddress();
                    break;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[VMWareVirtualMachine.getMacAddress()] : ", (Throwable)ex);
            }
            finally {
                connection.release();
            }
        }
        return this.macAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGuestIpAddress() {
        int tryNumber = 24;
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            while (tryNumber-- > 0) {
                logger.debug((Object)("Retrieving IP address of VM " + this.nameLabel + " ..."));
                DynamicProperty[] props = VMwareVirtualMachine.getDynamicProarray(connection, this.ref, "guest.ipAddress");
                if (props != null && props.length > 0) {
                    this.ipAddress = (String)props[0].getVal();
                    logger.debug((Object)("IP address of VM " + this.nameLabel + " is " + this.ipAddress));
                    break;
                }
                Thread.sleep(10000L);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getGuestIpAddress()] : ", (Throwable)ex);
        }
        finally {
            connection.release();
        }
        return this.ipAddress;
    }

    public float getCPULoad() {
        if (this.metricValues != null && this.metricValues.get("cpu.usage") != null) {
            return this.metricValues.get("cpu.usage").floatValue() / 10000.0f;
        }
        return 0.0f;
    }

    public long getUpTimeSeconds() {
        if (this.metricValues != null && this.metricValues.get("sys.uptime") != null) {
            return this.metricValues.get("sys.uptime").longValue();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMemorySizeMB() {
        long result = 0L;
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            result = ((Integer)VMwareVirtualMachine.getDynamicProarray(connection, this.ref, "config.hardware.memoryMB")[0].getVal()).intValue();
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getMemorySizeMB()] : ", (Throwable)ex);
        }
        finally {
            connection.release();
        }
        return result;
    }

    public void setMemorySizeMB(long size) {
        logger.error((Object)"[VMWareVirtualMachine.setMemorySizeMB(...)] : Not Implemented ! ");
    }

    public long getMemoryUsedMB() {
        if (this.metricValues != null) {
            return this.metricValues.get("mem.consumed").longValue() / 1024L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumVCPUs() {
        int result = 0;
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            result = (Integer)VMwareVirtualMachine.getDynamicProarray(connection, this.ref, "config.hardware.numCPU")[0].getVal();
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getNumVCPUs()] : ", (Throwable)ex);
        }
        finally {
            connection.release();
        }
        return result;
    }

    public void setNumVCPUs(int numVCPUs) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[][] getCPUAffinity() {
        int numVCPUs = this.getNumVCPUs();
        int numPCPUs = this.host.getNumCPU();
        boolean[][] result = new boolean[numVCPUs][];
        for (int i = 0; i < numVCPUs; ++i) {
            result[i] = new boolean[numPCPUs];
        }
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            int[] affinity = null;
            DynamicProperty[] props = VMwareVirtualMachine.getDynamicProarray(connection, this.ref, "config.cpuAffinity.affinitySet");
            if (props != null && props.length > 0) {
                affinity = ((ArrayOfInt)props[0].getVal()).get_int();
            }
            if (affinity == null || affinity.length == 0) {
                for (int i = 0; i < numVCPUs; ++i) {
                    for (int j = 0; j < numPCPUs; ++j) {
                        result[i][j] = true;
                    }
                }
            } else {
                for (int i = 0; i < numVCPUs; ++i) {
                    for (int j = 0; j < affinity.length; ++j) {
                        result[i][affinity[j]] = true;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[VMWareVirtualMachine.getCPUAffinity()] : ", (Throwable)ex);
        }
        finally {
            connection.release();
        }
        return result;
    }

    public void setCPUAffinity(boolean[][] affinity) {
    }

    public int getSchedulingCap() {
        int result = 0;
        logger.error((Object)"[VMWareVirtualMachine.getSchedulingCap()] : Not Implemented ! ");
        return result;
    }

    public void setSchedulingCap(int schedulingCap) {
        logger.error((Object)"[VMWareVirtualMachine.setSchedulingCap(...)] : Not Implemented ! ");
    }

    public int getSchedulingWeight() {
        int result = 0;
        logger.error((Object)"[VMWareVirtualMachine.getSchedulingWeight()] : Not Implemented ! ");
        return result;
    }

    public void setSchedulingWeight(int schedulingWeight) {
        logger.error((Object)"[VMWareVirtualMachine.setSchedulingWeight(...)] : Not Implemented ! ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachineMXBean.PowerState getState() {
        block12: {
            VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
            try {
                DynamicProperty[] props = VMwareVirtualMachine.getDynamicProarray(connection, this.ref, "runtime.powerState");
                if (props != null) {
                    VirtualMachinePowerState state = (VirtualMachinePowerState)props[0].getVal();
                    if (state.getValue().equals("poweredOff")) {
                        VirtualMachineMXBean.PowerState powerState = VirtualMachineMXBean.PowerState.HALTED;
                        return powerState;
                    }
                    if (state.getValue().equals("poweredOn")) {
                        VirtualMachineMXBean.PowerState powerState = VirtualMachineMXBean.PowerState.RUNNING;
                        return powerState;
                    }
                    if (state.getValue().equals("suspended")) {
                        VirtualMachineMXBean.PowerState powerState = VirtualMachineMXBean.PowerState.SUSPENDED;
                        return powerState;
                    }
                    break block12;
                }
                VirtualMachineMXBean.PowerState powerState = VirtualMachineMXBean.PowerState.UNKNOWN;
                return powerState;
            }
            catch (Exception ex) {
                logger.error((Object)("[VMWareVirtualMachine.getState()]: VM " + this.getNameLabel()), (Throwable)ex);
            }
            finally {
                connection.release();
            }
        }
        return VirtualMachineMXBean.PowerState.UNKNOWN;
    }

    void onPowerStateChangedVM(VirtualMachineMXBean.PowerState state, long time) {
        if (state != this.lastState) {
            this.emitNotification("vm.state", state.toString(), null);
            logger.debug((Object)("VM " + this.getNameLabel() + " new power state: " + state.toString()));
            this.lastState = state;
        }
    }

    public String getUserData(String key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String getConsole() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void addUserData(String key, String value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            ManagedObjectReference taskmor = connection.getService().suspendVM_Task(this.ref);
            boolean result = this.getTaskInfo(connection, taskmor);
            if (result) {
                logger.debug((Object)("Virtual Machine " + this.nameLabel + " suspended on successfully"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error suspending VM", (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    public void resume() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            ManagedObjectReference taskmor = connection.getService().powerOffVM_Task(this.ref);
            boolean result = this.getTaskInfo(connection, taskmor);
            if (result) {
                logger.debug((Object)("Virtual Machine " + this.nameLabel + " powered off successfuly"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error shutting down VM", (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            ManagedObjectReference taskmor = connection.getService().powerOnVM_Task(this.ref, null);
            boolean result = this.getTaskInfo(connection, taskmor);
            if (result) {
                logger.debug((Object)("Virtual Machine " + this.nameLabel + " powered on successfully"));
            }
        }
        catch (InvalidPowerState e) {
            logger.debug((Object)"Virtual Machine is already powered on");
        }
        catch (Exception ex) {
            logger.error((Object)"Error starting VM", (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    public void pause() {
        throw new UnsupportedOperationException();
    }

    public void unpause() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot() {
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            connection.getService().resetVM_Task(this.ref);
        }
        catch (Exception ex) {
            logger.error((Object)"Error rebooting VM", (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.getState() == VirtualMachineMXBean.PowerState.RUNNING) {
            this.shutdown();
        }
        VMwareServiceConnection connection = this.pool.getConnectionPool().getConnection();
        try {
            ManagedObjectReference taskmor = connection.getService().destroy_Task(this.ref);
            boolean result = this.getTaskInfo(connection, taskmor);
            if (result) {
                logger.debug((Object)("Virtual Machine " + this.nameLabel + " destroyed successfully"));
            }
            this.host.onVMDestroy(this);
            AgentCommon.getMBeanServer().unregisterMBean(this.objectName);
        }
        catch (InvalidPowerState e) {
            logger.debug((Object)"Invalid power state");
        }
        catch (Exception ex) {
            logger.error((Object)"Error destroying VM", (Throwable)ex);
        }
        finally {
            connection.release();
        }
    }

    private static DynamicProperty[] getDynamicProarray(VMwareServiceConnection connection, ManagedObjectReference MOR, String pName) throws Exception {
        ObjectContent[] objContent = connection.getObjectProperties(null, MOR, new String[]{pName});
        if (objContent != null) {
            ObjectContent contentObj = objContent[0];
            DynamicProperty[] objArr = contentObj.getPropSet();
            return objArr;
        }
        return null;
    }

    private boolean getTaskInfo(VMwareServiceConnection connection, ManagedObjectReference taskmor) throws Exception {
        boolean valid = false;
        String res = connection.waitForTask(taskmor);
        valid = res.equalsIgnoreCase("success");
        return valid;
    }

    public VirtualMachineMXBean cloneVM(String name, VMCustomizationSpec custSpec, boolean sync) throws InsufficientResourcesException {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachineImageMXBean makeTemplate(String name, String description, Map<String, String> metadata) throws InsufficientResourcesException, IllegalOperationException, BadVMPowerStateException, VMMException {
        String vmImageID = name + "-" + System.currentTimeMillis();
        VMwareServiceConnection connection = this.host.getConnectionPool().getConnection();
        if (connection == null) {
            logger.debug((Object)"Out of connection");
            throw new VMMException("Too many VM creation requests, try again later");
        }
        VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
        VirtualMachineRelocateSpec relocSpec = new VirtualMachineRelocateSpec();
        try {
            this.shutdown();
            relocSpec.setPool(this.host.getVCResourcePool(connection));
            relocSpec.setDatastore(this.pool.getDatastoreRef());
            cloneSpec.setLocation(relocSpec);
            cloneSpec.setPowerOn(false);
            cloneSpec.setTemplate(true);
            VMwareServiceConnection vMwareServiceConnection = connection;
            synchronized (vMwareServiceConnection) {
                logger.debug((Object)("Making template " + vmImageID + " from VM " + this.getNameLabel()));
                String status = "";
                try {
                    ManagedObjectReference cloneTask = connection.getService().cloneVM_Task(this.ref, this.pool.getVmTemplateFolderRef(), vmImageID, cloneSpec);
                    status = connection.waitForTask(cloneTask);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to create template", (Throwable)e);
                    throw new VMMException((Throwable)e);
                }
                logger.debug((Object)("CloneVMTask, status=" + status));
                if (status.equalsIgnoreCase("failure")) {
                    String msg = "Failure -: Virtual Machine cannot be cloned to template";
                    logger.error((Object)msg);
                    throw new VMMException(msg);
                }
            }
        }
        finally {
            connection.release();
            this.start();
        }
        ((VMwareServerPool.VMwareVMTemplateDataStore)this.host.getVMImageStore()).sync();
        return ((VMwareServerPool.VMwareVMTemplateDataStore)this.host.getVMImageStore()).lookUpByUUID(vmImageID);
    }
}

