/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.ow2.jasmine.vmm.agent.main.VirtManagerAgent;
import org.ow2.jasmine.vmm.api.VMMAgentMXBean;

public class AgentControl {
    private static Logger logger = Logger.getLogger(AgentControl.class);
    public static final String vmmHome = System.getProperty("vmm.home");
    private static final int DEFAULT_PORT = 9999;
    private static final String DEFAULT_HOST = "localhost";

    public static void main(String[] args) {
        String s;
        if (vmmHome == null) {
            System.out.println("vmm.home system property must be set");
            System.exit(1);
        }
        Properties properties = new Properties();
        String agentPropFileName = "etc" + File.separator + "agent.properties";
        try {
            properties.load(new FileInputStream(new File(vmmHome, agentPropFileName)));
        }
        catch (IOException ex) {
            logger.fatal((Object)("Cannot load VMM agent property file " + agentPropFileName), (Throwable)ex);
            System.exit(1);
        }
        int port = 9999;
        try {
            port = Integer.parseInt(properties.getProperty("vmm.port"));
        }
        catch (NumberFormatException ex) {
            logger.fatal((Object)"Cannot parse vmm.port property", (Throwable)ex);
            System.exit(1);
        }
        String managedResourcesFileName = properties.getProperty("vmm.resourceFile", "managed-resources.xml");
        String host = DEFAULT_HOST;
        Mode mode = null;
        for (int i = 0; i < args.length && (s = args[i]).startsWith("-"); ++i) {
            if (s.equals("-start")) {
                mode = Mode.START;
                continue;
            }
            if (s.equals("-stop")) {
                mode = Mode.STOP;
                continue;
            }
            if (s.equals("-port")) {
                if (i < args.length - 1) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                AgentControl.printUsageAndExit();
                continue;
            }
            if (s.equals("-host")) {
                if (i < args.length - 1) {
                    host = args[++i];
                    continue;
                }
                AgentControl.printUsageAndExit();
                continue;
            }
            AgentControl.printUsageAndExit();
        }
        if (mode == null) {
            AgentControl.printUsageAndExit();
        }
        if (mode == Mode.START) {
            new VirtManagerAgent(port, managedResourcesFileName);
        } else if (mode == Mode.STOP) {
            try {
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/server");
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                ObjectName agentObjectName = new ObjectName("org.ow2.jasmine.vmm.api:type=Agent");
                VMMAgentMXBean agentMBean = JMX.newMXBeanProxy(mbsc, agentObjectName, VMMAgentMXBean.class);
                agentMBean.shutdown();
                jmxc.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: java org.ow2.jasmine.vmm.agent.main.AgentControl -start|stop [-port <port>] [-host <host>]");
        System.exit(1);
    }

    public static String getManagedResourcesFileName() {
        Properties properties = new Properties();
        String agentPropFileName = "etc" + File.separator + "agent.properties";
        try {
            properties.load(new FileInputStream(new File(vmmHome, agentPropFileName)));
        }
        catch (IOException ex) {
            logger.fatal((Object)("Cannot load VMM agent property file " + agentPropFileName), (Throwable)ex);
            System.exit(1);
        }
        String managedResourcesFileName = properties.getProperty("vmm.resourceFile", "managed-resources.xml");
        return managedResourcesFileName;
    }

    private static enum Mode {
        START,
        STOP;

    }
}

