/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.vmm.agent.main.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ow2.jasmine.vmm.agent.main.persistence.ConfigurationGenerator;
import org.ow2.jasmine.vmm.agent.main.persistence.ConfigurationGeneratorException;
import org.xml.sax.ContentHandler;

public abstract class AbstractConfigurationGenerator
implements ConfigurationGenerator {
    protected String baseDir;

    public AbstractConfigurationGenerator(String baseDir) throws ConfigurationGeneratorException {
        if (baseDir == null) {
            throw new ConfigurationGeneratorException("Base directory for generation cannot be null.");
        }
        if (!baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        this.baseDir = baseDir;
    }

    protected ContentHandler getHandler(String fileName) throws FileNotFoundException, TransformerConfigurationException {
        new File(this.baseDir).mkdirs();
        String filePath = this.baseDir + fileName;
        PrintWriter out = new PrintWriter(filePath);
        StreamResult streamResult = new StreamResult(out);
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        tf.setAttribute("indent-number", new Integer(2));
        TransformerHandler hd = tf.newTransformerHandler();
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("encoding", "ISO-8859-1");
        serializer.setOutputProperty("indent", "yes");
        hd.setResult(streamResult);
        return hd;
    }

    @Override
    public String getBaseDir() {
        return this.baseDir;
    }
}

