/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;

public final class JIArray
implements Serializable {
    private static final long serialVersionUID = -8267477025978489665L;
    private Object memberArray = null;
    private Class clazz = null;
    private int[] upperBounds = null;
    private int dimension = -1;
    private int numElementsInAllDimensions = 0;
    private boolean isConformant = false;
    private boolean isVarying = false;
    private boolean isConformantProxy = false;
    private boolean isVaryingProxy = false;
    private List conformantMaxCounts = new ArrayList();
    private Object template = null;
    private int sizeOfNestedArrayInBytes = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    private JIArray() {
    }

    public JIArray(Class clazz, int[] upperBounds, int dimension, boolean isConformant) {
        this.clazz = clazz;
        this.init2(upperBounds, dimension, isConformant, false);
    }

    public JIArray(Class clazz, int[] upperBounds, int dimension, boolean isConformant, boolean isVarying) {
        this.clazz = clazz;
        this.init2(upperBounds, dimension, isConformant, isVarying);
    }

    public JIArray(Object template, int[] upperBounds, int dimension, boolean isConformant) {
        if (template == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4114));
        }
        Class<?> clazz = template.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jinterop.dcom.core.JIStruct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(clazz2)) {
            Class<?> clazz3 = template.getClass();
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("org.jinterop.dcom.core.JIUnion");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.equals(clazz4)) {
                Class<?> clazz5 = template.getClass();
                Class<?> clazz6 = class$2;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$2 = Class.forName("org.jinterop.dcom.core.JIPointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz5.equals(clazz6)) {
                    Class<?> clazz7 = template.getClass();
                    Class<?> clazz8 = class$3;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$3 = Class.forName("org.jinterop.dcom.core.JIString");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz7.equals(clazz8)) {
                        throw new IllegalArgumentException(JISystem.getLocalizedMessage(4117));
                    }
                }
            }
        }
        this.template = template;
        this.clazz = template.getClass();
        this.init2(upperBounds, dimension, isConformant, false);
    }

    public JIArray(Object template, int[] upperBounds, int dimension, boolean isConformant, boolean isVarying) {
        if (template == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4114));
        }
        Class<?> clazz = template.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jinterop.dcom.core.JIStruct");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(clazz2)) {
            Class<?> clazz3 = template.getClass();
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("org.jinterop.dcom.core.JIUnion");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.equals(clazz4)) {
                Class<?> clazz5 = template.getClass();
                Class<?> clazz6 = class$2;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$2 = Class.forName("org.jinterop.dcom.core.JIPointer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz5.equals(clazz6)) {
                    Class<?> clazz7 = template.getClass();
                    Class<?> clazz8 = class$3;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$3 = Class.forName("org.jinterop.dcom.core.JIString");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz7.equals(clazz8)) {
                        throw new IllegalArgumentException(JISystem.getLocalizedMessage(4117));
                    }
                }
            }
        }
        this.template = template;
        this.clazz = template.getClass();
        this.init2(upperBounds, dimension, isConformant, isVarying);
    }

    private void init2(int[] upperBounds, int dimension, boolean isConformant, boolean isVarying) {
        this.upperBounds = upperBounds;
        this.dimension = dimension;
        this.isConformant = isConformant;
        this.isConformantProxy = isConformant;
        this.isVarying = isVarying;
        this.isVaryingProxy = isVarying;
        if (upperBounds != null && upperBounds.length != dimension) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4136));
        }
        int i = 0;
        while (upperBounds != null && i < upperBounds.length) {
            this.numElementsInAllDimensions += upperBounds[i];
            if (isConformant) {
                this.conformantMaxCounts.add(new Integer(upperBounds[i]));
            }
            ++i;
        }
    }

    public JIArray(Object array, boolean isConformant) {
        this.isConformant = isConformant;
        this.isConformantProxy = isConformant;
        this.init(array);
    }

    public JIArray(Object array, boolean isConformant, boolean isVarying) {
        this.isConformant = isConformant;
        this.isConformantProxy = isConformant;
        this.isVarying = isVarying;
        this.isVaryingProxy = isVarying;
        this.init(array);
    }

    public JIArray(Object array) {
        this.init(array);
    }

    private void init(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4115));
        }
        if (array.getClass().isPrimitive()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4116));
        }
        if (array.getClass().toString().indexOf("java.lang.Object") != -1) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4162));
        }
        this.memberArray = array;
        ArrayList<Integer> upperBounds2 = new ArrayList<Integer>();
        String name = array.getClass().getName();
        Object subArray = array;
        this.numElementsInAllDimensions = 1;
        while (name.startsWith("[")) {
            name = name.substring(1);
            int x = ((Object[])subArray).length;
            upperBounds2.add(new Integer(x));
            this.numElementsInAllDimensions *= x;
            if (this.isConformant) {
                this.conformantMaxCounts.add(new Integer(x));
            }
            this.clazz = subArray.getClass().getComponentType();
            if (x == 0) break;
            subArray = Array.get(subArray, 0);
            ++this.dimension;
        }
        if (this.dimension == -1) {
            this.numElementsInAllDimensions = 0;
            ++this.dimension;
        }
        this.upperBounds = new int[upperBounds2.size()];
        int i = 0;
        while (i < upperBounds2.size()) {
            this.upperBounds[i] = (Integer)upperBounds2.get(i);
            ++i;
        }
        ++this.dimension;
        this.sizeOfNestedArrayInBytes = this.computeLengthArray(array);
    }

    private int computeLengthArray(Object array) {
        int length = 0;
        String name = array.getClass().getName();
        Object[] o = (Object[])array;
        int i = 0;
        while (i < o.length) {
            if (name.charAt(1) != '[') {
                Object[] o1 = (Object[])array;
                int j = 0;
                while (j < o1.length) {
                    length += JIMarshalUnMarshalHelper.getLengthInBytes(o1.getClass().getComponentType(), o1[j], 0);
                    ++j;
                }
                return length;
            }
            length += this.computeLengthArray(Array.get(array, i));
            ++i;
        }
        return length;
    }

    public Object getArrayInstance() {
        return this.memberArray;
    }

    public Class getArrayClass() {
        return this.clazz;
    }

    public int[] getUpperBounds() {
        return this.upperBounds;
    }

    public int getDimensions() {
        return this.dimension;
    }

    int getSizeOfAllElementsInBytes() {
        if (this.sizeOfNestedArrayInBytes == -1) {
            this.sizeOfNestedArrayInBytes = this.computeLengthArray(this.memberArray);
        }
        return this.sizeOfNestedArrayInBytes;
    }

    void encode(NetworkDataRepresentation ndr, Object array, List defferedPointers, int FLAG) {
        int i;
        if (this.isConformantProxy) {
            i = 0;
            while (i < this.conformantMaxCounts.size()) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                JIMarshalUnMarshalHelper.serialize(ndr, clazz, this.conformantMaxCounts.get(i), defferedPointers, FLAG);
                ++i;
            }
            this.isConformantProxy = false;
        }
        if (this.isVaryingProxy) {
            i = 0;
            while (i < this.conformantMaxCounts.size()) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                JIMarshalUnMarshalHelper.serialize(ndr, clazz, new Integer(0), defferedPointers, FLAG);
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                JIMarshalUnMarshalHelper.serialize(ndr, clazz2, this.conformantMaxCounts.get(i), defferedPointers, FLAG);
                ++i;
            }
            this.isVaryingProxy = false;
        }
        String name = array.getClass().getName();
        Object[] o = (Object[])array;
        int i2 = 0;
        while (i2 < o.length) {
            if (name.charAt(1) != '[') {
                Object[] o1 = (Object[])array;
                int j = 0;
                while (j < o1.length) {
                    JIMarshalUnMarshalHelper.serialize(ndr, this.clazz, o1[j], defferedPointers, FLAG | 8);
                    ++j;
                }
                return;
            }
            this.encode(ndr, Array.get(array, i2), defferedPointers, FLAG);
            ++i2;
        }
    }

    public boolean isConformant() {
        return this.isConformant;
    }

    public boolean isVarying() {
        return this.isVarying;
    }

    Object decode(NetworkDataRepresentation ndr, Class arrayType, int dimension, List defferedPointers, int FLAG, Map additionalData) {
        int i;
        JIArray retVal = new JIArray();
        retVal.isConformantProxy = this.isConformantProxy;
        retVal.isVaryingProxy = this.isVaryingProxy;
        if (this.isConformantProxy) {
            i = 0;
            while (i < dimension) {
                List list = retVal.conformantMaxCounts;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                list.add(JIMarshalUnMarshalHelper.deSerialize(ndr, clazz, defferedPointers, FLAG, additionalData));
                ++i;
            }
            if (this.upperBounds == null) {
                retVal.numElementsInAllDimensions = 0;
                retVal.upperBounds = new int[retVal.conformantMaxCounts.size()];
                i = 0;
                while (i < retVal.conformantMaxCounts.size()) {
                    retVal.upperBounds[i] = (Integer)retVal.conformantMaxCounts.get(i);
                    retVal.numElementsInAllDimensions *= retVal.upperBounds[i];
                    ++i;
                }
                if (i == 0) {
                    this.numElementsInAllDimensions = 0;
                }
            }
        } else {
            retVal.upperBounds = this.upperBounds;
            retVal.conformantMaxCounts = this.conformantMaxCounts;
            retVal.numElementsInAllDimensions = this.numElementsInAllDimensions;
        }
        if (this.isVaryingProxy) {
            i = 0;
            retVal.conformantMaxCounts.clear();
            retVal.upperBounds = null;
            retVal.numElementsInAllDimensions = 0;
            while (i < dimension) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                JIMarshalUnMarshalHelper.deSerialize(ndr, clazz, defferedPointers, FLAG, null);
                List list = retVal.conformantMaxCounts;
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                list.add(JIMarshalUnMarshalHelper.deSerialize(ndr, clazz2, defferedPointers, FLAG, additionalData));
                ++i;
            }
            if (this.upperBounds == null) {
                retVal.numElementsInAllDimensions = 1;
                retVal.upperBounds = new int[retVal.conformantMaxCounts.size()];
                i = 0;
                while (i < retVal.conformantMaxCounts.size()) {
                    retVal.upperBounds[i] = (Integer)retVal.conformantMaxCounts.get(i);
                    retVal.numElementsInAllDimensions *= retVal.upperBounds[i];
                    ++i;
                }
                if (i == 0) {
                    this.numElementsInAllDimensions = 0;
                }
            }
        }
        retVal.isConformant = this.isConformant;
        retVal.isVarying = this.isVarying;
        retVal.template = this.template;
        retVal.memberArray = this.recurseDecode(retVal, ndr, arrayType, dimension, defferedPointers, FLAG, additionalData);
        retVal.clazz = this.clazz;
        retVal.dimension = this.dimension;
        retVal.sizeOfNestedArrayInBytes = -1;
        return retVal;
    }

    private Object recurseDecode(JIArray retVal, NetworkDataRepresentation ndr, Class arrayType, int dimension, List defferedPointers, int FLAG, Map additionalData) {
        Object array = null;
        Class<?> c = arrayType;
        int j = 0;
        while (j < dimension) {
            array = Array.newInstance(c, retVal.upperBounds[retVal.upperBounds.length - j - 1]);
            c = array.getClass();
            ++j;
        }
        int i = 0;
        while (i < retVal.upperBounds[retVal.upperBounds.length - dimension]) {
            if (dimension == 1) {
                if (this.template == null) {
                    Array.set(array, i, JIMarshalUnMarshalHelper.deSerialize(ndr, c.getComponentType() == null ? c : c.getComponentType(), defferedPointers, FLAG | 8, additionalData));
                } else {
                    Array.set(array, i, JIMarshalUnMarshalHelper.deSerialize(ndr, this.template, defferedPointers, FLAG | 8, additionalData));
                }
            } else {
                Array.set(array, i, this.recurseDecode(retVal, ndr, arrayType, dimension - 1, defferedPointers, FLAG, additionalData));
            }
            ++i;
        }
        return array;
    }

    int reverseArrayForDispatch() {
        if (this.memberArray == null) {
            return 0;
        }
        int i = 0;
        Stack<Object> stack = new Stack<Object>();
        i = 0;
        while (i < ((Object[])this.memberArray).length) {
            stack.push(((Object[])this.memberArray)[i]);
            ++i;
        }
        i = 0;
        while (stack.size() > 0) {
            ((Object[])this.memberArray)[i++] = stack.pop();
        }
        return i;
    }

    List getConformantMaxCounts() {
        return this.conformantMaxCounts;
    }

    void setConformant(boolean isConformant) {
        this.isConformantProxy = isConformant;
    }

    void setVarying(boolean isVarying) {
        this.isVaryingProxy = isVarying;
    }

    void setMaxCountAndUpperBounds(List maxCount) {
        this.conformantMaxCounts = maxCount;
        if (this.conformantMaxCounts.size() > 0) {
            this.numElementsInAllDimensions = 1;
            this.upperBounds = new int[this.conformantMaxCounts.size()];
            int i = 0;
            while (i < this.conformantMaxCounts.size()) {
                this.upperBounds[i] = (Integer)this.conformantMaxCounts.get(i);
                this.numElementsInAllDimensions *= this.upperBounds[i];
                ++i;
            }
            if (i == 0) {
                this.numElementsInAllDimensions = 0;
            }
        } else {
            this.upperBounds = null;
            this.numElementsInAllDimensions = 0;
        }
    }

    int getNumElementsInAllDimensions() {
        return this.numElementsInAllDimensions;
    }

    void updateClazz(Class c) {
        this.clazz = c;
    }

    public String toString() {
        String retVal = "[Type: " + this.clazz + " , ";
        retVal = this.memberArray == null ? String.valueOf(retVal) + "memberArray is null , " : String.valueOf(retVal) + this.memberArray + " , ";
        if (this.isConformant) {
            retVal = String.valueOf(retVal) + " conformant , ";
        }
        if (this.isVarying) {
            retVal = String.valueOf(retVal) + " varying , ";
        }
        return String.valueOf(retVal) + "]";
    }
}

