/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class Bond
extends XenAPIObject {
    protected final String ref;

    Bond(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Bond) {
            Bond bond = (Bond)object;
            return bond.ref.equals(this.ref);
        }
        return false;
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBondRecord(v);
    }

    public static Bond getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Bond.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toBond(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public PIF getMaster(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.get_master";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPIF(v);
    }

    public Set<PIF> getSlaves(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.get_slaves";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPIF(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Bond.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Bond.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static Task createAsync(Connection connection, Network network, Set<PIF> set, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.Bond.create";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Bond create(Connection connection, Network network, Set<PIF> set, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Bond.create";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toBond(v);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.Bond.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<Bond> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfBond(v);
    }

    public static Map<Bond, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Bond.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfBondBondRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public PIF master;
        public Set<PIF> slaves;
        public Map<String, String> otherConfig;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "master", this.master);
            printWriter.printf("%1$20s: %2$s\n", "slaves", this.slaves);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("master", this.master == null ? new PIF("OpaqueRef:NULL") : this.master);
            hashMap.put("slaves", this.slaves == null ? new LinkedHashSet() : this.slaves);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            return hashMap;
        }
    }
}

