/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.APIVersion;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Session;
import com.xensource.xenapi.Types;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;

public class Connection {
    public static final String BINDINGS_VERSION = "5.5.0-1";
    @Deprecated
    public Boolean rioConnection = false;
    private APIVersion apiVersion;
    private String sessionReference;
    private final XmlRpcClient client;
    private final boolean deprecatedConstructorUsed;

    public APIVersion getAPIVersion() {
        return this.apiVersion;
    }

    @Deprecated
    public Connection(String string, String string2, String string3) throws MalformedURLException, XmlRpcException, Types.BadServerResponse, Types.SessionAuthenticationFailed, Types.XenAPIException {
        this.deprecatedConstructorUsed = true;
        String string4 = APIVersion.latest().toString();
        this.client = Connection.getClientFromURL(new URL(string));
        try {
            this.sessionReference = Connection.loginWithPassword(this.client, string2, string3, string4);
        }
        catch (Types.BadServerResponse badServerResponse) {
            String[] stringArray = badServerResponse.errorDescription;
            if (0 == stringArray[0].compareTo("MESSAGE_PARAMETER_COUNT_MISMATCH") && 0 == stringArray[1].compareTo("session.login_with_password") && 0 == stringArray[2].compareTo("2") && 0 == stringArray[3].compareTo("3")) {
                this.sessionReference = Connection.loginWithPassword(this.client, string2, string3);
                this.rioConnection = true;
            }
            throw badServerResponse;
        }
        try {
            this.setAPIVersion(new Session(this.sessionReference));
        }
        catch (Types.XenAPIException xenAPIException) {
            this.dispose();
            throw xenAPIException;
        }
        catch (XmlRpcException xmlRpcException) {
            this.dispose();
            throw xmlRpcException;
        }
    }

    public Connection(URL uRL) {
        this.deprecatedConstructorUsed = false;
        this.client = Connection.getClientFromURL(uRL);
    }

    public Connection(URL uRL, String string) {
        this.deprecatedConstructorUsed = false;
        this.client = Connection.getClientFromURL(uRL);
        this.sessionReference = string;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (!this.deprecatedConstructorUsed) {
            return;
        }
        try {
            if (this.sessionReference != null) {
                String string = "session.logout";
                Object[] objectArray = new Object[]{Marshalling.toXMLRPC(this.sessionReference)};
                this.client.execute(string, objectArray);
                this.sessionReference = null;
            }
        }
        catch (XmlRpcException xmlRpcException) {
            // empty catch block
        }
    }

    @Deprecated
    private static String loginWithPassword(XmlRpcClient xmlRpcClient, String string, String string2) throws Types.BadServerResponse, XmlRpcException, Types.SessionAuthenticationFailed {
        Object[] objectArray;
        String string3 = "session.login_with_password";
        Object[] objectArray2 = new Object[]{Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = (Map)xmlRpcClient.execute(string3, objectArray2);
        if (map.get("Status").equals("Success")) {
            return (String)map.get("Value");
        }
        if (map.get("Status").equals("Failure") && (objectArray = (Object[])map.get("ErrorDescription"))[0].equals("SESSION_AUTHENTICATION_FAILED")) {
            throw new Types.SessionAuthenticationFailed();
        }
        throw new Types.BadServerResponse(map);
    }

    @Deprecated
    private static String loginWithPassword(XmlRpcClient xmlRpcClient, String string, String string2, String string3) throws Types.BadServerResponse, XmlRpcException, Types.SessionAuthenticationFailed {
        Object[] objectArray;
        String string4 = "session.login_with_password";
        Object[] objectArray2 = new Object[]{Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3)};
        Map map = (Map)xmlRpcClient.execute(string4, objectArray2);
        if (map.get("Status").equals("Success")) {
            return (String)map.get("Value");
        }
        if (map.get("Status").equals("Failure") && (objectArray = (Object[])map.get("ErrorDescription"))[0].equals("SESSION_AUTHENTICATION_FAILED")) {
            throw new Types.SessionAuthenticationFailed();
        }
        throw new Types.BadServerResponse(map);
    }

    private static XmlRpcClient getClientFromURL(URL uRL) {
        XmlRpcClientConfigImpl xmlRpcClientConfigImpl = new XmlRpcClientConfigImpl();
        xmlRpcClientConfigImpl.setServerURL(uRL);
        XmlRpcClient xmlRpcClient = new XmlRpcClient();
        xmlRpcClient.setConfig((XmlRpcClientConfig)xmlRpcClientConfigImpl);
        return xmlRpcClient;
    }

    public String getSessionReference() {
        return this.sessionReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map dispatch(String string, Object[] objectArray) throws XmlRpcException, Types.XenAPIException {
        Map map = (Map)this.client.execute(string, objectArray);
        if (!this.deprecatedConstructorUsed) {
            if (string.equals("session.login_with_password") && map.get("Status").equals("Success")) {
                Session session = Types.toSession(map.get("Value"));
                this.sessionReference = session.ref;
                this.setAPIVersion(session);
            } else if (string.equals("session.slave_local_login_with_password") && map.get("Status").equals("Success")) {
                this.sessionReference = Types.toSession(map.get((Object)"Value")).ref;
                this.apiVersion = APIVersion.API_1_2;
            } else if (string.equals("session.logout")) {
                Object[] objectArray2;
                if (map.get("Status").equals("Failure") && (objectArray2 = (Object[])map.get("ErrorDescription")).length == 2 && objectArray2[0].equals("HOST_IS_SLAVE")) {
                    try {
                        URL uRL = ((XmlRpcHttpClientConfig)this.client.getClientConfig()).getServerURL();
                        Connection connection = new Connection(new URL(uRL.getProtocol(), (String)objectArray2[1], uRL.getPort(), uRL.getFile()));
                        connection.sessionReference = this.sessionReference;
                        try {
                            Session.logout(connection);
                        }
                        finally {
                            connection.dispose();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.sessionReference = null;
            }
        }
        return Types.checkResponse(map);
    }

    private void setAPIVersion(Session session) throws Types.XenAPIException, XmlRpcException {
        try {
            long l = session.getThisHost(this).getAPIVersionMajor(this);
            long l2 = session.getThisHost(this).getAPIVersionMinor(this);
            this.apiVersion = APIVersion.fromMajorMinor(l, l2);
        }
        catch (Types.BadServerResponse badServerResponse) {
            this.apiVersion = APIVersion.API_1_1;
        }
    }
}

