/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class Event
extends XenAPIObject {
    protected final String ref;

    Event(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Event) {
            Event event = (Event)object;
            return event.ref.equals(this.ref);
        }
        return false;
    }

    public static Task registerAsync(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.event.register";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void register(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "event.register";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task unregisterAsync(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.event.unregister";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void unregister(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "event.unregister";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<Record> next(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.SessionNotRegistered, Types.EventsLost {
        String string = "event.next";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfEventRecord(v);
    }

    public static Long getCurrentId(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "event.get_current_id";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public static class Record
    implements Types.Record {
        public Long id;
        public Date timestamp;
        public String clazz;
        public Types.EventOperation operation;
        public String ref;
        public String objUuid;
        public Object snapshot;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "id", this.id);
            printWriter.printf("%1$20s: %2$s\n", "timestamp", this.timestamp);
            printWriter.printf("%1$20s: %2$s\n", "clazz", this.clazz);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"operation", this.operation});
            printWriter.printf("%1$20s: %2$s\n", "ref", this.ref);
            printWriter.printf("%1$20s: %2$s\n", "objUuid", this.objUuid);
            printWriter.printf("%1$20s: %2$s\n", "snapshot", this.snapshot);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", this.id == null ? 0L : this.id);
            hashMap.put("timestamp", this.timestamp == null ? new Date(0L) : this.timestamp);
            hashMap.put("class", this.clazz == null ? "" : this.clazz);
            hashMap.put("operation", (Object)(this.operation == null ? Types.EventOperation.UNRECOGNIZED : this.operation));
            hashMap.put("ref", this.ref == null ? "" : this.ref);
            hashMap.put("obj_uuid", this.objUuid == null ? "" : this.objUuid);
            hashMap.put("snapshot", this.snapshot);
            return hashMap;
        }
    }
}

