/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Crashdump;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VBD;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class VDI
extends XenAPIObject {
    protected final String ref;

    VDI(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VDI) {
            VDI vDI = (VDI)object;
            return vDI.ref.equals(this.ref);
        }
        return false;
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDIRecord(v);
    }

    public static VDI getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    public static Task createAsync(Connection connection, Record record) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VDI.create";
        String string2 = connection.getSessionReference();
        Map<String, Object> map = record.toMap();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static VDI create(Connection connection, Record record) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.create";
        String string2 = connection.getSessionReference();
        Map<String, Object> map = record.toMap();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toVDI(v);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VDI.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<VDI> getByNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.get_by_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVDI(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameLabel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_name_label";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameDescription(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_name_description";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<Types.VdiOperations> getAllowedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVdiOperations(v);
    }

    public Map<String, Types.VdiOperations> getCurrentOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_current_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringVdiOperations(v);
    }

    public SR getSR(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public Set<VBD> getVBDs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_VBDs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVBD(v);
    }

    public Set<Crashdump> getCrashDumps(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_crash_dumps";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfCrashdump(v);
    }

    public Long getVirtualSize(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_virtual_size";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getPhysicalUtilisation(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_physical_utilisation";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Types.VdiType getType(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_type";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVdiType(v);
    }

    public Boolean getSharable(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_sharable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getReadOnly(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_read_only";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Boolean getStorageLock(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_storage_lock";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public String getLocation(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_location";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Boolean getManaged(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_managed";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getMissing(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_missing";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public VDI getParent(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_parent";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    public Map<String, String> getXenstoreData(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_xenstore_data";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Map<String, String> getSmConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_sm_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Boolean getIsASnapshot(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_is_a_snapshot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public VDI getSnapshotOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_snapshot_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    public Set<VDI> getSnapshots(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_snapshots";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVDI(v);
    }

    public Date getSnapshotTime(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_snapshot_time";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDate(v);
    }

    public Set<String> getTags(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public void setNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.set_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setNameDescription(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.set_name_description";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VDI.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setXenstoreData(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_xenstore_data";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToXenstoreData(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VDI.add_to_xenstore_data";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromXenstoreData(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.remove_from_xenstore_data";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setSmConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_sm_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToSmConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VDI.add_to_sm_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromSmConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.remove_from_sm_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setTags(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void addTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.add_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void removeTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VDI.remove_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task snapshotAsync(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.VersionException, Types.XenAPIException, XmlRpcException {
        if (connection.rioConnection.booleanValue()) {
            if (map.isEmpty()) {
                return this.rioSnapshotAsync(connection);
            }
            throw new Types.VersionException("driverParams parameter must be empty map for Rio (legacy XenServer) host");
        }
        return this.miamiSnapshotAsync(connection, map);
    }

    private Task rioSnapshotAsync(Connection connection) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "Async.VDI.snapshot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    private Task miamiSnapshotAsync(Connection connection, Map<String, String> map) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "Async.VDI.snapshot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public VDI snapshot(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.VersionException, Types.XenAPIException, XmlRpcException {
        if (connection.rioConnection.booleanValue()) {
            if (map.isEmpty()) {
                return this.rioSnapshot(connection);
            }
            throw new Types.VersionException("driverParams parameter must be empty map for Rio (legacy XenServer) host");
        }
        return this.miamiSnapshot(connection, map);
    }

    private VDI rioSnapshot(Connection connection) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "VDI.snapshot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    private VDI miamiSnapshot(Connection connection, Map<String, String> map) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "VDI.snapshot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toVDI(v);
    }

    public Task createCloneAsync(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.VersionException, Types.XenAPIException, XmlRpcException {
        if (connection.rioConnection.booleanValue()) {
            if (map.isEmpty()) {
                return this.rioCreateCloneAsync(connection);
            }
            throw new Types.VersionException("driverParams parameter must be empty map for Rio (legacy XenServer) host");
        }
        return this.miamiCreateCloneAsync(connection, map);
    }

    private Task rioCreateCloneAsync(Connection connection) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "Async.VDI.clone";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    private Task miamiCreateCloneAsync(Connection connection, Map<String, String> map) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "Async.VDI.clone";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public VDI createClone(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.VersionException, Types.XenAPIException, XmlRpcException {
        if (connection.rioConnection.booleanValue()) {
            if (map.isEmpty()) {
                return this.rioCreateClone(connection);
            }
            throw new Types.VersionException("driverParams parameter must be empty map for Rio (legacy XenServer) host");
        }
        return this.miamiCreateClone(connection, map);
    }

    private VDI rioCreateClone(Connection connection) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "VDI.clone";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    private VDI miamiCreateClone(Connection connection, Map<String, String> map) throws Types.BadServerResponse, XmlRpcException, Types.XenAPIException {
        String string = "VDI.clone";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toVDI(v);
    }

    public Task resizeAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VDI.resize";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void resize(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.resize";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task resizeOnlineAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VDI.resize_online";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void resizeOnline(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.resize_online";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task introduceAsync(Connection connection, String string, String string2, String string3, SR sR, Types.VdiType vdiType, Boolean bl, Boolean bl2, Map<String, String> map, String string4, Map<String, String> map2, Map<String, String> map3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.SrOperationNotSupported {
        String string5 = "Async.VDI.introduce";
        String string6 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(sR), Marshalling.toXMLRPC((Object)vdiType), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3)};
        Map map4 = connection.dispatch(string5, objectArray);
        Object v = map4.get("Value");
        return Types.toTask(v);
    }

    public static VDI introduce(Connection connection, String string, String string2, String string3, SR sR, Types.VdiType vdiType, Boolean bl, Boolean bl2, Map<String, String> map, String string4, Map<String, String> map2, Map<String, String> map3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.SrOperationNotSupported {
        String string5 = "VDI.introduce";
        String string6 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(sR), Marshalling.toXMLRPC((Object)vdiType), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3)};
        Map map4 = connection.dispatch(string5, objectArray);
        Object v = map4.get("Value");
        return Types.toVDI(v);
    }

    public static Task dbIntroduceAsync(Connection connection, String string, String string2, String string3, SR sR, Types.VdiType vdiType, Boolean bl, Boolean bl2, Map<String, String> map, String string4, Map<String, String> map2, Map<String, String> map3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string5 = "Async.VDI.db_introduce";
        String string6 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(sR), Marshalling.toXMLRPC((Object)vdiType), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3)};
        Map map4 = connection.dispatch(string5, objectArray);
        Object v = map4.get("Value");
        return Types.toTask(v);
    }

    public static VDI dbIntroduce(Connection connection, String string, String string2, String string3, SR sR, Types.VdiType vdiType, Boolean bl, Boolean bl2, Map<String, String> map, String string4, Map<String, String> map2, Map<String, String> map3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string5 = "VDI.db_introduce";
        String string6 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string6), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(sR), Marshalling.toXMLRPC((Object)vdiType), Marshalling.toXMLRPC(bl), Marshalling.toXMLRPC(bl2), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(map2), Marshalling.toXMLRPC(map3)};
        Map map4 = connection.dispatch(string5, objectArray);
        Object v = map4.get("Value");
        return Types.toVDI(v);
    }

    public Task dbForgetAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VDI.db_forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void dbForget(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.db_forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task updateAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.SrOperationNotSupported {
        String string = "Async.VDI.update";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void update(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.SrOperationNotSupported {
        String string = "VDI.update";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task copyAsync(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VDI.copy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public VDI copy(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.copy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    public void setManaged(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_managed";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task forgetAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VDI.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void forget(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setSharable(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_sharable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setReadOnly(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_read_only";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setMissing(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_missing";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setVirtualSize(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_virtual_size";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setPhysicalUtilisation(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.set_physical_utilisation";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<VDI> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVDI(v);
    }

    public static Map<VDI, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VDI.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVDIVDIRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Set<Types.VdiOperations> allowedOperations;
        public Map<String, Types.VdiOperations> currentOperations;
        public SR SR;
        public Set<VBD> VBDs;
        public Set<Crashdump> crashDumps;
        public Long virtualSize;
        public Long physicalUtilisation;
        public Types.VdiType type;
        public Boolean sharable;
        public Boolean readOnly;
        public Map<String, String> otherConfig;
        public Boolean storageLock;
        public String location;
        public Boolean managed;
        public Boolean missing;
        public VDI parent;
        public Map<String, String> xenstoreData;
        public Map<String, String> smConfig;
        public Boolean isASnapshot;
        public VDI snapshotOf;
        public Set<VDI> snapshots;
        public Date snapshotTime;
        public Set<String> tags;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            printWriter.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            printWriter.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            printWriter.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            printWriter.printf("%1$20s: %2$s\n", "SR", this.SR);
            printWriter.printf("%1$20s: %2$s\n", "VBDs", this.VBDs);
            printWriter.printf("%1$20s: %2$s\n", "crashDumps", this.crashDumps);
            printWriter.printf("%1$20s: %2$s\n", "virtualSize", this.virtualSize);
            printWriter.printf("%1$20s: %2$s\n", "physicalUtilisation", this.physicalUtilisation);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"type", this.type});
            printWriter.printf("%1$20s: %2$s\n", "sharable", this.sharable);
            printWriter.printf("%1$20s: %2$s\n", "readOnly", this.readOnly);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "storageLock", this.storageLock);
            printWriter.printf("%1$20s: %2$s\n", "location", this.location);
            printWriter.printf("%1$20s: %2$s\n", "managed", this.managed);
            printWriter.printf("%1$20s: %2$s\n", "missing", this.missing);
            printWriter.printf("%1$20s: %2$s\n", "parent", this.parent);
            printWriter.printf("%1$20s: %2$s\n", "xenstoreData", this.xenstoreData);
            printWriter.printf("%1$20s: %2$s\n", "smConfig", this.smConfig);
            printWriter.printf("%1$20s: %2$s\n", "isASnapshot", this.isASnapshot);
            printWriter.printf("%1$20s: %2$s\n", "snapshotOf", this.snapshotOf);
            printWriter.printf("%1$20s: %2$s\n", "snapshots", this.snapshots);
            printWriter.printf("%1$20s: %2$s\n", "snapshotTime", this.snapshotTime);
            printWriter.printf("%1$20s: %2$s\n", "tags", this.tags);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            hashMap.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            hashMap.put("allowed_operations", this.allowedOperations == null ? new LinkedHashSet() : this.allowedOperations);
            hashMap.put("current_operations", this.currentOperations == null ? new HashMap() : this.currentOperations);
            hashMap.put("SR", this.SR == null ? new SR("OpaqueRef:NULL") : this.SR);
            hashMap.put("VBDs", this.VBDs == null ? new LinkedHashSet() : this.VBDs);
            hashMap.put("crash_dumps", this.crashDumps == null ? new LinkedHashSet() : this.crashDumps);
            hashMap.put("virtual_size", this.virtualSize == null ? 0L : this.virtualSize);
            hashMap.put("physical_utilisation", this.physicalUtilisation == null ? 0L : this.physicalUtilisation);
            hashMap.put("type", (Object)(this.type == null ? Types.VdiType.UNRECOGNIZED : this.type));
            hashMap.put("sharable", this.sharable == null ? false : this.sharable);
            hashMap.put("read_only", this.readOnly == null ? false : this.readOnly);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("storage_lock", this.storageLock == null ? false : this.storageLock);
            hashMap.put("location", this.location == null ? "" : this.location);
            hashMap.put("managed", this.managed == null ? false : this.managed);
            hashMap.put("missing", this.missing == null ? false : this.missing);
            hashMap.put("parent", this.parent == null ? new VDI("OpaqueRef:NULL") : this.parent);
            hashMap.put("xenstore_data", this.xenstoreData == null ? new HashMap() : this.xenstoreData);
            hashMap.put("sm_config", this.smConfig == null ? new HashMap() : this.smConfig);
            hashMap.put("is_a_snapshot", this.isASnapshot == null ? false : this.isASnapshot);
            hashMap.put("snapshot_of", this.snapshotOf == null ? new VDI("OpaqueRef:NULL") : this.snapshotOf);
            hashMap.put("snapshots", this.snapshots == null ? new LinkedHashSet() : this.snapshots);
            hashMap.put("snapshot_time", this.snapshotTime == null ? new Date(0L) : this.snapshotTime);
            hashMap.put("tags", this.tags == null ? new LinkedHashSet() : this.tags);
            return hashMap;
        }
    }
}

