/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.ptr.LongByReference;
import java.util.UUID;
import org.libvirt.CPUCompareResult;
import org.libvirt.ConnectAuth;
import org.libvirt.Device;
import org.libvirt.Domain;
import org.libvirt.ErrorHandler;
import org.libvirt.Interface;
import org.libvirt.LibvirtException;
import org.libvirt.Network;
import org.libvirt.NetworkFilter;
import org.libvirt.NodeInfo;
import org.libvirt.Secret;
import org.libvirt.StoragePool;
import org.libvirt.StorageVol;
import org.libvirt.Stream;
import org.libvirt.jna.ConnectionPointer;
import org.libvirt.jna.DevicePointer;
import org.libvirt.jna.DomainPointer;
import org.libvirt.jna.InterfacePointer;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.NetworkFilterPointer;
import org.libvirt.jna.NetworkPointer;
import org.libvirt.jna.SecretPointer;
import org.libvirt.jna.StoragePoolPointer;
import org.libvirt.jna.StorageVolPointer;
import org.libvirt.jna.StreamPointer;
import org.libvirt.jna.virConnectAuth;
import org.libvirt.jna.virNodeInfo;

public class Connect {
    protected ConnectionPointer VCP;
    Libvirt libvirt = Libvirt.INSTANCE;

    public static Connect connectionForDomain(Domain domain) {
        ConnectionPointer connectionPointer = Libvirt.INSTANCE.virDomainGetConnect(domain.VDP);
        return new Connect(connectionPointer);
    }

    public static Connect connectionForNetwork(Network network) {
        ConnectionPointer connectionPointer = Libvirt.INSTANCE.virNetworkGetConnect(network.VNP);
        return new Connect(connectionPointer);
    }

    public static Connect connectionForSecret(Secret secret) {
        ConnectionPointer connectionPointer = Libvirt.INSTANCE.virSecretGetConnect(secret.VSP);
        return new Connect(connectionPointer);
    }

    public static long connectionVersion(Connect connect) {
        LongByReference longByReference = new LongByReference();
        int n = Libvirt.INSTANCE.virConnectGetLibVersion(connect.VCP, longByReference);
        return n != -1 ? longByReference.getValue() : -1L;
    }

    public static int[] convertUUIDBytes(byte[] byArray) {
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static byte[] createUUIDBytes(int[] nArray) {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    public static void setErrorCallback(Libvirt.VirErrorCallback virErrorCallback) throws LibvirtException {
        Libvirt.INSTANCE.virSetErrorFunc(null, virErrorCallback);
        ErrorHandler.processError(Libvirt.INSTANCE);
    }

    Connect(ConnectionPointer connectionPointer) {
        this.VCP = connectionPointer;
    }

    @Deprecated
    Connect(long l) {
        throw new RuntimeException("No longer supported");
    }

    public Connect(String string) throws LibvirtException {
        this.VCP = this.libvirt.virConnectOpen(string);
        this.processError();
        ErrorHandler.processError(Libvirt.INSTANCE);
    }

    public Connect(String string, boolean bl) throws LibvirtException {
        this.VCP = bl ? this.libvirt.virConnectOpenReadOnly(string) : this.libvirt.virConnectOpen(string);
        this.processError();
        ErrorHandler.processError(Libvirt.INSTANCE);
    }

    public Connect(String string, ConnectAuth connectAuth, int n) throws LibvirtException {
        virConnectAuth virConnectAuth2 = new virConnectAuth();
        virConnectAuth2.cb = connectAuth;
        virConnectAuth2.cbdata = null;
        virConnectAuth2.ncredtype = connectAuth.credType.length;
        int[] nArray = new int[virConnectAuth2.ncredtype];
        for (int i = 0; i < virConnectAuth2.ncredtype; ++i) {
            nArray[i] = connectAuth.credType[i].mapToInt();
        }
        Memory memory = new Memory((long)(4 * virConnectAuth2.ncredtype));
        memory.write(0L, nArray, 0, virConnectAuth2.ncredtype);
        virConnectAuth2.credtype = memory.share(0L);
        this.VCP = this.libvirt.virConnectOpenAuth(string, virConnectAuth2, n);
        this.processError();
        ErrorHandler.processError(Libvirt.INSTANCE);
    }

    public String baselineCPU(String[] stringArray) throws LibvirtException {
        String string = this.libvirt.virConnectBaselineCPU(this.VCP, stringArray, stringArray.length, 0);
        this.processError();
        return string;
    }

    public int close() throws LibvirtException {
        int n = 0;
        if (this.VCP != null) {
            n = this.libvirt.virConnectClose(this.VCP);
            this.processError();
            this.VCP = null;
        }
        return n;
    }

    public CPUCompareResult compareCPU(String string) throws LibvirtException {
        int n = this.libvirt.virConnectCompareCPU(this.VCP, string, 0);
        this.processError();
        return CPUCompareResult.get(n);
    }

    public Device deviceCreateXML(String string) throws LibvirtException {
        Device device = null;
        DevicePointer devicePointer = this.libvirt.virNodeDeviceCreateXML(this.VCP, string, 0);
        this.processError();
        if (devicePointer != null) {
            device = new Device(this, devicePointer);
        }
        return device;
    }

    public Device deviceLookupByName(String string) throws LibvirtException {
        DevicePointer devicePointer = this.libvirt.virNodeDeviceLookupByName(this.VCP, string);
        this.processError();
        return new Device(this, devicePointer);
    }

    public Domain domainCreateLinux(String string, int n) throws LibvirtException {
        Domain domain = null;
        DomainPointer domainPointer = this.libvirt.virDomainCreateLinux(this.VCP, string, n);
        this.processError();
        if (domainPointer != null) {
            domain = new Domain(this, domainPointer);
        }
        return domain;
    }

    public Domain domainCreateXML(String string, int n) throws LibvirtException {
        Domain domain = null;
        DomainPointer domainPointer = this.libvirt.virDomainCreateXML(this.VCP, string, n);
        this.processError();
        if (domainPointer != null) {
            domain = new Domain(this, domainPointer);
        }
        return domain;
    }

    public Domain domainDefineXML(String string) throws LibvirtException {
        Domain domain = null;
        DomainPointer domainPointer = this.libvirt.virDomainDefineXML(this.VCP, string);
        this.processError();
        if (domainPointer != null) {
            domain = new Domain(this, domainPointer);
        }
        return domain;
    }

    public int domainEventDeregisterAny(int n) throws LibvirtException {
        int n2 = this.libvirt.virConnectDomainEventDeregisterAny(this.VCP, n);
        this.processError();
        return n2;
    }

    public int domainEventRegisterAny(Domain domain, int n, Libvirt.VirConnectDomainEventGenericCallback virConnectDomainEventGenericCallback) throws LibvirtException {
        DomainPointer domainPointer = domain == null ? null : domain.VDP;
        int n2 = this.libvirt.virConnectDomainEventRegisterAny(this.VCP, domainPointer, n, virConnectDomainEventGenericCallback, null, null);
        this.processError();
        return n2;
    }

    public Domain domainLookupByID(int n) throws LibvirtException {
        Domain domain = null;
        DomainPointer domainPointer = this.libvirt.virDomainLookupByID(this.VCP, n);
        this.processError();
        if (domainPointer != null) {
            domain = new Domain(this, domainPointer);
        }
        return domain;
    }

    public Domain domainLookupByName(String string) throws LibvirtException {
        Domain domain = null;
        DomainPointer domainPointer = this.libvirt.virDomainLookupByName(this.VCP, string);
        this.processError();
        if (domainPointer != null) {
            domain = new Domain(this, domainPointer);
        }
        return domain;
    }

    public Domain domainLookupByUUID(int[] nArray) throws LibvirtException {
        byte[] byArray = Connect.createUUIDBytes(nArray);
        Domain domain = null;
        DomainPointer domainPointer = this.libvirt.virDomainLookupByUUID(this.VCP, byArray);
        this.processError();
        if (domainPointer != null) {
            domain = new Domain(this, domainPointer);
        }
        return domain;
    }

    public Domain domainLookupByUUID(UUID uUID) throws LibvirtException {
        return this.domainLookupByUUIDString(uUID.toString());
    }

    public Domain domainLookupByUUIDString(String string) throws LibvirtException {
        Domain domain = null;
        DomainPointer domainPointer = this.libvirt.virDomainLookupByUUIDString(this.VCP, string);
        this.processError();
        if (domainPointer != null) {
            domain = new Domain(this, domainPointer);
        }
        return domain;
    }

    public String domainXMLFromNative(String string, String string2, int n) throws LibvirtException {
        String string3 = this.libvirt.virConnectDomainXMLFromNative(this.VCP, string, string2, 0);
        this.processError();
        return string3;
    }

    public String domainXMLToNative(String string, String string2, int n) throws LibvirtException {
        String string3 = this.libvirt.virConnectDomainXMLToNative(this.VCP, string, string2, 0);
        this.processError();
        return string3;
    }

    public void finalize() throws LibvirtException {
        this.close();
    }

    public String findStoragePoolSources(String string, String string2, int n) throws LibvirtException {
        String string3 = this.libvirt.virConnectFindStoragePoolSources(this.VCP, string, string2, n);
        this.processError();
        return string3;
    }

    public String getCapabilities() throws LibvirtException {
        String string = this.libvirt.virConnectGetCapabilities(this.VCP);
        this.processError();
        return string;
    }

    public long getCellsFreeMemory(int n, int n2) throws LibvirtException {
        LongByReference longByReference = new LongByReference();
        this.libvirt.virNodeGetCellsFreeMemory(this.VCP, longByReference, n, n2);
        this.processError();
        return longByReference.getValue();
    }

    public long getFreeMemory() throws LibvirtException {
        long l = 0L;
        l = this.libvirt.virNodeGetFreeMemory(this.VCP);
        this.processError();
        return l;
    }

    public String getHostName() throws LibvirtException {
        String string = this.libvirt.virConnectGetHostname(this.VCP);
        this.processError();
        return string;
    }

    public long getHypervisorVersion(String string) throws LibvirtException {
        LongByReference longByReference = new LongByReference();
        LongByReference longByReference2 = new LongByReference();
        this.libvirt.virGetVersion(longByReference, string, longByReference2);
        this.processError();
        return longByReference.getValue();
    }

    public long getLibVirVersion() throws LibvirtException {
        LongByReference longByReference = new LongByReference();
        LongByReference longByReference2 = new LongByReference();
        this.libvirt.virGetVersion(longByReference, null, longByReference2);
        this.processError();
        return longByReference.getValue();
    }

    public int getMaxVcpus(String string) throws LibvirtException {
        int n = this.libvirt.virConnectGetMaxVcpus(this.VCP, string);
        this.processError();
        return n;
    }

    public String getType() throws LibvirtException {
        String string = this.libvirt.virConnectGetType(this.VCP);
        this.processError();
        return string;
    }

    public String getURI() throws LibvirtException {
        String string = this.libvirt.virConnectGetURI(this.VCP);
        this.processError();
        return string;
    }

    public long getVersion() throws LibvirtException {
        LongByReference longByReference = new LongByReference();
        this.libvirt.virConnectGetVersion(this.VCP, longByReference);
        this.processError();
        return longByReference.getValue();
    }

    public Interface interfaceDefineXML(String string) throws LibvirtException {
        Interface interface_ = null;
        InterfacePointer interfacePointer = this.libvirt.virInterfaceDefineXML(this.VCP, string, 0);
        this.processError();
        if (interfacePointer != null) {
            interface_ = new Interface(this, interfacePointer);
        }
        return interface_;
    }

    public Interface interfaceLookupByMACString(String string) throws LibvirtException {
        Interface interface_ = null;
        InterfacePointer interfacePointer = this.libvirt.virInterfaceLookupByMACString(this.VCP, string);
        this.processError();
        if (interfacePointer != null) {
            interface_ = new Interface(this, interfacePointer);
        }
        return interface_;
    }

    public Interface interfaceLookupByName(String string) throws LibvirtException {
        Interface interface_ = null;
        InterfacePointer interfacePointer = this.libvirt.virInterfaceLookupByName(this.VCP, string);
        this.processError();
        if (interfacePointer != null) {
            interface_ = new Interface(this, interfacePointer);
        }
        return interface_;
    }

    public int isEncrypted() throws LibvirtException {
        int n = this.libvirt.virConnectIsEncrypted(this.VCP);
        this.processError();
        return n;
    }

    public int isSecure() throws LibvirtException {
        int n = this.libvirt.virConnectIsSecure(this.VCP);
        this.processError();
        return n;
    }

    public String[] listDefinedDomains() throws LibvirtException {
        int n = this.numOfDefinedDomains();
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virConnectListDefinedDomains(this.VCP, stringArray, n);
            this.processError();
        }
        return stringArray;
    }

    public String[] listDefinedInterfaces() throws LibvirtException {
        int n = this.numOfDefinedInterfaces();
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virConnectListDefinedInterfaces(this.VCP, stringArray, n);
            this.processError();
        }
        return stringArray;
    }

    public String[] listDefinedNetworks() throws LibvirtException {
        int n = this.numOfDefinedNetworks();
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virConnectListDefinedNetworks(this.VCP, stringArray, n);
            this.processError();
        }
        return stringArray;
    }

    public String[] listDefinedStoragePools() throws LibvirtException {
        int n = this.numOfDefinedStoragePools();
        String[] stringArray = new String[n];
        this.libvirt.virConnectListDefinedStoragePools(this.VCP, stringArray, n);
        this.processError();
        return stringArray;
    }

    public String[] listDevices(String string) throws LibvirtException {
        int n = this.numOfDevices(string);
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virNodeListDevices(this.VCP, string, stringArray, n, 0);
            this.processError();
        }
        return stringArray;
    }

    public int[] listDomains() throws LibvirtException {
        int n = this.numOfDomains();
        int[] nArray = new int[n];
        if (n > 0) {
            this.libvirt.virConnectListDomains(this.VCP, nArray, n);
            this.processError();
        }
        return nArray;
    }

    public String[] listInterfaces() throws LibvirtException {
        int n = this.numOfInterfaces();
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virConnectListInterfaces(this.VCP, stringArray, n);
            this.processError();
        }
        return stringArray;
    }

    public String[] listNetworkFilters() throws LibvirtException {
        int n = this.numOfNetworkFilters();
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virConnectListNWFilters(this.VCP, stringArray, n);
            this.processError();
        }
        return stringArray;
    }

    public String[] listNetworks() throws LibvirtException {
        int n = this.numOfNetworks();
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virConnectListNetworks(this.VCP, stringArray, n);
            this.processError();
        }
        return stringArray;
    }

    public String[] listSecrets() throws LibvirtException {
        int n = this.numOfSecrets();
        String[] stringArray = new String[n];
        this.libvirt.virConnectListSecrets(this.VCP, stringArray, n);
        this.processError();
        return stringArray;
    }

    public String[] listStoragePools() throws LibvirtException {
        int n = this.numOfStoragePools();
        String[] stringArray = new String[n];
        this.libvirt.virConnectListStoragePools(this.VCP, stringArray, n);
        this.processError();
        return stringArray;
    }

    public Network networkCreateXML(String string) throws LibvirtException {
        Network network = null;
        NetworkPointer networkPointer = this.libvirt.virNetworkCreateXML(this.VCP, string);
        this.processError();
        if (networkPointer != null) {
            network = new Network(this, networkPointer);
        }
        return network;
    }

    public Network networkDefineXML(String string) throws LibvirtException {
        Network network = null;
        NetworkPointer networkPointer = this.libvirt.virNetworkDefineXML(this.VCP, string);
        this.processError();
        if (networkPointer != null) {
            network = new Network(this, networkPointer);
        }
        return network;
    }

    public NetworkFilter networkFilterDefineXML(String string) throws LibvirtException {
        NetworkFilter networkFilter = null;
        NetworkFilterPointer networkFilterPointer = this.libvirt.virNWFilterDefineXML(this.VCP, string);
        this.processError();
        if (networkFilterPointer != null) {
            networkFilter = new NetworkFilter(this, networkFilterPointer);
        }
        return networkFilter;
    }

    public NetworkFilter networkFilterLookupByName(String string) throws LibvirtException {
        NetworkFilter networkFilter = null;
        NetworkFilterPointer networkFilterPointer = this.libvirt.virNWFilterLookupByName(this.VCP, string);
        this.processError();
        if (networkFilterPointer != null) {
            networkFilter = new NetworkFilter(this, networkFilterPointer);
        }
        return networkFilter;
    }

    public NetworkFilter networkFilterLookupByUUID(int[] nArray) throws LibvirtException {
        byte[] byArray = Connect.createUUIDBytes(nArray);
        NetworkFilter networkFilter = null;
        NetworkFilterPointer networkFilterPointer = this.libvirt.virNWFilterLookupByUUID(this.VCP, byArray);
        this.processError();
        if (networkFilterPointer != null) {
            networkFilter = new NetworkFilter(this, networkFilterPointer);
        }
        return networkFilter;
    }

    public NetworkFilter networkFilterLookupByUUID(UUID uUID) throws LibvirtException {
        return this.networkFilterLookupByUUIDString(uUID.toString());
    }

    public NetworkFilter networkFilterLookupByUUIDString(String string) throws LibvirtException {
        NetworkFilter networkFilter = null;
        NetworkFilterPointer networkFilterPointer = this.libvirt.virNWFilterLookupByUUIDString(this.VCP, string);
        this.processError();
        if (networkFilterPointer != null) {
            networkFilter = new NetworkFilter(this, networkFilterPointer);
        }
        return networkFilter;
    }

    public Network networkLookupByName(String string) throws LibvirtException {
        Network network = null;
        NetworkPointer networkPointer = this.libvirt.virNetworkLookupByName(this.VCP, string);
        this.processError();
        if (networkPointer != null) {
            network = new Network(this, networkPointer);
        }
        return network;
    }

    @Deprecated
    public Network networkLookupByUUID(int[] nArray) throws LibvirtException {
        byte[] byArray = Connect.createUUIDBytes(nArray);
        Network network = null;
        NetworkPointer networkPointer = this.libvirt.virNetworkLookupByUUID(this.VCP, byArray);
        this.processError();
        if (networkPointer != null) {
            network = new Network(this, networkPointer);
        }
        return network;
    }

    public Network networkLookupByUUID(UUID uUID) throws LibvirtException {
        return this.networkLookupByUUIDString(uUID.toString());
    }

    public Network networkLookupByUUIDString(String string) throws LibvirtException {
        Network network = null;
        NetworkPointer networkPointer = this.libvirt.virNetworkLookupByUUIDString(this.VCP, string);
        this.processError();
        if (networkPointer != null) {
            network = new Network(this, networkPointer);
        }
        return network;
    }

    public NodeInfo nodeInfo() throws LibvirtException {
        virNodeInfo virNodeInfo2 = new virNodeInfo();
        this.libvirt.virNodeGetInfo(this.VCP, virNodeInfo2);
        this.processError();
        return new NodeInfo(virNodeInfo2);
    }

    public int numOfDefinedDomains() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfDefinedDomains(this.VCP);
        this.processError();
        return n;
    }

    public int numOfDefinedInterfaces() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfDefinedInterfaces(this.VCP);
        this.processError();
        return n;
    }

    public int numOfDefinedNetworks() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfDefinedNetworks(this.VCP);
        this.processError();
        return n;
    }

    public int numOfDefinedStoragePools() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfDefinedStoragePools(this.VCP);
        this.processError();
        return n;
    }

    public int numOfDevices(String string) throws LibvirtException {
        int n = this.libvirt.virNodeNumOfDevices(this.VCP, string, 0);
        this.processError();
        return n;
    }

    public int numOfDomains() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfDomains(this.VCP);
        this.processError();
        return n;
    }

    public int numOfInterfaces() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfInterfaces(this.VCP);
        this.processError();
        return n;
    }

    public int numOfNetworkFilters() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfNWFilters(this.VCP);
        this.processError();
        return n;
    }

    public int numOfNetworks() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfNetworks(this.VCP);
        this.processError();
        return n;
    }

    public int numOfSecrets() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfSecrets(this.VCP);
        this.processError();
        return n;
    }

    public int numOfStoragePools() throws LibvirtException {
        int n = this.libvirt.virConnectNumOfStoragePools(this.VCP);
        this.processError();
        return n;
    }

    protected void processError() throws LibvirtException {
        ErrorHandler.processError(this.libvirt, this.VCP);
    }

    public void restore(String string) throws LibvirtException {
        this.libvirt.virDomainRestore(this.VCP, string);
        this.processError();
    }

    public Secret secretDefineXML(String string) throws LibvirtException {
        Secret secret = null;
        SecretPointer secretPointer = this.libvirt.virSecretDefineXML(this.VCP, string, 0);
        this.processError();
        if (secretPointer != null) {
            secret = new Secret(this, secretPointer);
        }
        return secret;
    }

    public Secret secretLookupByUUID(int[] nArray) throws LibvirtException {
        byte[] byArray = Connect.createUUIDBytes(nArray);
        Secret secret = null;
        SecretPointer secretPointer = this.libvirt.virSecretLookupByUUID(this.VCP, byArray);
        this.processError();
        if (secretPointer != null) {
            secret = new Secret(this, secretPointer);
        }
        return secret;
    }

    public Secret secretLookupByUUID(UUID uUID) throws LibvirtException {
        return this.secretLookupByUUIDString(uUID.toString());
    }

    public Secret secretLookupByUUIDString(String string) throws LibvirtException {
        Secret secret = null;
        SecretPointer secretPointer = this.libvirt.virSecretLookupByUUIDString(this.VCP, string);
        this.processError();
        if (secretPointer != null) {
            secret = new Secret(this, secretPointer);
        }
        return secret;
    }

    public void setConnectionErrorCallback(Libvirt.VirErrorCallback virErrorCallback) throws LibvirtException {
        this.libvirt.virConnSetErrorFunc(this.VCP, null, virErrorCallback);
        this.processError();
    }

    public void setDom0Memory(long l) throws LibvirtException {
        this.libvirt.virDomainSetMemory(null, new NativeLong(l));
        this.processError();
    }

    public StoragePool storagePoolCreateXML(String string, int n) throws LibvirtException {
        StoragePoolPointer storagePoolPointer = this.libvirt.virStoragePoolCreateXML(this.VCP, string, n);
        this.processError();
        return new StoragePool(this, storagePoolPointer);
    }

    public StoragePool storagePoolDefineXML(String string, int n) throws LibvirtException {
        StoragePoolPointer storagePoolPointer = this.libvirt.virStoragePoolDefineXML(this.VCP, string, n);
        this.processError();
        return new StoragePool(this, storagePoolPointer);
    }

    public StoragePool storagePoolLookupByName(String string) throws LibvirtException {
        StoragePoolPointer storagePoolPointer = this.libvirt.virStoragePoolLookupByName(this.VCP, string);
        this.processError();
        return new StoragePool(this, storagePoolPointer);
    }

    @Deprecated
    public StoragePool storagePoolLookupByUUID(int[] nArray) throws LibvirtException {
        byte[] byArray = Connect.createUUIDBytes(nArray);
        StoragePool storagePool = null;
        StoragePoolPointer storagePoolPointer = this.libvirt.virStoragePoolLookupByUUID(this.VCP, byArray);
        this.processError();
        if (storagePoolPointer != null) {
            storagePool = new StoragePool(this, storagePoolPointer);
        }
        return storagePool;
    }

    public StoragePool storagePoolLookupByUUID(UUID uUID) throws LibvirtException {
        return this.storagePoolLookupByUUIDString(uUID.toString());
    }

    public StoragePool storagePoolLookupByUUIDString(String string) throws LibvirtException {
        StoragePool storagePool = null;
        StoragePoolPointer storagePoolPointer = this.libvirt.virStoragePoolLookupByUUIDString(this.VCP, string);
        this.processError();
        if (storagePoolPointer != null) {
            storagePool = new StoragePool(this, storagePoolPointer);
        }
        return storagePool;
    }

    public StorageVol storageVolLookupByKey(String string) throws LibvirtException {
        StorageVolPointer storageVolPointer = this.libvirt.virStorageVolLookupByKey(this.VCP, string);
        this.processError();
        return new StorageVol(this, storageVolPointer);
    }

    public StorageVol storageVolLookupByPath(String string) throws LibvirtException {
        StorageVolPointer storageVolPointer = this.libvirt.virStorageVolLookupByPath(this.VCP, string);
        this.processError();
        return new StorageVol(this, storageVolPointer);
    }

    public Stream streamNew(int n) throws LibvirtException {
        StreamPointer streamPointer = this.libvirt.virStreamNew(this.VCP, n);
        this.processError();
        return new Stream(this, streamPointer);
    }

    public boolean isConnected() throws LibvirtException {
        return this.VCP != null;
    }

    static {
        Libvirt.INSTANCE.virInitialize();
        try {
            ErrorHandler.processError(Libvirt.INSTANCE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

