/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.libvirt.ConnectAuth;

public final class ConnectAuthDefault
extends ConnectAuth {
    public ConnectAuthDefault() {
        this.credType = new ConnectAuth.CredentialType[]{ConnectAuth.CredentialType.VIR_CRED_AUTHNAME, ConnectAuth.CredentialType.VIR_CRED_ECHOPROMPT, ConnectAuth.CredentialType.VIR_CRED_REALM, ConnectAuth.CredentialType.VIR_CRED_PASSPHRASE, ConnectAuth.CredentialType.VIR_CRED_NOECHOPROMPT};
    }

    @Override
    public int callback(ConnectAuth.Credential[] credentialArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            for (ConnectAuth.Credential credential : credentialArray) {
                String string = "";
                switch (credential.type) {
                    case VIR_CRED_USERNAME: 
                    case VIR_CRED_AUTHNAME: 
                    case VIR_CRED_ECHOPROMPT: 
                    case VIR_CRED_REALM: {
                        System.out.println(credential.prompt);
                        string = bufferedReader.readLine();
                        break;
                    }
                    case VIR_CRED_PASSPHRASE: 
                    case VIR_CRED_NOECHOPROMPT: {
                        System.out.println(credential.prompt);
                        System.out.println("WARNING: THE ENTERED PASSWORD WILL NOT BE MASKED!");
                        string = bufferedReader.readLine();
                    }
                }
                credential.result = string.equals("") && !credential.defresult.equals("") ? credential.defresult : string;
                if (!credential.result.equals("")) continue;
                return -1;
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }
}

