/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.jna.DevicePointer;
import org.libvirt.jna.Libvirt;

public class Device {
    DevicePointer VDP;
    private Connect virConnect;
    protected Libvirt libvirt;

    Device(Connect connect, DevicePointer devicePointer) {
        this.virConnect = connect;
        this.VDP = devicePointer;
        this.libvirt = connect.libvirt;
    }

    public int destroy() throws LibvirtException {
        int n = 0;
        if (this.VDP != null) {
            n = this.libvirt.virNodeDeviceDestroy(this.VDP);
            this.processError();
            this.VDP = null;
        }
        return n;
    }

    public int detach() throws LibvirtException {
        int n = this.libvirt.virNodeDeviceDettach(this.VDP);
        this.processError();
        return n;
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VDP != null) {
            n = this.libvirt.virNodeDeviceFree(this.VDP);
            this.processError();
            this.VDP = null;
        }
        return n;
    }

    public String getName() throws LibvirtException {
        String string = this.libvirt.virNodeDeviceGetName(this.VDP);
        this.processError();
        return string;
    }

    public int getNumberOfCapabilities() throws LibvirtException {
        int n = this.libvirt.virNodeDeviceNumOfCaps(this.VDP);
        this.processError();
        return n;
    }

    public String getParent() throws LibvirtException {
        String string = this.libvirt.virNodeDeviceGetParent(this.VDP);
        this.processError();
        return string;
    }

    public String getXMLDescription() throws LibvirtException {
        String string = this.libvirt.virNodeDeviceGetXMLDesc(this.VDP);
        this.processError();
        return string;
    }

    public String[] listCapabilities() throws LibvirtException {
        int n = this.getNumberOfCapabilities();
        String[] stringArray = new String[n];
        if (n > 0) {
            this.libvirt.virNodeDeviceListCaps(this.VDP, stringArray, n);
            this.processError();
        }
        return stringArray;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public int reAttach() throws LibvirtException {
        int n = this.libvirt.virNodeDeviceReAttach(this.VDP);
        this.processError();
        return n;
    }

    public int reset() throws LibvirtException {
        int n = this.libvirt.virNodeDeviceReset(this.VDP);
        this.processError();
        return n;
    }
}

