/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.ptr.IntByReference;
import org.libvirt.Connect;
import org.libvirt.DomainBlockInfo;
import org.libvirt.DomainBlockStats;
import org.libvirt.DomainInfo;
import org.libvirt.DomainInterfaceStats;
import org.libvirt.DomainJobInfo;
import org.libvirt.DomainSnapshot;
import org.libvirt.LibvirtException;
import org.libvirt.MemoryStatistic;
import org.libvirt.NodeInfo;
import org.libvirt.SchedParameter;
import org.libvirt.VcpuInfo;
import org.libvirt.jna.DomainPointer;
import org.libvirt.jna.DomainSnapshotPointer;
import org.libvirt.jna.Libvirt;
import org.libvirt.jna.virDomainBlockInfo;
import org.libvirt.jna.virDomainBlockStats;
import org.libvirt.jna.virDomainInfo;
import org.libvirt.jna.virDomainInterfaceStats;
import org.libvirt.jna.virDomainJobInfo;
import org.libvirt.jna.virDomainMemoryStats;
import org.libvirt.jna.virSchedParameter;
import org.libvirt.jna.virVcpuInfo;

public class Domain {
    DomainPointer VDP;
    private Connect virConnect;
    protected Libvirt libvirt;

    Domain(Connect connect, DomainPointer domainPointer) {
        this.virConnect = connect;
        this.VDP = domainPointer;
        this.libvirt = connect.libvirt;
    }

    public int abortJob() throws LibvirtException {
        int n = this.libvirt.virDomainAbortJob(this.VDP);
        this.processError();
        return n;
    }

    public void attachDevice(String string) throws LibvirtException {
        this.libvirt.virDomainAttachDevice(this.VDP, string);
        this.processError();
    }

    public void attachDeviceFlags(String string, int n) throws LibvirtException {
        this.libvirt.virDomainAttachDeviceFlags(this.VDP, string, n);
        this.processError();
    }

    public DomainBlockInfo blockInfo(String string) throws LibvirtException {
        virDomainBlockInfo virDomainBlockInfo2 = new virDomainBlockInfo();
        int n = this.libvirt.virDomainGetBlockInfo(this.VDP, string, virDomainBlockInfo2, 0);
        this.processError();
        return n == 0 ? new DomainBlockInfo(virDomainBlockInfo2) : null;
    }

    public DomainBlockStats blockStats(String string) throws LibvirtException {
        virDomainBlockStats virDomainBlockStats2 = new virDomainBlockStats();
        int n = this.libvirt.virDomainBlockStats(this.VDP, string, virDomainBlockStats2, virDomainBlockStats2.size());
        this.processError();
        return n == 0 ? new DomainBlockStats(virDomainBlockStats2) : null;
    }

    public void coreDump(String string, int n) throws LibvirtException {
        this.libvirt.virDomainCoreDump(this.VDP, string, n);
        this.processError();
    }

    public int cpuMapLength(int n) {
        return (n + 7) / 8;
    }

    public int create() throws LibvirtException {
        int n = this.libvirt.virDomainCreate(this.VDP);
        this.processError();
        return n;
    }

    public int create(int n) throws LibvirtException {
        int n2 = this.libvirt.virDomainCreateWithFlags(this.VDP, n);
        this.processError();
        return n2;
    }

    public void destroy() throws LibvirtException {
        this.libvirt.virDomainDestroy(this.VDP);
        this.processError();
    }

    public void detachDevice(String string) throws LibvirtException {
        this.libvirt.virDomainDetachDevice(this.VDP, string);
        this.processError();
    }

    public void detachDeviceFlags(String string, int n) throws LibvirtException {
        this.libvirt.virDomainDetachDeviceFlags(this.VDP, string, n);
        this.processError();
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VDP != null) {
            n = this.libvirt.virDomainFree(this.VDP);
            this.processError();
            this.VDP = null;
        }
        return n;
    }

    public boolean getAutostart() throws LibvirtException {
        IntByReference intByReference = new IntByReference();
        this.libvirt.virDomainGetAutostart(this.VDP, intByReference);
        this.processError();
        return intByReference.getValue() != 0;
    }

    public Connect getConnect() {
        return this.virConnect;
    }

    public int getID() throws LibvirtException {
        int n = this.libvirt.virDomainGetID(this.VDP);
        this.processError();
        return n;
    }

    public DomainInfo getInfo() throws LibvirtException {
        DomainInfo domainInfo = null;
        virDomainInfo virDomainInfo2 = new virDomainInfo();
        int n = this.libvirt.virDomainGetInfo(this.VDP, virDomainInfo2);
        this.processError();
        if (n == 0) {
            domainInfo = new DomainInfo(virDomainInfo2);
        }
        return domainInfo;
    }

    public DomainJobInfo getJobInfo() throws LibvirtException {
        DomainJobInfo domainJobInfo = null;
        virDomainJobInfo virDomainJobInfo2 = new virDomainJobInfo();
        int n = this.libvirt.virDomainGetJobInfo(this.VDP, virDomainJobInfo2);
        this.processError();
        if (n == 0) {
            domainJobInfo = new DomainJobInfo(virDomainJobInfo2);
        }
        return domainJobInfo;
    }

    public long getMaxMemory() throws LibvirtException {
        NativeLong nativeLong = this.libvirt.virDomainGetMaxMemory(this.VDP);
        this.processError();
        return nativeLong.longValue();
    }

    public int getMaxVcpus() throws LibvirtException {
        int n = this.libvirt.virDomainGetMaxVcpus(this.VDP);
        this.processError();
        return n;
    }

    public String getName() throws LibvirtException {
        String string = this.libvirt.virDomainGetName(this.VDP);
        this.processError();
        return string;
    }

    public String getOSType() throws LibvirtException {
        String string = this.libvirt.virDomainGetOSType(this.VDP);
        this.processError();
        return string;
    }

    public SchedParameter[] getSchedulerParameters() throws LibvirtException {
        IntByReference intByReference = new IntByReference();
        SchedParameter[] schedParameterArray = new SchedParameter[]{};
        String string = this.libvirt.virDomainGetSchedulerType(this.VDP, intByReference);
        this.processError();
        if (string != null) {
            virSchedParameter[] virSchedParameterArray = new virSchedParameter[intByReference.getValue()];
            schedParameterArray = new SchedParameter[intByReference.getValue()];
            this.libvirt.virDomainGetSchedulerParameters(this.VDP, virSchedParameterArray, intByReference);
            this.processError();
            for (int i = 0; i < intByReference.getValue(); ++i) {
                schedParameterArray[i] = SchedParameter.create(virSchedParameterArray[i]);
            }
        }
        return schedParameterArray;
    }

    public String[] getSchedulerType() throws LibvirtException {
        IntByReference intByReference = new IntByReference();
        String string = this.libvirt.virDomainGetSchedulerType(this.VDP, intByReference);
        this.processError();
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    public int[] getUUID() throws LibvirtException {
        byte[] byArray = new byte[16];
        int n = this.libvirt.virDomainGetUUID(this.VDP, byArray);
        this.processError();
        int[] nArray = new int[]{};
        if (n == 0) {
            nArray = Connect.convertUUIDBytes(byArray);
        }
        return nArray;
    }

    public String getUUIDString() throws LibvirtException {
        byte[] byArray = new byte[37];
        int n = this.libvirt.virDomainGetUUIDString(this.VDP, byArray);
        this.processError();
        String string = null;
        if (n == 0) {
            string = Native.toString((byte[])byArray);
        }
        return string;
    }

    public int[] getVcpusCpuMaps() throws LibvirtException {
        int[] nArray = new int[]{};
        int n = this.getMaxVcpus();
        if (n > 0) {
            NodeInfo nodeInfo = this.virConnect.nodeInfo();
            int n2 = this.cpuMapLength(nodeInfo.maxCpus());
            virVcpuInfo[] virVcpuInfoArray = new virVcpuInfo[n];
            nArray = new int[n * n2];
            byte[] byArray = new byte[n * n2];
            this.libvirt.virDomainGetVcpus(this.VDP, virVcpuInfoArray, n, byArray, n2);
            this.processError();
            for (int i = 0; i < n * n2; ++i) {
                nArray[i] = byArray[i];
            }
        }
        return nArray;
    }

    public VcpuInfo[] getVcpusInfo() throws LibvirtException {
        int n = this.getMaxVcpus();
        VcpuInfo[] vcpuInfoArray = new VcpuInfo[n];
        virVcpuInfo[] virVcpuInfoArray = new virVcpuInfo[n];
        this.libvirt.virDomainGetVcpus(this.VDP, virVcpuInfoArray, n, null, 0);
        this.processError();
        for (int i = 0; i < n; ++i) {
            vcpuInfoArray[i] = new VcpuInfo(virVcpuInfoArray[i]);
        }
        return vcpuInfoArray;
    }

    public String getXMLDesc(int n) throws LibvirtException {
        String string = this.libvirt.virDomainGetXMLDesc(this.VDP, n);
        this.processError();
        return string;
    }

    public int hasCurrentSnapshot() throws LibvirtException {
        int n = this.libvirt.virDomainHasCurrentSnapshot(this.VDP, 0);
        this.processError();
        return n;
    }

    public int hasManagedSaveImage() throws LibvirtException {
        int n = this.libvirt.virDomainHasManagedSaveImage(this.VDP, 0);
        this.processError();
        return n;
    }

    public DomainInterfaceStats interfaceStats(String string) throws LibvirtException {
        virDomainInterfaceStats virDomainInterfaceStats2 = new virDomainInterfaceStats();
        this.libvirt.virDomainInterfaceStats(this.VDP, string, virDomainInterfaceStats2, virDomainInterfaceStats2.size());
        this.processError();
        return new DomainInterfaceStats(virDomainInterfaceStats2);
    }

    public int isActive() throws LibvirtException {
        int n = this.libvirt.virDomainIsActive(this.VDP);
        this.processError();
        return n;
    }

    public int isPersistent() throws LibvirtException {
        int n = this.libvirt.virDomainIsPersistent(this.VDP);
        this.processError();
        return n;
    }

    public int managedSave() throws LibvirtException {
        int n = this.libvirt.virDomainManagedSave(this.VDP, 0);
        this.processError();
        return n;
    }

    public int managedSaveRemote() throws LibvirtException {
        int n = this.libvirt.virDomainManagedSaveRemove(this.VDP, 0);
        this.processError();
        return n;
    }

    public MemoryStatistic[] memoryStats(int n) throws LibvirtException {
        virDomainMemoryStats[] virDomainMemoryStatsArray = new virDomainMemoryStats[n];
        MemoryStatistic[] memoryStatisticArray = null;
        int n2 = this.libvirt.virDomainMemoryStats(this.VDP, virDomainMemoryStatsArray, n, 0);
        this.processError();
        if (n2 >= 0) {
            memoryStatisticArray = new MemoryStatistic[n2];
            for (int i = 0; i < n2; ++i) {
                memoryStatisticArray[i] = new MemoryStatistic(virDomainMemoryStatsArray[i]);
            }
        }
        return memoryStatisticArray;
    }

    public Domain migrate(Connect connect, long l, String string, String string2, long l2) throws LibvirtException {
        DomainPointer domainPointer = this.libvirt.virDomainMigrate(this.VDP, connect.VCP, new NativeLong(l), string, string2, new NativeLong(l2));
        this.processError();
        return new Domain(connect, domainPointer);
    }

    public int migrateSetMaxDowntime(long l) throws LibvirtException {
        int n = this.libvirt.virDomainMigrateSetMaxDowntime(this.VDP, l, 0);
        this.processError();
        return n;
    }

    public int migrateToURI(String string, long l, String string2, long l2) throws LibvirtException {
        int n = this.libvirt.virDomainMigrateToURI(this.VDP, string, new NativeLong(l), string2, new NativeLong(l2));
        this.processError();
        return n;
    }

    public void pinVcpu(int n, int[] nArray) throws LibvirtException {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        this.libvirt.virDomainPinVcpu(this.VDP, n, byArray, nArray.length);
        this.processError();
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }

    public void reboot(int n) throws LibvirtException {
        this.libvirt.virDomainReboot(this.VDP, n);
        this.processError();
    }

    public void resume() throws LibvirtException {
        this.libvirt.virDomainResume(this.VDP);
        this.processError();
    }

    public int revertToSnapshot(DomainSnapshot domainSnapshot) throws LibvirtException {
        int n = this.libvirt.virDomainRevertToSnapshot(domainSnapshot.VDSP, 0);
        this.processError();
        return n;
    }

    public void save(String string) throws LibvirtException {
        this.libvirt.virDomainSave(this.VDP, string);
        this.processError();
    }

    public void setAutostart(boolean bl) throws LibvirtException {
        int n = bl ? 1 : 0;
        this.libvirt.virDomainSetAutostart(this.VDP, n);
        this.processError();
    }

    public void setMaxMemory(long l) throws LibvirtException {
        this.libvirt.virDomainSetMaxMemory(this.VDP, new NativeLong(l));
        this.processError();
    }

    public void setMemory(long l) throws LibvirtException {
        this.libvirt.virDomainSetMemory(this.VDP, new NativeLong(l));
        this.processError();
    }

    public void setSchedulerParameters(SchedParameter[] schedParameterArray) throws LibvirtException {
        virSchedParameter[] virSchedParameterArray = new virSchedParameter[schedParameterArray.length];
        for (int i = 0; i < schedParameterArray.length; ++i) {
            virSchedParameterArray[i] = SchedParameter.toNative(schedParameterArray[i]);
        }
        this.libvirt.virDomainSetSchedulerParameters(this.VDP, virSchedParameterArray, schedParameterArray.length);
        this.processError();
    }

    public void setVcpus(int n) throws LibvirtException {
        this.libvirt.virDomainSetVcpus(this.VDP, n);
        this.processError();
    }

    public void shutdown() throws LibvirtException {
        this.libvirt.virDomainShutdown(this.VDP);
        this.processError();
    }

    public DomainSnapshot snapshotCreateXML(String string) throws LibvirtException {
        DomainSnapshotPointer domainSnapshotPointer = this.libvirt.virDomainSnapshotCreateXML(this.VDP, string, 0);
        this.processError();
        DomainSnapshot domainSnapshot = null;
        if (domainSnapshotPointer != null) {
            domainSnapshot = new DomainSnapshot(this.virConnect, domainSnapshotPointer);
        }
        return domainSnapshot;
    }

    public DomainSnapshot snapshotCurrent() throws LibvirtException {
        DomainSnapshotPointer domainSnapshotPointer = this.libvirt.virDomainSnapshotCurrent(this.VDP, 0);
        this.processError();
        DomainSnapshot domainSnapshot = null;
        if (domainSnapshotPointer != null) {
            domainSnapshot = new DomainSnapshot(this.virConnect, domainSnapshotPointer);
        }
        return domainSnapshot;
    }

    public String[] snapshotListNames() throws LibvirtException {
        String[] stringArray = null;
        int n = this.snapshotNum();
        if (n >= 0) {
            stringArray = new String[n];
            if (n > 0) {
                this.libvirt.virDomainSnapshotListNames(this.VDP, stringArray, n, 0);
                this.processError();
            }
        }
        return stringArray;
    }

    public DomainSnapshot snapshotLookupByName(String string) throws LibvirtException {
        DomainSnapshotPointer domainSnapshotPointer = this.libvirt.virDomainSnapshotLookupByName(this.VDP, string, 0);
        this.processError();
        DomainSnapshot domainSnapshot = null;
        if (domainSnapshotPointer != null) {
            domainSnapshot = new DomainSnapshot(this.virConnect, domainSnapshotPointer);
        }
        return domainSnapshot;
    }

    public int snapshotNum() throws LibvirtException {
        int n = this.libvirt.virDomainSnapshotNum(this.VDP, 0);
        this.processError();
        return n;
    }

    public void suspend() throws LibvirtException {
        this.libvirt.virDomainSuspend(this.VDP);
        this.processError();
    }

    public void undefine() throws LibvirtException {
        this.libvirt.virDomainUndefine(this.VDP);
        this.processError();
    }

    public int updateDeviceFlags(String string, int n) throws LibvirtException {
        int n2 = this.libvirt.virDomainUpdateDeviceFlags(this.VDP, string, n);
        this.processError();
        return n2;
    }

    static final class XMLFlags {
        static final int VIR_DOMAIN_XML_SECURE = 1;
        static final int VIR_DOMAIN_XML_INACTIVE = 2;

        XMLFlags() {
        }
    }

    static final class MigrateFlags {
        static final int VIR_MIGRATE_LIVE = 1;

        MigrateFlags() {
        }
    }

    static final class CreateFlags {
        static final int VIR_DOMAIN_NONE = 0;

        CreateFlags() {
        }
    }
}

