/*
 * Decompiled with CFR 0.152.
 */
package org.libvirt;

import org.libvirt.Connect;
import org.libvirt.LibvirtException;
import org.libvirt.jna.DomainSnapshotPointer;
import org.libvirt.jna.Libvirt;

public class DomainSnapshot {
    DomainSnapshotPointer VDSP;
    private Connect virConnect;
    protected Libvirt libvirt;

    public DomainSnapshot(Connect connect, DomainSnapshotPointer domainSnapshotPointer) {
        this.VDSP = domainSnapshotPointer;
        this.virConnect = connect;
        this.libvirt = connect.libvirt;
    }

    public int delete(int n) throws LibvirtException {
        int n2 = 0;
        if (this.VDSP != null) {
            n2 = this.libvirt.virDomainSnapshotDelete(this.VDSP, n);
            this.processError();
            this.VDSP = null;
        }
        return n2;
    }

    public void finalize() throws LibvirtException {
        this.free();
    }

    public int free() throws LibvirtException {
        int n = 0;
        if (this.VDSP != null) {
            n = this.libvirt.virDomainSnapshotFree(this.VDSP);
            this.processError();
            this.VDSP = null;
        }
        return n;
    }

    public String getXMLDesc() throws LibvirtException {
        String string = this.libvirt.virDomainSnapshotGetXMLDesc(this.VDSP, 0);
        this.processError();
        return string;
    }

    protected void processError() throws LibvirtException {
        this.virConnect.processError();
    }
}

